/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import java.util.Comparator;
import jdbm.btree.BTree;
import jdbm.helper.TupleBrowser;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTupleBTreeCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final Comparator<V> comparator;
    private final BTree btree;
    private final K key;
    private jdbm.helper.Tuple<K, V> valueTuple = new jdbm.helper.Tuple();
    private Tuple<K, V> returnedTuple = new Tuple();
    private TupleBrowser<K, V> browser;
    private boolean valueAvailable;

    public KeyTupleBTreeCursor(BTree btree, K key, Comparator<V> comparator) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating KeyTupleBTreeCursor {}", (Object)this);
        }
        this.key = key;
        this.btree = btree;
        this.comparator = comparator;
        this.browser = btree.browse();
    }

    private void clearValue() {
        this.returnedTuple.setKey(this.key);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void afterKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void beforeValue(K key, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
        }
        this.browser = this.btree.browse(value);
        this.clearValue();
    }

    public void afterValue(K key, V value) throws LdapException, CursorException {
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
        }
        try {
            this.browser = this.btree.browse(value);
            while (this.browser.getNext(this.valueTuple)) {
                this.checkNotClosed("afterValue");
                Object next = this.valueTuple.getKey();
                int nextCompared = this.comparator.compare(next, value);
                if (nextCompared <= 0) continue;
                if (!this.browser.getPrevious(this.valueTuple)) {
                    this.browser = this.btree.browse(this.key);
                }
                this.clearValue();
                return;
            }
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public void before(Tuple<K, V> element) throws LdapException, CursorException {
        this.checkNotClosed("before()");
        try {
            this.browser = this.btree.browse(element.getValue());
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public void after(Tuple<K, V> element) throws LdapException, CursorException {
        this.afterValue(this.key, element.getValue());
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed("beforeFirst()");
        try {
            this.browser = this.btree.browse();
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed("afterLast()");
        try {
            this.browser = this.btree.browse(null);
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed("previous()");
        try {
            if (this.browser.getPrevious(this.valueTuple)) {
                if (this.returnedTuple.getValue() != null && this.comparator.compare(this.valueTuple.getKey(), this.returnedTuple.getValue()) == 0) {
                    this.browser.getPrevious(this.valueTuple);
                }
                this.returnedTuple.setKey(this.key);
                this.returnedTuple.setValue(this.valueTuple.getKey());
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed("next()");
        try {
            if (this.browser.getNext(this.valueTuple)) {
                if (this.returnedTuple.getValue() != null && this.comparator.compare(this.valueTuple.getKey(), this.returnedTuple.getValue()) == 0) {
                    this.browser.getNext(this.valueTuple);
                }
                this.returnedTuple.setKey(this.key);
                this.returnedTuple.setValue(this.valueTuple.getKey());
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public Tuple<K, V> get() throws CursorException {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleBTreeCursor {}", (Object)this);
        }
        super.close();
    }

    public void close(Exception cause) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleBTreeCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

