/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.directory.server.InstallationLayout;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.Target;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractMojoCommand<T extends Target> {
    protected Properties filterProperties = new Properties(System.getProperties());
    protected GenerateMojo mojo;
    protected T target;
    protected Log log;
    protected static final String LOG4J_PROPERTIES_FILE = "log4j.properties";
    protected static final String CONFIG_LDIF_FILE = "config.ldif";
    protected static final String WRAPPER_INSTANCE_CONF_FILE = "wrapper-instance.conf";
    protected static final String DEFAULT = "default";
    protected static final String INSTANCES = "instances";
    protected static final String INSTANCE_DEFAULT_DIR = "instances/default";
    protected static final String APACHEDS = "apacheds";
    protected static final String APACHEDS_DASH = "apacheds-";
    protected static final String CHMOD = "chmod";
    protected static final String RWX_RX_RX = "755";
    protected static final String OS_NAME = "os.name";
    protected static final String INSTALLERS_PATH = "/org/apache/directory/server/installers/";
    protected static final String WRAPPER_JAVA_COMMAND = "# wrapper.java.command=<path-to-java-executable>";
    protected static final String ARCH_PROP = "arch";
    protected static final String INSTALLATION_DIRECTORY_PROP = "installation.directory";
    protected static final String INSTANCES_DIRECTORY_PROP = "instances.directory";
    protected static final String DOUBLE_QUOTE_PROP = "double.quote";
    protected static final String USER_PROP = "user";
    protected static final String GROUP_PROP = "group";
    protected static final String WRAPPER_JAVA_COMMAND_PROP = "wrapper.java.command";
    protected static final String FINAL_NAME_PROP = "finalName";
    protected static final String VERSION_PROP = "version";

    public AbstractMojoCommand(GenerateMojo mojo, T target) {
        this.mojo = mojo;
        this.target = target;
        this.log = mojo.getLog();
    }

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    public Properties getFilterProperties() {
        return this.filterProperties;
    }

    protected void initializeFilterProperties() {
        this.filterProperties.putAll((Map<?, ?>)this.mojo.getProject().getProperties());
    }

    public abstract File getInstallationDirectory();

    public abstract File getInstanceDirectory();

    protected File getTargetDirectory() {
        return new File(this.mojo.getOutputDirectory(), ((Target)this.target).getId());
    }

    public void createLayouts() throws MojoFailureException, IOException {
        this.createLayouts(true);
    }

    public void createLayouts(boolean includeWrapperDependencies) throws MojoFailureException, IOException {
        this.log.info((CharSequence)"Creating the installation layout");
        this.createInstallationLayout(includeWrapperDependencies);
        this.log.info((CharSequence)"Creating the instance layout");
        this.createInstanceLayout();
    }

    protected void createInstallationLayout() throws MojoFailureException, IOException {
        this.createInstallationLayout(true);
    }

    protected void createInstallationLayout(boolean includeWrapperDependencies) throws MojoFailureException, IOException {
        InstallationLayout installationLayout = this.getInstallationLayout();
        installationLayout.mkdirs();
        MojoHelperUtils.copyDependencies(this.mojo, installationLayout, includeWrapperDependencies);
        MojoHelperUtils.copyBinaryFile(this.mojo, "/org/apache/directory/server/installers/LICENSE", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/LICENSE"), new File(installationLayout.getInstallationDirectory(), "LICENSE"));
        MojoHelperUtils.copyBinaryFile(this.mojo, "/org/apache/directory/server/installers/NOTICE", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/NOTICE"), new File(installationLayout.getInstallationDirectory(), "NOTICE"));
        if (((Target)this.target).isOsNameLinux() || ((Target)this.target).isOsNameSolaris() || ((Target)this.target).isOsNameMacOSX()) {
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/apacheds", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/apacheds"), new File(installationLayout.getBinDirectory(), APACHEDS), true);
            MojoHelperUtils.exec(new String[]{CHMOD, RWX_RX_RX, APACHEDS}, installationLayout.getBinDirectory(), false);
        }
        this.copyWrapperFiles(this.mojo);
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/wrapper-installation.conf", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper-installation.conf"), new File(installationLayout.getConfDirectory(), "wrapper.conf"), true);
    }

    public abstract void copyWrapperFiles(GenerateMojo var1) throws MojoFailureException;

    protected void createInstanceLayout() throws IOException {
        InstanceLayout instanceLayout = this.getInstanceLayout();
        instanceLayout.mkdirs();
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/log4j.properties", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/log4j.properties"), new File(instanceLayout.getConfDirectory(), LOG4J_PROPERTIES_FILE), true);
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/wrapper-instance.conf", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper-instance.conf"), new File(instanceLayout.getConfDirectory(), WRAPPER_INSTANCE_CONF_FILE), true);
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/config.ldif", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/config.ldif"), new File(instanceLayout.getConfDirectory(), CONFIG_LDIF_FILE), false);
    }

    protected InstallationLayout getInstallationLayout() {
        return new InstallationLayout(this.getInstallationDirectory());
    }

    protected InstanceLayout getInstanceLayout() {
        File instanceDirectory = this.getInstanceDirectory();
        return new InstanceLayout(instanceDirectory);
    }
}

