/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.deb;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.LinuxInstallerCommand;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.deb.DebTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Execute;

public class DebInstallerCommand
extends LinuxInstallerCommand<DebTarget> {
    private static final String DEBIAN_DIR = "DEBIAN";
    private static final String CONTROL_FILE = "control";
    private static final String POSTINST_FILE = "postinst";
    private static final String PRERM_FILE = "prerm";
    private static final String DOT_DEB_EXTENSION = ".deb";
    private static final String DEB_EXTENSION = "deb";
    private static final String DASH_DEFAULT = "-default";
    private static final String ETC_INITD = "etc/init.d";

    public DebInstallerCommand(GenerateMojo mojo, DebTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        this.log.info((CharSequence)"  Creating Deb installer...");
        File targetDirectory = this.getTargetDirectory();
        this.log.info((CharSequence)("Creating target directory : " + targetDirectory.getAbsolutePath()));
        if (!this.getTargetDirectory().mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{this.getTargetDirectory()}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        this.log.info((CharSequence)"    Copying Deb installer files");
        try {
            this.createLayouts();
            File debEtcInitdDirectory = new File(this.getDebDirectory(), ETC_INITD);
            if (!debEtcInitdDirectory.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{debEtcInitdDirectory}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/etc-initd-script", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/etc-initd-script"), new File(debEtcInitdDirectory, "apacheds-" + this.mojo.getProject().getVersion() + DASH_DEFAULT), true);
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy Deb installer files.");
        }
        File debDebianDirectory = new File(this.getDebDirectory(), DEBIAN_DIR);
        if (!debDebianDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{debDebianDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        try {
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, CONTROL_FILE, this.getClass().getResourceAsStream(CONTROL_FILE), new File(debDebianDirectory, CONTROL_FILE), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, POSTINST_FILE, this.getClass().getResourceAsStream(POSTINST_FILE), new File(debDebianDirectory, POSTINST_FILE), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, PRERM_FILE, this.getClass().getResourceAsStream(PRERM_FILE), new File(debDebianDirectory, PRERM_FILE), true);
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy DEB 'control' file.");
        }
        MojoHelperUtils.exec(new String[]{"chmod", "755", new File(debDebianDirectory, POSTINST_FILE).toString()}, debDebianDirectory, false);
        MojoHelperUtils.exec(new String[]{"chmod", "755", new File(debDebianDirectory, PRERM_FILE).toString()}, debDebianDirectory, false);
        this.log.info((CharSequence)"    Generating Deb installer");
        String finalName = ((DebTarget)this.target).getFinalName();
        if (!finalName.endsWith(DOT_DEB_EXTENSION)) {
            finalName = finalName + DOT_DEB_EXTENSION;
        }
        Execute createDebTask = new Execute();
        String[] cmd = new String[]{this.mojo.getDpkgUtility().getAbsolutePath(), "-b", this.getTargetDirectory().getName() + "/" + this.getDebDirectory().getName(), finalName};
        StringBuilder antTask = new StringBuilder();
        for (String command : cmd) {
            antTask.append(command).append(" ");
        }
        this.log.info((CharSequence)("Executing the ant task with command : " + antTask.toString() + " into directory " + this.mojo.getOutputDirectory()));
        createDebTask.setCommandline(cmd);
        createDebTask.setWorkingDirectory(this.mojo.getOutputDirectory());
        try {
            createDebTask.execute();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed while trying to generate the DEB package: " + e.getMessage());
        }
        this.log.info((CharSequence)("Debian DEB package generated at " + new File(this.mojo.getOutputDirectory(), finalName)));
    }

    private boolean verifyTarget() {
        if (!((DebTarget)this.target).isOsNameLinux()) {
            this.log.warn((CharSequence)"Deb package installer can only be targeted for Linux platforms!");
            this.log.warn((CharSequence)"The build will continue, but please check the the platform of this installer target");
            return false;
        }
        String osName = System.getProperty("os.name");
        if (!"Linux".equalsIgnoreCase(osName) && !"Mac OS X".equalsIgnoreCase(osName)) {
            this.log.warn((CharSequence)"Deb package installer can only be built on a machine running Linux or Mac OS X!");
            this.log.warn((CharSequence)"The build will continue, generation of this target is skipped.");
            return false;
        }
        if (!this.mojo.getDpkgUtility().exists()) {
            this.log.warn((CharSequence)("Cannot find dpkg utility at this location: " + this.mojo.getDpkgUtility()));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your dpkg utility.");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
        String version = this.mojo.getProject().getVersion();
        if (version != null) {
            if (version.endsWith("-SNAPSHOT")) {
                this.filterProperties.put("version.debian", version + "1");
            } else {
                this.filterProperties.put("version.debian", version);
            }
        }
        this.filterProperties.put("arch", ((DebTarget)this.target).getOsArch());
        this.filterProperties.put("installation.directory", "/opt/apacheds-" + this.mojo.getProject().getVersion());
        this.filterProperties.put("instances.directory", "/var/lib/apacheds-" + this.mojo.getProject().getVersion());
        this.filterProperties.put("user", "apacheds");
        this.filterProperties.put("group", "apacheds");
        this.filterProperties.put("wrapper.java.command", "# wrapper.java.command=<path-to-java-executable>");
        this.filterProperties.put("double.quote", "");
        this.filterProperties.put("default.instance.name", "default");
    }

    @Override
    public File getInstallationDirectory() {
        return new File(this.getDebDirectory(), "/opt/apacheds-" + this.mojo.getProject().getVersion());
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getDebDirectory(), "/var/lib/apacheds-" + this.mojo.getProject().getVersion() + "/" + "default");
    }

    private File getDebDirectory() {
        return new File(this.getTargetDirectory(), DEB_EXTENSION);
    }
}

