/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integration.http;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.integration.http.WebApp;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServer {
    private Server jetty;
    private String confFile;
    private Set<WebApp> webApps;
    private int port = 8080;
    private boolean configured = false;
    private static final Logger LOG = LoggerFactory.getLogger(HttpServer.class);

    public void start() throws Exception {
        if (this.confFile == null && (this.webApps == null || this.webApps.isEmpty())) {
            LOG.warn("Neither configuration file nor web apps were configured for the http server, skipping initialization.");
            return;
        }
        XmlConfiguration jettyConf = null;
        if (this.confFile != null) {
            jettyConf = new XmlConfiguration((InputStream)new FileInputStream(this.confFile));
            LOG.info("configuring jetty http server from the configuration file {}", (Object)this.confFile);
            try {
                this.jetty = new Server();
                jettyConf.configure((Object)this.jetty);
                this.configured = true;
            }
            catch (Exception e) {
                LOG.error(I18n.err((String)I18n.ERR_120, (Object[])new Object[0]));
                throw e;
            }
        } else {
            LOG.info("No configuration file set, looking for web apps");
            this.configureServerThroughCode();
        }
        if (this.configured) {
            LOG.info("starting jetty http server");
            this.jetty.start();
        } else {
            this.jetty = null;
            LOG.warn("Error while configuring the http server, skipping the http server startup");
        }
    }

    private void configureServerThroughCode() {
        try {
            this.jetty = new Server();
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(this.port);
            this.jetty.setConnectors(new Connector[]{connector});
            ArrayList<WebAppContext> handlers = new ArrayList<WebAppContext>();
            for (WebApp w : this.webApps) {
                WebAppContext webapp = new WebAppContext();
                webapp.setWar(w.getWarFile());
                webapp.setContextPath(w.getContextPath());
                handlers.add(webapp);
            }
            this.jetty.setHandlers(handlers.toArray(new Handler[handlers.size()]));
            this.configured = true;
        }
        catch (Exception e) {
            LOG.error(I18n.err((String)I18n.ERR_121, (Object[])new Object[0]), (Throwable)e);
        }
    }

    public void stop() throws Exception {
        if (this.jetty != null && this.jetty.isStarted()) {
            LOG.info("stopping jetty http server");
            this.jetty.stop();
        }
    }

    public void setConfFile(String confFile) {
        this.confFile = confFile;
    }

    public Set<WebApp> getWebApps() {
        return this.webApps;
    }

    public void setWebApps(Set<WebApp> webapps) {
        this.webApps = webapps;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

