/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

public enum Option {
    HELP("-h", "Prints the details of the options"),
    INPUT_FILE("-i", "Path of the LDIF file to be used as input"),
    OUT_DIR("-o", "Path of the directory where the data files will be stored"),
    CLEAN_OUT_DIR("-clean", "Deletes the output directory's contents if present"),
    NUM_KEYS_PER_NODE("-n", "(optional) The number of keys to be present in each node, default is 16"),
    DS_RID("-rid", "(optional) The RID value to be used in the entryCSN values, default is 1"),
    VERIFY_MASTER_TABLE("-verify", "(optional) Verifies the master table by just browsing (entries are not verified)"),
    UNKNOWN(null, "Unknown Option");

    private String text;
    private String desc;

    private Option(String text, String desc) {
        this.text = text;
        this.desc = desc;
    }

    public String getText() {
        return this.text;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Option getOpt(String opt) {
        if (opt == null) {
            return UNKNOWN;
        }
        if ((opt = opt.trim()).equalsIgnoreCase(Option.HELP.text)) {
            return HELP;
        }
        if (opt.equalsIgnoreCase(Option.VERIFY_MASTER_TABLE.text)) {
            return VERIFY_MASTER_TABLE;
        }
        if (opt.equalsIgnoreCase(Option.INPUT_FILE.text)) {
            return INPUT_FILE;
        }
        if (opt.equalsIgnoreCase(Option.OUT_DIR.text)) {
            return OUT_DIR;
        }
        if (opt.equalsIgnoreCase(Option.CLEAN_OUT_DIR.text)) {
            return CLEAN_OUT_DIR;
        }
        if (opt.equalsIgnoreCase(Option.NUM_KEYS_PER_NODE.text)) {
            return NUM_KEYS_PER_NODE;
        }
        return UNKNOWN;
    }
}

