/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap.partition;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueResourceException
extends RuntimeException {
    public static final long serialVersionUID = 1L;
    private final String resourceName;
    private final List<URL> urls;
    private final String resourceDescription;

    public UniqueResourceException(String resourceName, String resourceDescription) {
        this(resourceName, null, resourceDescription);
    }

    public UniqueResourceException(String resourceName, List<URL> urls, String resourceDescription) {
        this.resourceName = resourceName;
        this.urls = urls;
        this.resourceDescription = resourceDescription;
    }

    public UniqueResourceException(String resourceName, URL first, Enumeration<URL> urlEnum, String resourceDescription) {
        this(resourceName, UniqueResourceException.toList(first, urlEnum), resourceDescription);
    }

    private static List<URL> toList(URL first, Enumeration<URL> urlEnum) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(first);
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        return urls;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer("Problem locating ").append(this.resourceDescription).append("\n");
        if (this.urls == null) {
            buf.append("No resources named '").append(this.resourceName).append("' located on classpath");
        } else {
            buf.append("Multiple copies of resource named '").append(this.resourceName).append("' located on classpath at urls");
            for (URL url : this.urls) {
                buf.append("\n    ").append(url);
            }
        }
        return buf.toString();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public List<URL> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }
}

