/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.avl;

import java.util.Comparator;
import org.apache.directory.server.core.avltree.AvlSingletonOrOrderedSetCursor;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeCursor;
import org.apache.directory.server.core.avltree.AvlTreeMap;
import org.apache.directory.server.core.avltree.AvlTreeMapImpl;
import org.apache.directory.server.core.avltree.AvlTreeMapNoDupsWrapperCursor;
import org.apache.directory.server.core.avltree.KeyTupleAvlCursor;
import org.apache.directory.server.core.avltree.LinkedAvlMapNode;
import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;
import org.apache.directory.server.core.partition.avl.AvlTableDupsCursor;
import org.apache.directory.server.xdbm.Table;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.cursor.SingletonCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlTable<K, V>
implements Table<K, V> {
    private final AvlTreeMap<K, V> avl;
    private final String name;
    private final Comparator<K> keyComparator;
    private final Comparator<V> valComparator;
    private final Comparator<Tuple<K, V>> keyOnlytupleComparator;
    private int count;

    public AvlTable(String name, final Comparator<K> keyComparator, Comparator<V> valComparator, boolean dupsEnabled) {
        this.name = name;
        this.keyComparator = keyComparator;
        this.valComparator = valComparator;
        this.avl = new AvlTreeMapImpl(keyComparator, valComparator, dupsEnabled);
        this.keyOnlytupleComparator = new Comparator<Tuple<K, V>>(){

            @Override
            public int compare(Tuple<K, V> t0, Tuple<K, V> t1) {
                return keyComparator.compare(t0.getKey(), t1.getKey());
            }
        };
    }

    public void close() throws Exception {
    }

    public int count() throws Exception {
        return this.count;
    }

    public int count(K key) throws Exception {
        if (key == null) {
            return 0;
        }
        LinkedAvlMapNode node = this.avl.find(key);
        if (node == null) {
            return 0;
        }
        SingletonOrOrderedSet val = node.getValue();
        if (val.isOrderedSet()) {
            return val.getOrderedSet().getSize();
        }
        return 1;
    }

    public V get(K key) throws Exception {
        if (key == null) {
            return null;
        }
        LinkedAvlMapNode node = this.avl.find(key);
        if (node == null) {
            return null;
        }
        SingletonOrOrderedSet val = node.getValue();
        if (val.isOrderedSet()) {
            return (V)val.getOrderedSet().getFirst().getKey();
        }
        return (V)val.getSingleton();
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public Comparator<V> getValueComparator() {
        return this.valComparator;
    }

    public String getName() {
        return this.name;
    }

    public int greaterThanCount(K key) throws Exception {
        return this.avl.getSize();
    }

    public boolean has(K key) throws Exception {
        if (key == null) {
            return false;
        }
        return this.avl.find(key) != null;
    }

    public boolean has(K key, V value) throws Exception {
        if (key == null) {
            return false;
        }
        return this.avl.find(key, value) != null;
    }

    public boolean hasGreaterOrEqual(K key) throws Exception {
        if (key == null) {
            return false;
        }
        return this.avl.findGreaterOrEqual(key) != null;
    }

    public boolean hasGreaterOrEqual(K key, V val) throws Exception {
        if (key == null) {
            return false;
        }
        LinkedAvlMapNode node = this.avl.findGreaterOrEqual(key);
        if (node == null) {
            return false;
        }
        if (node.getValue().isOrderedSet()) {
            AvlTree values = node.getValue().getOrderedSet();
            return values.findGreaterOrEqual(val) != null;
        }
        return this.valComparator.compare(node.getValue().getSingleton(), val) >= 0;
    }

    public boolean hasLessOrEqual(K key) throws Exception {
        if (key == null) {
            return false;
        }
        return this.avl.findLessOrEqual(key) != null;
    }

    public boolean hasLessOrEqual(K key, V val) throws Exception {
        if (key == null) {
            return false;
        }
        LinkedAvlMapNode node = this.avl.findLessOrEqual(key);
        if (node == null) {
            return false;
        }
        if (node.getValue().isOrderedSet()) {
            AvlTree values = node.getValue().getOrderedSet();
            return values.findLessOrEqual(val) != null;
        }
        return this.valComparator.compare(node.getValue().getSingleton(), val) <= 0;
    }

    public boolean isCountExact() {
        return false;
    }

    public boolean isDupsEnabled() {
        return this.avl.isDupsAllowed();
    }

    public int lessThanCount(K key) throws Exception {
        return this.count;
    }

    public void put(K key, V value) throws Exception {
        if (key == null || value == null) {
            return;
        }
        if (this.avl.insert(key, value) == null) {
            ++this.count;
        }
    }

    public void remove(K key) throws Exception {
        if (key == null) {
            return;
        }
        SingletonOrOrderedSet value = this.avl.remove(key);
        if (value == null) {
            return;
        }
        this.count = value.isOrderedSet() ? (this.count -= value.getOrderedSet().getSize()) : --this.count;
    }

    public void remove(K key, V value) throws Exception {
        if (this.avl.remove(key, value) != null) {
            --this.count;
        }
    }

    public Cursor<Tuple<K, V>> cursor() throws Exception {
        if (!this.avl.isDupsAllowed()) {
            return new AvlTreeMapNoDupsWrapperCursor(new AvlSingletonOrOrderedSetCursor(this.avl));
        }
        return new AvlTableDupsCursor(this);
    }

    public Cursor<Tuple<K, V>> cursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor();
        }
        LinkedAvlMapNode node = this.avl.find(key);
        if (node == null) {
            return new EmptyCursor();
        }
        if (node.getValue().isOrderedSet()) {
            return new KeyTupleAvlCursor(node.getValue().getOrderedSet(), key);
        }
        return new SingletonCursor((Object)new Tuple(key, node.getValue().getSingleton()), this.keyOnlytupleComparator);
    }

    public Cursor<V> valueCursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor();
        }
        LinkedAvlMapNode node = this.avl.find(key);
        if (node == null) {
            return new EmptyCursor();
        }
        if (node.getValue().isOrderedSet()) {
            return new AvlTreeCursor(node.getValue().getOrderedSet());
        }
        return new SingletonCursor(node.getValue().getSingleton(), this.valComparator);
    }

    AvlTreeMap<K, V> getAvlTreeMap() {
        return this.avl;
    }
}

