/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.executor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.DummySession;
import org.apache.mina.core.session.IoEvent;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.executor.IoEventQueueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PriorityThreadPoolExecutor.class);
    private static final AtomicLong seq = new AtomicLong(0L);
    private static final int DEFAULT_INITIAL_THREAD_POOL_SIZE = 0;
    private static final int DEFAULT_MAX_THREAD_POOL = 16;
    private static final int DEFAULT_KEEP_ALIVE = 30;
    private static final SessionEntry EXIT_SIGNAL = new SessionEntry(new DummySession(), null);
    private static final AttributeKey TASKS_QUEUE = new AttributeKey(PriorityThreadPoolExecutor.class, "tasksQueue");
    private final BlockingQueue<SessionEntry> waitingSessions;
    private final Set<Worker> workers = new HashSet<Worker>();
    private volatile int largestPoolSize;
    private final AtomicInteger idleWorkers = new AtomicInteger();
    private long completedTaskCount;
    private volatile boolean shutdown;
    private final IoEventQueueHandler eventQueueHandler;
    private final Comparator<IoSession> comparator;

    public PriorityThreadPoolExecutor() {
        this(0, 16, 30L, TimeUnit.SECONDS, Executors.defaultThreadFactory(), null, null);
    }

    public PriorityThreadPoolExecutor(Comparator<IoSession> comparator) {
        this(0, 16, 30L, TimeUnit.SECONDS, Executors.defaultThreadFactory(), null, comparator);
    }

    public PriorityThreadPoolExecutor(int maximumPoolSize) {
        this(0, maximumPoolSize, 30L, TimeUnit.SECONDS, Executors.defaultThreadFactory(), null, null);
    }

    public PriorityThreadPoolExecutor(int maximumPoolSize, Comparator<IoSession> comparator) {
        this(0, maximumPoolSize, 30L, TimeUnit.SECONDS, Executors.defaultThreadFactory(), null, comparator);
    }

    public PriorityThreadPoolExecutor(int minimumPoolSize, int maximumPoolSize) {
        this(minimumPoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS, Executors.defaultThreadFactory(), null, null);
    }

    public PriorityThreadPoolExecutor(int minimumPoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(minimumPoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory(), null, null);
    }

    public PriorityThreadPoolExecutor(int minimumPoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, IoEventQueueHandler eventQueueHandler) {
        this(minimumPoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory(), eventQueueHandler, null);
    }

    public PriorityThreadPoolExecutor(int minimumPoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this(minimumPoolSize, maximumPoolSize, keepAliveTime, unit, threadFactory, null, null);
    }

    public PriorityThreadPoolExecutor(int minimumPoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, IoEventQueueHandler eventQueueHandler, Comparator<IoSession> comparator) {
        super(0, 1, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
        if (minimumPoolSize < 0) {
            throw new IllegalArgumentException("minimumPoolSize: " + minimumPoolSize);
        }
        if (maximumPoolSize <= 0 || maximumPoolSize < minimumPoolSize) {
            throw new IllegalArgumentException("maximumPoolSize: " + maximumPoolSize);
        }
        super.setMaximumPoolSize(maximumPoolSize);
        super.setCorePoolSize(minimumPoolSize);
        this.eventQueueHandler = eventQueueHandler == null ? IoEventQueueHandler.NOOP : eventQueueHandler;
        this.comparator = comparator;
        this.waitingSessions = this.comparator == null ? new LinkedBlockingQueue<SessionEntry>() : new PriorityBlockingQueue<SessionEntry>();
    }

    private SessionQueue getSessionTasksQueue(IoSession session) {
        SessionQueue oldQueue;
        SessionQueue queue = (SessionQueue)session.getAttribute(TASKS_QUEUE);
        if (queue == null && (oldQueue = (SessionQueue)session.setAttributeIfAbsent(TASKS_QUEUE, queue = new SessionQueue())) != null) {
            queue = oldQueue;
        }
        return queue;
    }

    public IoEventQueueHandler getQueueHandler() {
        return this.eventQueueHandler;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorker() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() >= super.getMaximumPoolSize()) {
                return;
            }
            Worker worker = new Worker();
            Thread thread = this.getThreadFactory().newThread(worker);
            this.workers.add(worker);
            this.idleWorkers.incrementAndGet();
            thread.start();
            if (this.workers.size() > this.largestPoolSize) {
                this.largestPoolSize = this.workers.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkerIfNecessary() {
        if (this.idleWorkers.get() == 0) {
            Set<Worker> set = this.workers;
            synchronized (set) {
                if (this.workers.isEmpty() || this.idleWorkers.get() == 0) {
                    this.addWorker();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWorker() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() <= super.getCorePoolSize()) {
                return;
            }
            this.waitingSessions.offer(EXIT_SIGNAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < super.getCorePoolSize()) {
            throw new IllegalArgumentException("maximumPoolSize: " + maximumPoolSize);
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            super.setMaximumPoolSize(maximumPoolSize);
            for (int difference = this.workers.size() - maximumPoolSize; difference > 0; --difference) {
                this.removeWorker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        Set<Worker> set = this.workers;
        synchronized (set) {
            long waitTime;
            while (!this.isTerminated() && (waitTime = deadline - System.currentTimeMillis()) > 0L) {
                this.workers.wait(waitTime);
            }
        }
        return this.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        if (!this.shutdown) {
            return false;
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Set<Worker> set = this.workers;
        synchronized (set) {
            for (int i2 = this.workers.size(); i2 > 0; --i2) {
                this.waitingSessions.offer(EXIT_SIGNAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        SessionEntry entry;
        this.shutdown();
        ArrayList<Runnable> answer = new ArrayList<Runnable>();
        while ((entry = (SessionEntry)this.waitingSessions.poll()) != null) {
            if (entry == EXIT_SIGNAL) {
                this.waitingSessions.offer(EXIT_SIGNAL);
                Thread.yield();
                continue;
            }
            SessionQueue sessionTasksQueue = (SessionQueue)entry.getSession().getAttribute(TASKS_QUEUE);
            Queue queue = sessionTasksQueue.tasksQueue;
            synchronized (queue) {
                for (Runnable task : sessionTasksQueue.tasksQueue) {
                    this.getQueueHandler().polled(this, (IoEvent)task);
                    answer.add(task);
                }
                sessionTasksQueue.tasksQueue.clear();
            }
        }
        return answer;
    }

    private void print(Queue<Runnable> queue, IoEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append("Adding event ").append((Object)event.getType()).append(" to session ").append(event.getSession().getId());
        boolean first = true;
        sb.append("\nQueue : [");
        for (Runnable elem : queue) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append((Object)((IoEvent)elem).getType()).append(", ");
        }
        sb.append("]\n");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        boolean offerSession;
        if (this.shutdown) {
            this.rejectTask(task);
        }
        this.checkTaskType(task);
        IoEvent event = (IoEvent)task;
        IoSession session = event.getSession();
        SessionQueue sessionTasksQueue = this.getSessionTasksQueue(session);
        Queue tasksQueue = sessionTasksQueue.tasksQueue;
        boolean offerEvent = this.eventQueueHandler.accept(this, event);
        if (offerEvent) {
            Queue queue = tasksQueue;
            synchronized (queue) {
                tasksQueue.offer(event);
                if (sessionTasksQueue.processingCompleted) {
                    sessionTasksQueue.processingCompleted = false;
                    offerSession = true;
                } else {
                    offerSession = false;
                }
                if (LOGGER.isDebugEnabled()) {
                    this.print(tasksQueue, event);
                }
            }
        } else {
            offerSession = false;
        }
        if (offerSession) {
            this.waitingSessions.offer(new SessionEntry(session, this.comparator));
        }
        this.addWorkerIfNecessary();
        if (offerEvent) {
            this.eventQueueHandler.offered(this, event);
        }
    }

    private void rejectTask(Runnable task) {
        this.getRejectedExecutionHandler().rejectedExecution(task, this);
    }

    private void checkTaskType(Runnable task) {
        if (!(task instanceof IoEvent)) {
            throw new IllegalArgumentException("task must be an IoEvent or its subclass.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.size() - this.idleWorkers.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompletedTaskCount() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            long answer = this.completedTaskCount;
            for (Worker w : this.workers) {
                answer += w.completedTaskCount.get();
            }
            return answer;
        }
    }

    @Override
    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolSize() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.size();
        }
    }

    @Override
    public long getTaskCount() {
        return this.getCompletedTaskCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminating() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.isShutdown() && !this.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prestartAllCoreThreads() {
        int answer = 0;
        Set<Worker> set = this.workers;
        synchronized (set) {
            for (int i2 = super.getCorePoolSize() - this.workers.size(); i2 > 0; --i2) {
                this.addWorker();
                ++answer;
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prestartCoreThread() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() < super.getCorePoolSize()) {
                this.addWorker();
                return true;
            }
            return false;
        }
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void purge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Runnable task) {
        boolean removed;
        Queue tasksQueue;
        this.checkTaskType(task);
        IoEvent event = (IoEvent)task;
        IoSession session = event.getSession();
        SessionQueue sessionTasksQueue = (SessionQueue)session.getAttribute(TASKS_QUEUE);
        if (sessionTasksQueue == null) {
            return false;
        }
        Queue queue = tasksQueue = sessionTasksQueue.tasksQueue;
        synchronized (queue) {
            removed = tasksQueue.remove(task);
        }
        if (removed) {
            this.getQueueHandler().polled(this, event);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorePoolSize(int minimumPoolSize) {
        if (minimumPoolSize < 0) {
            throw new IllegalArgumentException("minimumPoolSize: " + minimumPoolSize);
        }
        if (minimumPoolSize > super.getMaximumPoolSize()) {
            throw new IllegalArgumentException("minimumPoolSize exceeds maximumPoolSize");
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (super.getCorePoolSize() > minimumPoolSize) {
                for (int i2 = super.getCorePoolSize() - minimumPoolSize; i2 > 0; --i2) {
                    this.removeWorker();
                }
            }
            super.setCorePoolSize(minimumPoolSize);
        }
    }

    static class SessionEntry
    implements Comparable<SessionEntry> {
        private final long seqNum;
        private final IoSession session;
        private final Comparator<IoSession> comparator;

        public SessionEntry(IoSession session, Comparator<IoSession> comparator) {
            if (session == null) {
                throw new IllegalArgumentException("session");
            }
            this.seqNum = seq.getAndIncrement();
            this.session = session;
            this.comparator = comparator;
        }

        public IoSession getSession() {
            return this.session;
        }

        @Override
        public int compareTo(SessionEntry other) {
            if (other == this) {
                return 0;
            }
            if (other.session == this.session) {
                return 0;
            }
            if (this == EXIT_SIGNAL) {
                return -1;
            }
            if (other == EXIT_SIGNAL) {
                return 1;
            }
            int res = 0;
            if (this.comparator != null) {
                res = this.comparator.compare(this.session, other.session);
            }
            if (res == 0) {
                res = this.seqNum < other.seqNum ? -1 : 1;
            }
            return res;
        }
    }

    private class SessionQueue {
        private final Queue<Runnable> tasksQueue = new ConcurrentLinkedQueue<Runnable>();
        private boolean processingCompleted = true;

        private SessionQueue() {
        }
    }

    private class Worker
    implements Runnable {
        private AtomicLong completedTaskCount = new AtomicLong(0L);
        private Thread thread;

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            this.thread = Thread.currentThread();
            try {
                while (true) {
                    IoSession session = this.fetchSession();
                    PriorityThreadPoolExecutor.this.idleWorkers.decrementAndGet();
                    if (session == null) {
                        object = PriorityThreadPoolExecutor.this.workers;
                        synchronized (object) {
                            if (PriorityThreadPoolExecutor.this.workers.size() > PriorityThreadPoolExecutor.this.getCorePoolSize()) {
                                break;
                            }
                        }
                    }
                    if (session == EXIT_SIGNAL) {
                        break;
                    }
                    if (session != null) {
                        this.runTasks(PriorityThreadPoolExecutor.this.getSessionTasksQueue(session));
                    }
                    PriorityThreadPoolExecutor.this.idleWorkers.incrementAndGet();
                }
            }
            finally {
                Set set = PriorityThreadPoolExecutor.this.workers;
                synchronized (set) {
                    PriorityThreadPoolExecutor.this.workers.remove(this);
                    object = PriorityThreadPoolExecutor.this;
                    ((PriorityThreadPoolExecutor)object).completedTaskCount = ((PriorityThreadPoolExecutor)object).completedTaskCount + this.completedTaskCount.get();
                    PriorityThreadPoolExecutor.this.workers.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IoSession fetchSession() {
            SessionEntry entry = null;
            long currentTime = System.currentTimeMillis();
            long deadline = currentTime + PriorityThreadPoolExecutor.this.getKeepAliveTime(TimeUnit.MILLISECONDS);
            while (true) {
                try {
                    long waitTime = deadline - currentTime;
                    if (waitTime <= 0L) break;
                    try {
                        entry = (SessionEntry)PriorityThreadPoolExecutor.this.waitingSessions.poll(waitTime, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        if (entry != null) {
                            currentTime = System.currentTimeMillis();
                        }
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            if (entry != null) {
                return entry.getSession();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTasks(SessionQueue sessionTasksQueue) {
            while (true) {
                Runnable task;
                Queue tasksQueue;
                Queue queue = tasksQueue = sessionTasksQueue.tasksQueue;
                synchronized (queue) {
                    task = (Runnable)tasksQueue.poll();
                    if (task == null) {
                        sessionTasksQueue.processingCompleted = true;
                        break;
                    }
                }
                PriorityThreadPoolExecutor.this.eventQueueHandler.polled(PriorityThreadPoolExecutor.this, (IoEvent)task);
                this.runTask(task);
            }
        }

        private void runTask(Runnable task) {
            PriorityThreadPoolExecutor.this.beforeExecute(this.thread, task);
            boolean ran = false;
            try {
                task.run();
                ran = true;
                PriorityThreadPoolExecutor.this.afterExecute(task, null);
                this.completedTaskCount.incrementAndGet();
            }
            catch (RuntimeException e) {
                if (!ran) {
                    PriorityThreadPoolExecutor.this.afterExecute(task, e);
                }
                throw e;
            }
        }
    }
}

