/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.store;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.directory.server.dhcp.store.DhcpConfigElement;

public class Subnet
extends DhcpConfigElement {
    private final InetAddress address;
    private final InetAddress netmask;
    private InetAddress rangeMin;
    private InetAddress rangeMax;

    public Subnet(InetAddress address, InetAddress netmask, InetAddress rangeMin, InetAddress rangeMax) {
        byte[] masked = netmask.getAddress();
        byte[] addrBytes = netmask.getAddress();
        for (int i2 = 0; i2 < addrBytes.length; ++i2) {
            int n = i2;
            masked[n] = (byte)(masked[n] & addrBytes[i2]);
        }
        if (!Arrays.equals(masked, addrBytes)) {
            try {
                address = InetAddress.getByAddress(masked);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.address = address;
        this.netmask = netmask;
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getNetmask() {
        return this.netmask;
    }

    public InetAddress getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(InetAddress rangeMax) {
        this.rangeMax = rangeMax;
    }

    public InetAddress getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(InetAddress rangeMin) {
        this.rangeMin = rangeMin;
    }

    public boolean contains(InetAddress clientAddress) {
        if (!clientAddress.getClass().equals(this.address.getClass())) {
            return false;
        }
        byte[] client = clientAddress.getAddress();
        byte[] masked = this.netmask.getAddress();
        for (int i2 = 0; i2 < masked.length; ++i2) {
            int n = i2;
            masked[n] = (byte)(masked[n] & client[i2]);
        }
        return Arrays.equals(masked, this.address.getAddress());
    }

    public boolean isInRange(InetAddress clientAddress) {
        byte[] client = clientAddress.getAddress();
        byte[] masked = this.netmask.getAddress();
        for (int i2 = 0; i2 < masked.length; ++i2) {
            int n = i2;
            masked[n] = (byte)(masked[n] & client[i2]);
        }
        if (null != this.rangeMin && Subnet.arrayComp(masked, this.rangeMin.getAddress()) < 0) {
            return false;
        }
        return null == this.rangeMin || Subnet.arrayComp(masked, this.rangeMax.getAddress()) <= 0;
    }

    private static int arrayComp(byte[] a1, byte[] a2) {
        for (int i2 = 0; i2 < a1.length && i2 < a2.length; ++i2) {
            if (a1[i2] == a2[i2]) continue;
            return (a1[i2] & 0xFF) - (a2[i2] & 0xFF);
        }
        return a1.length - a2.length;
    }
}

