/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared.partition;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ObjectClassNode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.ldap.util.tree.DnNode;
import org.apache.directory.api.util.exception.MultiException;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.CursorList;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursorImpl;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.GetRootDseOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.AbstractPartition;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.api.partition.PartitionWriteTxn;
import org.apache.directory.server.core.api.partition.Subordinates;
import org.apache.directory.server.core.shared.partition.RootPartition;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionNexus
extends AbstractPartition
implements PartitionNexus {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPartitionNexus.class);
    private static final String NEXUS_ID = "NEXUS";
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final String ASF = "Apache Software Foundation";
    private final Entry rootDse;
    private DirectoryService directoryService;
    private Map<String, Partition> partitions = new HashMap<String, Partition>();
    private DnNode<Partition> partitionLookupTree = new DnNode();
    private final List<Modification> mods = new ArrayList<Modification>(2);
    private Dn subschemaSubentryDn;

    public DefaultPartitionNexus(Entry rootDse) throws LdapException {
        this.id = NEXUS_ID;
        this.suffixDn = null;
        this.rootDse = rootDse;
        rootDse.put("subschemaSubentry", "cn=schema");
        rootDse.put("supportedLDAPVersion", "3");
        rootDse.put("supportedFeatures", "1.3.6.1.4.1.4203.1.5.1", "1.3.6.1.1.14");
        rootDse.put("supportedExtension", "1.3.6.1.4.1.1466.20036");
        rootDse.put("objectClass", "top", "extensibleObject");
        rootDse.put("vendorName", ASF);
        Properties props = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream("version.properties");){
            props.load(inputStream);
        }
        catch (IOException e) {
            LOG.error(I18n.err(I18n.ERR_33, new Object[0]));
        }
        rootDse.put("vendorVersion", props.getProperty("apacheds.version", "UNKNOWN"));
        rootDse.put("entryUUID", "f290425c-8272-4e62-8a67-92b06f38dbf5");
    }

    @Override
    public void repair() throws LdapException {
    }

    @Override
    protected void doRepair() throws LdapException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInit() throws LdapException {
        if (!this.initialized) {
            Iterator<String> ctrlOidItr = this.directoryService.getLdapCodecService().registeredRequestControls();
            while (ctrlOidItr.hasNext()) {
                this.rootDse.add("supportedControl", ctrlOidItr.next());
            }
            ctrlOidItr = this.directoryService.getLdapCodecService().registeredResponseControls();
            while (ctrlOidItr.hasNext()) {
                this.rootDse.add("supportedControl", ctrlOidItr.next());
            }
            this.schemaManager = this.directoryService.getSchemaManager();
            Value attr = this.rootDse.get("subschemaSubentry").get();
            this.subschemaSubentryDn = this.directoryService.getDnFactory().create(attr.getString());
            ArrayList<Partition> initializedPartitions = new ArrayList<Partition>();
            initializedPartitions.add(0, this.directoryService.getSystemPartition());
            this.addContextPartition(this.directoryService.getSystemPartition());
            try {
                for (Partition partition : this.directoryService.getPartitions()) {
                    this.addContextPartition(partition);
                    initializedPartitions.add(partition);
                }
                this.createContextCsnModList();
                this.initialized = true;
            }
            finally {
                if (!this.initialized) {
                    Iterator i2 = initializedPartitions.iterator();
                    while (i2.hasNext()) {
                        Partition partition = (Partition)i2.next();
                        i2.remove();
                        try {
                            partition.destroy(partition.beginReadTransaction());
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to destroy a partition: " + partition.getSuffixDn(), e);
                        }
                        finally {
                            this.unregister(partition);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected synchronized void doDestroy(PartitionTxn partitionTxn) {
        if (!this.initialized) {
            return;
        }
        for (String suffix : new HashSet<String>(this.partitions.keySet())) {
            try {
                this.removeContextPartition(suffix);
            }
            catch (Exception e) {
                LOG.warn("Failed to destroy a partition: " + this.suffixDn, e);
            }
        }
        this.initialized = false;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_264, new Object[0]));
    }

    @Override
    public void setSuffixDn(Dn suffix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sync() throws LdapException {
        Throwable errors = null;
        for (Partition partition : this.partitions.values()) {
            try {
                partition.saveContextCsn(partition.beginReadTransaction());
                partition.sync();
            }
            catch (Exception e) {
                LOG.warn("Failed to flush partition data out.", e);
                if (errors == null) {
                    errors = new MultiException(I18n.err(I18n.ERR_265, new Object[0]));
                }
                ((MultiException)errors).addThrowable(e);
            }
        }
        if (errors != null) {
            throw new LdapOtherException(errors.getMessage(), errors);
        }
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        Partition partition = addContext.getPartition();
        partition.add(addContext);
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        Attribute attr = compareContext.getOriginalEntry().get(compareContext.getAttributeType());
        if (attr == null) {
            throw new LdapNoSuchAttributeException();
        }
        if (attr.contains(compareContext.getValue())) {
            return true;
        }
        Value reqVal = compareContext.getValue();
        for (Value value : attr) {
            if (!value.equals(reqVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Entry delete(DeleteOperationContext deleteContext) throws LdapException {
        Partition partition = this.getPartition(deleteContext.getDn());
        return partition.delete(deleteContext);
    }

    @Override
    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        Dn dn = hasEntryContext.getDn();
        if (IS_DEBUG) {
            LOG.debug("Check if Dn '{}' exists.", (Object)dn);
        }
        if (dn.isRootDse()) {
            return true;
        }
        Partition partition = this.getPartition(dn);
        return partition.hasEntry(hasEntryContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Dn dn = lookupContext.getDn();
        if (dn.getNormName().equals(this.subschemaSubentryDn.getNormName())) {
            return new ClonedServerEntry(this.rootDse.clone());
        }
        if (dn.isRootDse()) {
            return new ClonedServerEntry(this.rootDse);
        }
        Partition partition = this.getPartition(dn);
        Entry entry = partition.lookup(lookupContext);
        if (entry == null) {
            throw new LdapNoSuchObjectException("Attempt to lookup non-existant entry: " + dn.getName());
        }
        return entry;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (modifyContext.getModItems().isEmpty()) {
            return;
        }
        Partition partition = this.getPartition(modifyContext.getDn());
        partition.modify(modifyContext);
        if (modifyContext.isPushToEvtInterceptor()) {
            this.directoryService.getInterceptor(InterceptorEnum.EVENT_INTERCEPTOR.getName()).modify(modifyContext);
        }
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        Partition partition = this.getPartition(moveContext.getDn());
        partition.move(moveContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Partition partition = this.getPartition(moveAndRenameContext.getDn());
        partition.moveAndRename(moveAndRenameContext);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Partition partition = this.getPartition(renameContext.getDn());
        partition.rename(renameContext);
    }

    private EntryFilteringCursor searchRootDse(SearchOperationContext searchContext) throws LdapException {
        DefaultEntry serverEntry;
        Set<AttributeTypeOptions> ids = searchContext.getReturningAttributes();
        if (ids == null || ids.isEmpty()) {
            return new EntryFilteringCursorImpl(new SingletonCursor<Entry>(this.getRootDse(null)), searchContext, this.directoryService.getSchemaManager());
        }
        HashSet<String> realIds = new HashSet<String>();
        boolean allUserAttributes = searchContext.isAllUserAttributes();
        boolean allOperationalAttributes = searchContext.isAllOperationalAttributes();
        boolean noAttribute = searchContext.isNoAttributes();
        for (AttributeTypeOptions id : ids) {
            try {
                realIds.add(id.getAttributeType().getOid());
            }
            catch (Exception e) {
                realIds.add(id.getAttributeType().getName());
            }
        }
        if (noAttribute) {
            serverEntry = new DefaultEntry(this.schemaManager, Dn.ROOT_DSE);
            return new EntryFilteringCursorImpl(new SingletonCursor<Entry>(serverEntry), searchContext, this.directoryService.getSchemaManager());
        }
        if (allUserAttributes && allOperationalAttributes) {
            Entry foundRootDse = this.getRootDse(null);
            return new EntryFilteringCursorImpl(new SingletonCursor<Entry>(foundRootDse), searchContext, this.directoryService.getSchemaManager());
        }
        serverEntry = new DefaultEntry(this.schemaManager, Dn.ROOT_DSE);
        GetRootDseOperationContext getRootDseContext = new GetRootDseOperationContext(searchContext.getSession());
        getRootDseContext.setPartition(searchContext.getPartition());
        getRootDseContext.setTransaction(searchContext.getTransaction());
        Entry foundRootDse = this.getRootDse(getRootDseContext);
        for (Attribute attribute : foundRootDse) {
            AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(attribute.getId());
            if (!realIds.contains(type.getOid()) && (!allUserAttributes || type.getUsage() != UsageEnum.USER_APPLICATIONS) && (!allOperationalAttributes || type.getUsage() == UsageEnum.USER_APPLICATIONS)) continue;
            serverEntry.put(attribute);
        }
        return new EntryFilteringCursorImpl(new SingletonCursor<Entry>(serverEntry), searchContext, this.directoryService.getSchemaManager());
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        Dn baseDn = searchContext.getDn();
        if (baseDn.size() == 0) {
            return this.searchFromRoot(searchContext);
        }
        if (!baseDn.isSchemaAware()) {
            searchContext.setDn(new Dn(this.schemaManager, baseDn));
        }
        Partition backend = searchContext.getPartition();
        return backend.search(searchContext);
    }

    private EntryFilteringCursor searchFromRoot(SearchOperationContext searchContext) throws LdapException {
        ExprNode filter = searchContext.getFilter();
        boolean isObjectScope = searchContext.getScope() == SearchScope.OBJECT;
        boolean isOnelevelScope = searchContext.getScope() == SearchScope.ONELEVEL;
        boolean isSearchAll = false;
        if (filter instanceof ObjectClassNode) {
            isSearchAll = true;
        }
        if (isObjectScope) {
            if (isSearchAll) {
                return this.searchRootDse(searchContext);
            }
            return new EntryFilteringCursorImpl(new EmptyCursor<Entry>(), searchContext, this.directoryService.getSchemaManager());
        }
        if (isOnelevelScope) {
            ArrayList<EntryFilteringCursor> cursors = new ArrayList<EntryFilteringCursor>();
            for (Partition partition : this.partitions.values()) {
                Dn contextDn = partition.getSuffixDn();
                PartitionReadTxn partitionTxn = partition.beginReadTransaction();
                HasEntryOperationContext hasEntryContext = new HasEntryOperationContext(searchContext.getSession(), contextDn);
                hasEntryContext.setPartition(partition);
                hasEntryContext.setTransaction(partitionTxn);
                searchContext.setPartition(partition);
                searchContext.setTransaction(partitionTxn);
                if (!partition.hasEntry(hasEntryContext)) continue;
                searchContext.setDn(contextDn);
                searchContext.setScope(SearchScope.OBJECT);
                cursors.add(partition.search(searchContext));
            }
            return new CursorList(cursors, searchContext);
        }
        ArrayList<EntryFilteringCursor> cursors = new ArrayList<EntryFilteringCursor>();
        for (Partition partition : this.partitions.values()) {
            PartitionReadTxn partitionTxn = partition.beginReadTransaction();
            Dn contextDn = partition.getSuffixDn();
            HasEntryOperationContext hasEntryContext = new HasEntryOperationContext(searchContext.getSession(), contextDn);
            hasEntryContext.setPartition(partition);
            hasEntryContext.setTransaction(partitionTxn);
            searchContext.setPartition(partition);
            searchContext.setTransaction(partitionTxn);
            if (!partition.hasEntry(hasEntryContext)) continue;
            searchContext.setDn(contextDn);
            EntryFilteringCursor cursor = partition.search(searchContext);
            try {
                if (!cursor.first()) continue;
                cursor.beforeFirst();
                cursors.add(cursor);
            }
            catch (CursorException cursorException) {}
        }
        if (cursors.isEmpty()) {
            return new EntryFilteringCursorImpl(new EmptyCursor<Entry>(), searchContext, this.directoryService.getSchemaManager());
        }
        return new CursorList(cursors, searchContext);
    }

    @Override
    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        Dn unbindContextDn = unbindContext.getDn();
        if (!Dn.isNullOrEmpty(unbindContextDn)) {
            Partition partition = this.getPartition(unbindContext.getDn());
            partition.unbind(unbindContext);
        }
    }

    @Override
    public Entry getRootDse(GetRootDseOperationContext getRootDseContext) {
        return this.rootDse.clone();
    }

    @Override
    public Value getRootDseValue(AttributeType attributeType) {
        return this.rootDse.get(attributeType).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addContextPartition(Partition partition) throws LdapException {
        String key = partition.getSuffixDn().getNormName();
        if (this.partitions.containsKey(key)) {
            throw new LdapOtherException(I18n.err(I18n.ERR_263, key));
        }
        if (!partition.isInitialized()) {
            partition.initialize();
        }
        DnNode<Partition> dnNode = this.partitionLookupTree;
        synchronized (dnNode) {
            Dn partitionSuffix = partition.getSuffixDn();
            if (partitionSuffix == null) {
                throw new LdapOtherException(I18n.err(I18n.ERR_267, partition.getId()));
            }
            this.partitions.put(partitionSuffix.getNormName(), partition);
            this.partitionLookupTree.add(partition.getSuffixDn(), partition);
            Attribute namingContexts = this.rootDse.get("namingContexts");
            if (namingContexts == null) {
                namingContexts = new DefaultAttribute(this.schemaManager.lookupAttributeTypeRegistry("namingContexts"), partitionSuffix.getName());
                this.rootDse.put(namingContexts);
            } else {
                namingContexts.add(partitionSuffix.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeContextPartition(String partitionDn) throws LdapException {
        Object foundNC;
        Partition partition = this.partitions.get(partitionDn);
        if (partition == null) {
            String msg = I18n.err(I18n.ERR_34, partitionDn);
            LOG.error(msg);
            throw new LdapNoSuchObjectException(msg);
        }
        String partitionSuffix = partition.getSuffixDn().getNormName();
        Attribute namingContexts = this.rootDse.get("namingContexts");
        if (namingContexts != null) {
            foundNC = null;
            for (Value namingContext : namingContexts) {
                String normalizedNC = new Dn(this.schemaManager, namingContext.getString()).getNormName();
                if (!partitionSuffix.equals(normalizedNC)) continue;
                foundNC = namingContext;
                break;
            }
            if (foundNC != null) {
                namingContexts.remove(new Value[]{foundNC});
            } else {
                String msg = I18n.err(I18n.ERR_35, partitionDn);
                LOG.error(msg);
                throw new LdapNoSuchObjectException(msg);
            }
        }
        foundNC = this.partitionLookupTree;
        synchronized (foundNC) {
            this.partitionLookupTree.remove(partition.getSuffixDn());
        }
        this.partitions.remove(partitionDn);
        try {
            partition.destroy(partition.beginReadTransaction());
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition getPartition(Dn dn) throws LdapException {
        Partition parent;
        if (dn == null) {
            dn = Dn.ROOT_DSE;
        }
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.schemaManager, dn);
        }
        if (dn.isRootDse() || dn.getNormName().equals(this.subschemaSubentryDn.getNormName())) {
            return new RootPartition(this.schemaManager);
        }
        DnNode<Partition> dnNode = this.partitionLookupTree;
        synchronized (dnNode) {
            parent = this.partitionLookupTree.getElement(dn);
        }
        if (parent == null) {
            throw new LdapNoSuchObjectException(I18n.err(I18n.ERR_268, dn));
        }
        return parent;
    }

    @Override
    public Dn getSuffixDn(Dn dn) throws LdapException {
        Partition partition = this.getPartition(dn);
        return partition.getSuffixDn();
    }

    @Override
    public Set<String> listSuffixes() throws LdapException {
        return Collections.unmodifiableSet(this.partitions.keySet());
    }

    @Override
    public void registerSupportedExtensions(Set<String> extensionOids) throws LdapException {
        Attribute supportedExtension = this.rootDse.get("supportedExtension");
        if (supportedExtension == null) {
            this.rootDse.put("supportedExtension", new String[]{null});
            supportedExtension = this.rootDse.get("supportedExtension");
        }
        for (String extensionOid : extensionOids) {
            supportedExtension.add(extensionOid);
        }
    }

    @Override
    public void registerSupportedSaslMechanisms(Set<String> supportedSaslMechanisms) throws LdapException {
        DefaultAttribute supportedSaslMechanismsAt = new DefaultAttribute(this.schemaManager.lookupAttributeTypeRegistry("supportedSASLMechanisms"));
        for (String saslMechanism : supportedSaslMechanisms) {
            supportedSaslMechanismsAt.add(saslMechanism);
        }
        this.rootDse.add(supportedSaslMechanismsAt);
    }

    private void unregister(Partition partition) {
        Attribute namingContexts = this.rootDse.get("namingContexts");
        if (namingContexts != null) {
            namingContexts.remove(partition.getSuffixDn().getName());
        }
        this.partitions.remove(partition.getSuffixDn().getName());
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public void setDirectoryService(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    private void createContextCsnModList() throws LdapException {
        DefaultModification contextCsnMod = new DefaultModification();
        contextCsnMod.setOperation(ModificationOperation.REPLACE_ATTRIBUTE);
        DefaultAttribute contextCsnAt = new DefaultAttribute(this.schemaManager.lookupAttributeTypeRegistry("contextCSN"));
        contextCsnMod.setAttribute(contextCsnAt);
        this.mods.add(contextCsnMod);
        DefaultModification timeStampMod = new DefaultModification();
        timeStampMod.setOperation(ModificationOperation.REPLACE_ATTRIBUTE);
        DefaultAttribute timeStampAt = new DefaultAttribute(this.schemaManager.lookupAttributeTypeRegistry("modifyTimestamp"));
        timeStampMod.setAttribute(timeStampAt);
        this.mods.add(timeStampMod);
    }

    @Override
    public String getContextCsn(PartitionTxn partitionTxn) {
        return null;
    }

    @Override
    public void saveContextCsn(PartitionTxn partitionTxn) throws LdapException {
    }

    @Override
    public Subordinates getSubordinates(PartitionTxn partitionTxn, Entry entry) throws LdapException {
        return new Subordinates();
    }

    @Override
    public PartitionReadTxn beginReadTransaction() {
        return new PartitionReadTxn();
    }

    @Override
    public PartitionWriteTxn beginWriteTransaction() {
        return new PartitionWriteTxn();
    }
}

