/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.LinkedAvlNode;
import org.apache.directory.server.core.avltree.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvlTreeCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private AvlTree<E> tree;
    private LinkedAvlNode<E> node;
    private Position position = Position.BEFORE_FIRST;

    public AvlTreeCursor(AvlTree<E> tree) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating AvlTreeCursor {}", (Object)this);
        }
        this.tree = tree;
    }

    @Override
    public void after(E element) throws LdapException, CursorException {
        this.checkNotClosed();
        if (element == null) {
            this.afterLast();
            return;
        }
        this.node = this.tree.findGreater(element);
        this.position = this.node == null ? Position.AFTER_LAST : Position.BEFORE_NODE;
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed();
        this.node = null;
        this.position = Position.AFTER_LAST;
    }

    @Override
    public boolean available() {
        return this.position == Position.ON_NODE;
    }

    @Override
    public void before(E element) throws LdapException, CursorException {
        this.checkNotClosed();
        if (element == null) {
            this.beforeFirst();
            return;
        }
        this.node = this.tree.findLess(element);
        this.position = this.node == null ? Position.BEFORE_FIRST : Position.AFTER_NODE;
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed();
        this.node = null;
        this.position = Position.BEFORE_FIRST;
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        this.checkNotClosed();
        this.node = this.tree.getFirst();
        if (this.node == null) {
            this.position = Position.BEFORE_FIRST;
            return false;
        }
        this.position = Position.ON_NODE;
        return true;
    }

    @Override
    public E get() throws CursorException {
        this.checkNotClosed();
        if (this.position == Position.ON_NODE) {
            return this.node.getKey();
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        this.checkNotClosed();
        this.node = this.tree.getLast();
        if (this.node == null) {
            this.position = Position.AFTER_LAST;
            return false;
        }
        this.position = Position.ON_NODE;
        return true;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed();
        switch (this.position) {
            case BEFORE_FIRST: {
                return this.first();
            }
            case BEFORE_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case ON_NODE: 
            case AFTER_NODE: {
                this.node = this.node.next;
                if (this.node == null) {
                    this.afterLast();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed();
        switch (this.position) {
            case BEFORE_FIRST: {
                return false;
            }
            case BEFORE_NODE: 
            case ON_NODE: {
                this.node = this.node.previous;
                if (this.node == null) {
                    this.beforeFirst();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return this.last();
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }

    @Override
    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AvlTreeCursor {}", (Object)this);
        }
        super.close();
    }

    @Override
    public void close(Exception reason) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AvlTreeCursor {}", (Object)this);
        }
        super.close(reason);
    }
}

