/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import javax.naming.InvalidNameException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;

public final class Hex {
    private static final byte[] HEX_VALUE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static byte getHexValue(char high, char low) {
        if (high > '\u007f' || low > '\u007f') {
            return -1;
        }
        return (byte)(HEX_VALUE[high] << 4 | HEX_VALUE[low] & 0xFF);
    }

    public static byte getHexValue(byte high, byte low) {
        if ((high & 0x7F) != high || (low & 0x7F) != low) {
            return -1;
        }
        return (byte)(HEX_VALUE[high] << 4 | HEX_VALUE[low] & 0xFF);
    }

    public static byte getHexValue(char c) {
        if (c > '\u007f') {
            return -1;
        }
        return HEX_VALUE[c];
    }

    public static String decodeHexString(String str) throws InvalidNameException {
        if (str == null || str.length() == 0) {
            throw new InvalidNameException(I18n.err(I18n.ERR_17037_MUST_START_WITH_SHARP, new Object[0]));
        }
        char[] chars = str.toCharArray();
        if (chars[0] != '#') {
            throw new InvalidNameException(I18n.err(I18n.ERR_17038_MUST_START_WITH_ESC_SHARP, str));
        }
        byte[] decoded = new byte[chars.length - 1 >> 1];
        int ii = 1;
        int jj = 0;
        while (ii < chars.length) {
            int ch = (HEX_VALUE[chars[ii]] << 4) + (HEX_VALUE[chars[ii + 1]] & 0xFF);
            decoded[jj] = (byte)ch;
            ii += 2;
            ++jj;
        }
        return Strings.utf8ToString(decoded);
    }

    public static byte[] convertEscapedHex(String str) throws InvalidNameException {
        if (str == null) {
            throw new InvalidNameException(I18n.err(I18n.ERR_17039_NON_NULL_EXPECTED_STRING, new Object[0]));
        }
        int length = str.length();
        if (length == 0) {
            throw new InvalidNameException(I18n.err(I18n.ERR_17040_EXPECTED_NON_EMPTY_STRING, new Object[0]));
        }
        byte[] buf = new byte[str.length() / 3];
        int pos = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            char c = str.charAt(i2);
            if (c == '\\') {
                if (!Chars.isHex(str, i2 + 1) || !Chars.isHex(str, i2 + 2)) continue;
                byte value = (byte)((HEX_VALUE[str.charAt(i2 + 1)] << 4) + (HEX_VALUE[str.charAt(i2 + 2)] & 0xFF));
                i2 += 2;
                buf[pos++] = value;
                continue;
            }
            throw new InvalidNameException(I18n.err(I18n.ERR_17041_VALID_ESC_CHARS_EXPECTED, new Object[0]));
        }
        return buf;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i2 = 0; i2 < l; ++i2) {
            out[j++] = HEX_CHAR[(0xF0 & data[i2]) >>> 4];
            out[j++] = HEX_CHAR[0xF & data[i2]];
        }
        return out;
    }
}

