/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif.anonymizer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.ldif.anonymizer.AbstractAnonymizer;

public class IntegerAnonymizer
extends AbstractAnonymizer<String> {
    private Map<Integer, String> latestIntegerMap;

    public IntegerAnonymizer() {
        this.latestIntegerMap = new HashMap<Integer, String>();
    }

    public IntegerAnonymizer(Map<Integer, String> latestIntegerMap) {
        this.latestIntegerMap = latestIntegerMap == null ? new HashMap<Integer, String>() : latestIntegerMap;
    }

    @Override
    public Attribute anonymize(Map<Value, Value> valueMap, Set<Value> valueSet, Attribute attribute) {
        DefaultAttribute result = new DefaultAttribute(attribute.getAttributeType());
        for (Value value : attribute) {
            if (!value.isHumanReadable()) continue;
            Value anonymized = valueMap.get(value);
            if (anonymized != null) {
                try {
                    result.add(anonymized);
                }
                catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
                continue;
            }
            String strValue = value.getString();
            String newValue = this.computeNewIntegerValue(strValue);
            try {
                result.add(newValue);
                Value anonValue = new Value(attribute.getAttributeType(), newValue);
                valueMap.put(value, anonValue);
                valueSet.add(anonValue);
            }
            catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
        }
        return result;
    }

    public Map<Integer, String> getLatestIntegerMap() {
        return this.latestIntegerMap;
    }

    public void setLatestIntegerMap(Map<Integer, String> latestIntegerMap) {
        this.latestIntegerMap = latestIntegerMap;
    }

    private String computeNewIntegerValue(String valStr) {
        int length = valStr.length();
        String latestInteger = this.latestIntegerMap.get(length);
        if (latestInteger == null) {
            char[] newValue = new char[length];
            Arrays.fill(newValue, '9');
            String anonymizedValue = new String(newValue);
            this.latestIntegerMap.put(length, anonymizedValue);
            return anonymizedValue;
        }
        char[] latest = latestInteger.toCharArray();
        boolean overflow = true;
        for (int i2 = length - 1; i2 >= 0; --i2) {
            if (latest[i2] != '0') {
                int n = i2;
                latest[n] = (char)(latest[n] - '\u0001');
                overflow = false;
                break;
            }
            latest[i2] = 57;
        }
        if (length > 1 && latest[0] == '0') {
            throw new RuntimeException(I18n.err(I18n.ERR_13437_OVERFLOW, valStr));
        }
        String anonymizedValue = new String(latest);
        if (overflow) {
            String msg = I18n.err(I18n.ERR_13435_CANNOT_COMPUTE_NEW_VALUE, anonymizedValue);
            throw new RuntimeException(msg);
        }
        this.latestIntegerMap.put(length, anonymizedValue);
        return anonymizedValue;
    }
}

