/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionRequestContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseContainer;
import org.apache.directory.api.ldap.extras.extended.endTransaction.EndTransactionRequest;
import org.apache.directory.api.ldap.extras.extended.endTransaction.EndTransactionRequestImpl;
import org.apache.directory.api.ldap.extras.extended.endTransaction.EndTransactionResponse;
import org.apache.directory.api.ldap.extras.extended.endTransaction.EndTransactionResponseImpl;
import org.apache.directory.api.ldap.extras.extended.endTransaction.UpdateControls;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;

public class EndTransactionFactory
extends AbstractExtendedOperationFactory {
    public EndTransactionFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.1.21.3");
    }

    @Override
    public EndTransactionRequest newRequest() {
        EndTransactionRequestImpl endTransactionRequest = new EndTransactionRequestImpl();
        return endTransactionRequest;
    }

    @Override
    public EndTransactionRequest newRequest(byte[] encodedValue) throws DecoderException {
        EndTransactionRequestImpl endTransactionRequest = new EndTransactionRequestImpl();
        this.decodeValue(endTransactionRequest, encodedValue);
        return endTransactionRequest;
    }

    @Override
    public EndTransactionResponse newResponse() {
        EndTransactionResponseImpl endTransactionResponse = new EndTransactionResponseImpl();
        return endTransactionResponse;
    }

    @Override
    public EndTransactionResponse newResponse(byte[] encodedValue) throws DecoderException {
        EndTransactionResponseImpl endTransactionResponse = new EndTransactionResponseImpl();
        this.decodeValue(endTransactionResponse, encodedValue);
        return endTransactionResponse;
    }

    @Override
    public void decodeValue(ExtendedRequest extendedRequest, byte[] requestValue) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(requestValue);
        EndTransactionRequestContainer container = new EndTransactionRequestContainer();
        container.setEndTransactionRequest((EndTransactionRequest)extendedRequest);
        Asn1Decoder.decode(bb, container);
    }

    @Override
    public void decodeValue(ExtendedResponse extendedResponse, byte[] requestValue) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(requestValue);
        EndTransactionResponseContainer container = new EndTransactionResponseContainer();
        container.setEndTransactionResponse((EndTransactionResponse)extendedResponse);
        Asn1Decoder.decode(bb, container);
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, ExtendedRequest extendedRequest) {
        int start = buffer.getPos();
        EndTransactionRequest transactionRequest = (EndTransactionRequest)extendedRequest;
        BerValue.encodeOctetString(buffer, transactionRequest.getTransactionId());
        if (!transactionRequest.getCommit()) {
            BerValue.encodeBoolean(buffer, false);
        }
        BerValue.encodeSequence(buffer, start);
    }

    private void encodeControls(Asn1Buffer buffer, Iterator<Control> controls) {
        if (controls.hasNext()) {
            Control control = controls.next();
            this.encodeControls(buffer, controls);
            int start = buffer.getPos();
            ControlFactory<? extends Control> controlFactory = this.codec.getResponseControlFactories().get(control.getOid());
            if (controlFactory != null) {
                controlFactory.encodeValue(buffer, control);
                BerValue.encodeSequence(buffer, UniversalTag.OCTET_STRING.getValue(), start);
            }
            if (control.isCritical()) {
                BerValue.encodeBoolean(buffer, true);
            }
            BerValue.encodeOctetString(buffer, control.getOid());
            BerValue.encodeSequence(buffer, start);
        }
    }

    private void encodeUpdatedControls(Asn1Buffer buffer, Iterator<UpdateControls> updateControls) {
        if (updateControls.hasNext()) {
            UpdateControls updateControl = updateControls.next();
            this.encodeUpdatedControls(buffer, updateControls);
            int start = buffer.getPos();
            this.encodeControls(buffer, updateControl.getControls().iterator());
            BerValue.encodeSequence(buffer, start);
            BerValue.encodeInteger(buffer, updateControl.getMessageId());
            BerValue.encodeSequence(buffer, start);
        }
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, ExtendedResponse extendedResponse) {
        extendedResponse.setResponseName(null);
        int start = buffer.getPos();
        EndTransactionResponse endTransactionResponse = (EndTransactionResponse)extendedResponse;
        if (endTransactionResponse.getUpdateControls().size() > 0) {
            this.encodeUpdatedControls(buffer, endTransactionResponse.getUpdateControls().iterator());
            BerValue.encodeSequence(buffer, start);
        }
        if (endTransactionResponse.getFailedMessageId() >= 0) {
            BerValue.encodeInteger(buffer, endTransactionResponse.getFailedMessageId());
        }
        BerValue.encodeSequence(buffer, start);
    }
}

