/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ObjectClassNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.Subentries;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.subtree.AdministrativeRole;
import org.apache.directory.api.ldap.model.subtree.Subentry;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecificationParser;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.api.subtree.SubentryCache;
import org.apache.directory.server.core.api.subtree.SubtreeEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubentryInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SubentryInterceptor.class);
    private static final String SUBENTRY_CONTROL = "1.3.6.1.4.1.4203.1.10.1";
    private Value subentryOC;
    private SubtreeSpecificationParser ssParser;
    private PartitionNexus nexus;

    public SubentryInterceptor() {
        super(InterceptorEnum.SUBENTRY_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        this.ssParser = new SubtreeSpecificationParser(this.schemaManager);
        AttributeType ocAt = directoryService.getAtProvider().getObjectClass();
        Set<String> suffixes = this.nexus.listSuffixes();
        EqualityNode filter = new EqualityNode(ocAt, new Value(ocAt, "subentry"));
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"subtreeSpecification", "objectClass"});
        this.subentryOC = new Value(ocAt, "subentry");
        for (String suffix : suffixes) {
            CoreSession adminSession = directoryService.getAdminSession();
            Dn suffixDn = this.dnFactory.create(suffix);
            Partition partition = this.nexus.getPartition(suffixDn);
            SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, suffixDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            searchOperationContext.setPartition(partition);
            searchOperationContext.setTransaction(partition.beginReadTransaction());
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    SubtreeSpecification ss;
                    Entry subentry = (Entry)subentries.get();
                    Dn subentryDn = subentry.getDn();
                    String subtree = subentry.get(directoryService.getAtProvider().getSubtreeSpecification()).getString();
                    try {
                        ss = this.ssParser.parse(subtree);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed while parsing subtreeSpecification for {}", (Object)subentryDn);
                        continue;
                    }
                    Subentry newSubentry = new Subentry();
                    newSubentry.setAdministrativeRoles(this.getSubentryAdminRoles(subentry));
                    newSubentry.setSubtreeSpecification(ss);
                    directoryService.getSubentryCache().addSubentry(subentryDn, newSubentry);
                }
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
    }

    private Set<AdministrativeRole> getSubentryAdminRoles(Entry subentry) throws LdapException {
        HashSet<AdministrativeRole> adminRoles = new HashSet<AdministrativeRole>();
        Attribute oc = subentry.get(this.directoryService.getAtProvider().getObjectClass());
        if (oc == null) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_305, new Object[0]));
        }
        if (oc.contains("accessControlSubentry")) {
            adminRoles.add(AdministrativeRole.AccessControlInnerArea);
        }
        if (oc.contains("subschema")) {
            adminRoles.add(AdministrativeRole.SubSchemaSpecificArea);
        }
        if (oc.contains("collectiveAttributeSubentry")) {
            adminRoles.add(AdministrativeRole.CollectiveAttributeSpecificArea);
        }
        if (oc.contains("triggerExecutionSubentry")) {
            adminRoles.add(AdministrativeRole.TriggerExecutionInnerArea);
        }
        return adminRoles;
    }

    private boolean isSubentryVisible(OperationContext opContext) {
        if (!opContext.hasRequestControls()) {
            return false;
        }
        if (opContext.hasRequestControl(SUBENTRY_CONTROL)) {
            Subentries subentries = (Subentries)opContext.getRequestControl(SUBENTRY_CONTROL);
            return subentries.isVisible();
        }
        return false;
    }

    private void updateEntries(OperationContext opContext, OperationEnum operation, Dn apDn, SubtreeSpecification ss, Dn baseDn, List<Attribute> operationalAttributes) throws LdapException {
        ExprNode filter = ObjectClassNode.OBJECT_CLASS_NODE;
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"+", "*"});
        SearchOperationContext searchOperationContext = new SearchOperationContext(opContext.getSession(), baseDn, filter, controls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        searchOperationContext.setPartition(opContext.getPartition());
        searchOperationContext.setTransaction(opContext.getTransaction());
        EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
        try {
            while (subentries.next()) {
                Entry candidate = (Entry)subentries.get();
                Dn candidateDn = candidate.getDn();
                if (!this.directoryService.getEvaluator().evaluate(ss, apDn, candidateDn, candidate)) continue;
                List<Modification> modifications = null;
                switch (operation) {
                    case ADD: {
                        modifications = this.getOperationalModsForAdd(candidate, operationalAttributes);
                        break;
                    }
                    case REMOVE: {
                        modifications = this.getOperationalModsForRemove(opContext.getDn(), candidate);
                        break;
                    }
                    case REPLACE: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected operation " + (Object)((Object)operation));
                    }
                }
                LOG.debug("The entry {} has been evaluated to true for subentry {}", (Object)candidate.getDn(), (Object)opContext.getDn());
                ModifyOperationContext modifyContext = new ModifyOperationContext(opContext.getSession(), candidateDn, modifications);
                modifyContext.setPartition(opContext.getPartition());
                modifyContext.setTransaction(opContext.getTransaction());
                this.nexus.modify(modifyContext);
            }
            subentries.close();
        }
        catch (Exception e) {
            throw new LdapOtherException(e.getMessage(), e);
        }
        finally {
            try {
                subentries.close();
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
            }
        }
    }

    private boolean isNamingContext(Dn dn) throws LdapException {
        Dn namingContext = this.nexus.getSuffixDn(dn);
        return dn.equals(namingContext);
    }

    private void checkAdministrativeRole(OperationContext opContext, Dn apDn) throws LdapException {
        CoreSession session = opContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, apDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        lookupContext.setPartition(opContext.getPartition());
        lookupContext.setTransaction(opContext.getTransaction());
        Entry administrationPoint = this.directoryService.getPartitionNexus().lookup(lookupContext);
        Attribute administrativeRole = administrationPoint.get(this.directoryService.getAtProvider().getAdministrativeRole());
        if (administrativeRole == null || administrativeRole.size() <= 0) {
            LOG.error("The entry on {} is not an AdministrativePoint", (Object)apDn);
            throw new LdapNoSuchAttributeException(I18n.err(I18n.ERR_306, apDn));
        }
    }

    private void setSubtreeSpecification(Subentry subentry, Entry entry) throws LdapException {
        SubtreeSpecification ss;
        String subtree = entry.get(this.directoryService.getAtProvider().getSubtreeSpecification()).getString();
        try {
            ss = this.ssParser.parse(subtree);
        }
        catch (Exception e) {
            String msg = I18n.err(I18n.ERR_307, entry.getDn());
            LOG.warn(msg);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
        }
        subentry.setSubtreeSpecification(ss);
    }

    private boolean hasAdministrativeDescendant(OperationContext opContext, Dn name) throws LdapException {
        PresenceNode filter = new PresenceNode(this.directoryService.getAtProvider().getAdministrativeRole());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        SearchOperationContext searchOperationContext = new SearchOperationContext(opContext.getSession(), name, filter, controls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        searchOperationContext.setTransaction(opContext.getTransaction());
        searchOperationContext.setPartition(opContext.getPartition());
        EntryFilteringCursor aps = this.nexus.search(searchOperationContext);
        try {
            if (aps.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), e);
        }
        finally {
            try {
                aps.close();
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
            }
        }
        return false;
    }

    private List<Modification> getModsOnEntryRdnChange(Dn oldName, Dn newName, Entry entry) throws LdapException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        SubentryCache subentryCache = this.directoryService.getSubentryCache();
        SubtreeEvaluator evaluator = this.directoryService.getEvaluator();
        for (Dn subentryDn : subentryCache) {
            Attribute opAttr;
            ModificationOperation op;
            boolean isNewNameSelected;
            Dn apDn = subentryDn.getParent();
            SubtreeSpecification ss = subentryCache.getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldNameSelected = evaluator.evaluate(ss, apDn, oldName, entry);
            if (isOldNameSelected == (isNewNameSelected = evaluator.evaluate(ss, apDn, newName, entry))) continue;
            if (isOldNameSelected && !isNewNameSelected) {
                for (AttributeType operationalAttribute : this.directoryService.getAtProvider().getSubentryOperationalAttributes()) {
                    op = ModificationOperation.REPLACE_ATTRIBUTE;
                    opAttr = entry.get(operationalAttribute);
                    if (opAttr == null) continue;
                    opAttr = opAttr.clone();
                    opAttr.remove(subentryDn.getName());
                    if (opAttr.size() < 1) {
                        op = ModificationOperation.REMOVE_ATTRIBUTE;
                    }
                    modifications.add(new DefaultModification(op, opAttr));
                }
                continue;
            }
            if (!isNewNameSelected || isOldNameSelected) continue;
            for (AttributeType operationalAttribute : this.directoryService.getAtProvider().getSubentryOperationalAttributes()) {
                op = ModificationOperation.ADD_ATTRIBUTE;
                opAttr = new DefaultAttribute(operationalAttribute);
                opAttr.add(subentryDn.getName());
                modifications.add(new DefaultModification(op, opAttr));
            }
        }
        return modifications;
    }

    private Set<AdministrativeRole> getSubentryTypes(Entry entry, List<Modification> mods) throws LdapException {
        Attribute ocFinalState = entry.get(this.directoryService.getAtProvider().getObjectClass()).clone();
        block5: for (Modification mod : mods) {
            if (!mod.getAttribute().getId().equalsIgnoreCase("objectClass") && !mod.getAttribute().getId().equalsIgnoreCase("2.5.4.0")) continue;
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    for (Value value : mod.getAttribute()) {
                        ocFinalState.add(value.getString());
                    }
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    for (Value value : mod.getAttribute()) {
                        ocFinalState.remove(value.getString());
                    }
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    ocFinalState = mod.getAttribute();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected modify operatoin " + (Object)((Object)mod.getOperation()));
                }
            }
        }
        DefaultEntry attrs = new DefaultEntry(this.schemaManager, Dn.ROOT_DSE);
        attrs.put(ocFinalState);
        return this.getSubentryAdminRoles(attrs);
    }

    private void getOperationalModForReplace(boolean hasRole, AttributeType attributeType, Entry entry, Dn oldDn, Dn newDn, List<Modification> modifications) throws LdapInvalidAttributeValueException {
        String oldDnStr = oldDn.getName();
        String newDnStr = newDn.getName();
        if (hasRole) {
            Attribute operational = entry.get(attributeType).clone();
            if (operational == null) {
                operational = new DefaultAttribute(attributeType, newDnStr);
            } else {
                operational.remove(oldDnStr);
                operational.add(newDnStr);
            }
            modifications.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, operational));
        }
    }

    private List<Modification> getOperationalModsForReplace(Dn oldDn, Dn newDn, Subentry subentry, Entry entry) throws LdapException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        this.getOperationalModForReplace(subentry.isAccessControlAdminRole(), this.directoryService.getAtProvider().getAccessControlSubentries(), entry, oldDn, newDn, modifications);
        this.getOperationalModForReplace(subentry.isSchemaAdminRole(), this.directoryService.getAtProvider().getSubschemaSubentry(), entry, oldDn, newDn, modifications);
        this.getOperationalModForReplace(subentry.isCollectiveAdminRole(), this.directoryService.getAtProvider().getCollectiveAttributeSubentries(), entry, oldDn, newDn, modifications);
        this.getOperationalModForReplace(subentry.isTriggersAdminRole(), this.directoryService.getAtProvider().getTriggerExecutionSubentries(), entry, oldDn, newDn, modifications);
        return modifications;
    }

    private List<Attribute> getSubentryOperationalAttributes(Dn dn, Subentry subentry) throws LdapException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (subentry.isAccessControlAdminRole()) {
            DefaultAttribute accessControlSubentries = new DefaultAttribute(this.directoryService.getAtProvider().getAccessControlSubentries(), dn.getName());
            attributes.add(accessControlSubentries);
        }
        if (subentry.isSchemaAdminRole()) {
            DefaultAttribute subschemaSubentry = new DefaultAttribute(this.directoryService.getAtProvider().getSubschemaSubentry(), dn.getName());
            attributes.add(subschemaSubentry);
        }
        if (subentry.isCollectiveAdminRole()) {
            DefaultAttribute collectiveAttributeSubentries = new DefaultAttribute(this.directoryService.getAtProvider().getCollectiveAttributeSubentries(), dn.getName());
            attributes.add(collectiveAttributeSubentries);
        }
        if (subentry.isTriggersAdminRole()) {
            DefaultAttribute tiggerExecutionSubentries = new DefaultAttribute(this.directoryService.getAtProvider().getTriggerExecutionSubentries(), dn.getName());
            attributes.add(tiggerExecutionSubentries);
        }
        return attributes;
    }

    private List<Modification> getOperationalModsForRemove(Dn subentryDn, Entry candidate) throws LdapException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        String dn = subentryDn.getName();
        for (AttributeType operationalAttribute : this.directoryService.getAtProvider().getSubentryOperationalAttributes()) {
            Attribute opAttr = candidate.get(operationalAttribute);
            if (opAttr == null || !opAttr.contains(dn)) continue;
            DefaultAttribute attr = new DefaultAttribute(operationalAttribute, dn);
            modifications.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, attr));
        }
        return modifications;
    }

    private List<Modification> getOperationalModsForAdd(Entry entry, List<Attribute> operationalAttributes) throws LdapException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        for (Attribute operationalAttribute : operationalAttributes) {
            Attribute opAttrInEntry = entry.get(operationalAttribute.getAttributeType());
            if (opAttrInEntry != null && opAttrInEntry.size() > 0) {
                Attribute newOperationalAttribute = operationalAttribute.clone();
                for (Value value : opAttrInEntry) {
                    newOperationalAttribute.add(value);
                }
                modifications.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, newOperationalAttribute));
                continue;
            }
            modifications.add(new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, operationalAttribute));
        }
        return modifications;
    }

    private List<Modification> getModsOnEntryModification(Dn name, Entry oldEntry, Entry newEntry) throws LdapException {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        for (Dn subentryDn : this.directoryService.getSubentryCache()) {
            Attribute opAttr;
            ModificationOperation op;
            boolean isNewEntrySelected;
            Dn apDn = subentryDn.getParent();
            SubtreeSpecification ss = this.directoryService.getSubentryCache().getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldEntrySelected = this.directoryService.getEvaluator().evaluate(ss, apDn, name, oldEntry);
            if (isOldEntrySelected == (isNewEntrySelected = this.directoryService.getEvaluator().evaluate(ss, apDn, name, newEntry))) continue;
            if (isOldEntrySelected && !isNewEntrySelected) {
                for (AttributeType operationalAttribute : this.directoryService.getAtProvider().getSubentryOperationalAttributes()) {
                    op = ModificationOperation.REPLACE_ATTRIBUTE;
                    opAttr = oldEntry.get(operationalAttribute);
                    if (opAttr == null) continue;
                    opAttr = opAttr.clone();
                    opAttr.remove(subentryDn.getName());
                    if (opAttr.size() < 1) {
                        op = ModificationOperation.REMOVE_ATTRIBUTE;
                    }
                    modList.add(new DefaultModification(op, opAttr));
                }
                continue;
            }
            if (!isNewEntrySelected || isOldEntrySelected) continue;
            for (AttributeType operationalAttribute : this.directoryService.getAtProvider().getSubentryOperationalAttributes()) {
                op = ModificationOperation.ADD_ATTRIBUTE;
                opAttr = new DefaultAttribute(operationalAttribute);
                opAttr.add(subentryDn.getName());
                modList.add(new DefaultModification(op, opAttr));
            }
        }
        return modList;
    }

    private void setOperationalAttribute(Entry entry, Dn subentryDn, AttributeType opAttr) throws LdapException {
        Attribute operational = entry.get(opAttr);
        if (operational == null) {
            operational = new DefaultAttribute(opAttr);
            entry.put(operational);
        }
        operational.add(subentryDn.getName());
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        Dn dn = addContext.getDn();
        Entry entry = addContext.getEntry();
        if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), "subentry")) {
            if (dn.isRootDse() || this.isNamingContext(dn)) {
                throw new LdapOtherException("Cannot find an AdministrativePoint for " + dn);
            }
            Dn apDn = dn.getParent();
            this.checkAdministrativeRole(addContext, apDn);
            Subentry subentry = new Subentry();
            subentry.setAdministrativeRoles(this.getSubentryAdminRoles(entry));
            List<Attribute> operationalAttributes = this.getSubentryOperationalAttributes(dn, subentry);
            this.setSubtreeSpecification(subentry, entry);
            this.directoryService.getSubentryCache().addSubentry(dn, subentry);
            this.next(addContext);
            Dn baseDn = apDn;
            baseDn = baseDn.add(subentry.getSubtreeSpecification().getBase());
            this.updateEntries(addContext, OperationEnum.ADD, apDn, subentry.getSubtreeSpecification(), baseDn, operationalAttributes);
            addContext.setEntry(entry);
        } else {
            for (Dn subentryDn : this.directoryService.getSubentryCache()) {
                Dn apDn = subentryDn.getParent();
                if (!dn.isDescendantOf(apDn)) continue;
                Subentry subentry = this.directoryService.getSubentryCache().getSubentry(subentryDn);
                SubtreeSpecification ss = subentry.getSubtreeSpecification();
                if (!this.directoryService.getEvaluator().evaluate(ss, apDn, dn, entry)) continue;
                if (subentry.isAccessControlAdminRole()) {
                    this.setOperationalAttribute(entry, subentryDn, this.directoryService.getAtProvider().getAccessControlSubentries());
                }
                if (subentry.isSchemaAdminRole()) {
                    this.setOperationalAttribute(entry, subentryDn, this.directoryService.getAtProvider().getSubschemaSubentry());
                }
                if (subentry.isCollectiveAdminRole()) {
                    this.setOperationalAttribute(entry, subentryDn, this.directoryService.getAtProvider().getCollectiveAttributeSubentries());
                }
                if (!subentry.isTriggersAdminRole()) continue;
                this.setOperationalAttribute(entry, subentryDn, this.directoryService.getAtProvider().getTriggerExecutionSubentries());
            }
            addContext.setEntry(entry);
            this.next(addContext);
        }
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        Entry entry = deleteContext.getEntry();
        if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), "subentry")) {
            Dn apDn;
            Subentry removedSubentry = this.directoryService.getSubentryCache().getSubentry(dn);
            Dn baseDn = apDn = dn.getParent();
            baseDn = baseDn.add(removedSubentry.getSubtreeSpecification().getBase());
            this.updateEntries(deleteContext, OperationEnum.REMOVE, apDn, removedSubentry.getSubtreeSpecification(), baseDn, null);
            this.directoryService.getSubentryCache().removeSubentry(dn);
            this.next(deleteContext);
        } else {
            this.next(deleteContext);
        }
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Entry newEntry;
        List<Modification> subentriesOpAttrMods;
        boolean containsSubentryOC;
        Dn dn = modifyContext.getDn();
        List<Modification> modifications = modifyContext.getModItems();
        Entry entry = modifyContext.getEntry();
        boolean isSubtreeSpecificationModification = false;
        Modification subtreeMod = null;
        for (Modification mod : modifications) {
            if (!mod.getAttribute().getAttributeType().equals(this.directoryService.getAtProvider().getSubtreeSpecification())) continue;
            isSubtreeSpecificationModification = true;
            subtreeMod = mod;
            break;
        }
        if ((containsSubentryOC = entry.contains(this.directoryService.getAtProvider().getObjectClass(), "subentry")) && isSubtreeSpecificationModification) {
            Dn apName;
            SubtreeSpecification ssNew;
            Subentry subentry = this.directoryService.getSubentryCache().removeSubentry(dn);
            SubtreeSpecification ssOld = subentry.getSubtreeSpecification();
            try {
                ssNew = this.ssParser.parse(subtreeMod.getAttribute().getString());
            }
            catch (Exception e) {
                String msg = I18n.err(I18n.ERR_71, new Object[0]);
                LOG.error(msg, e);
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
            }
            subentry.setSubtreeSpecification(ssNew);
            subentry.setAdministrativeRoles(this.getSubentryTypes(entry, modifications));
            this.directoryService.getSubentryCache().addSubentry(dn, subentry);
            this.next(modifyContext);
            Dn oldBaseDn = apName = dn.getParent();
            oldBaseDn = oldBaseDn.add(ssOld.getBase());
            PresenceNode filter = new PresenceNode(this.directoryService.getAtProvider().getObjectClass());
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(modifyContext.getSession(), oldBaseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            searchOperationContext.setPartition(modifyContext.getPartition());
            searchOperationContext.setTransaction(modifyContext.getTransaction());
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn candidateDn = candidate.getDn();
                    if (!this.directoryService.getEvaluator().evaluate(ssOld, apName, candidateDn, candidate)) continue;
                    ModifyOperationContext newModifyContext = new ModifyOperationContext(modifyContext.getSession(), candidateDn, this.getOperationalModsForRemove(dn, candidate));
                    newModifyContext.setPartition(modifyContext.getPartition());
                    newModifyContext.setTransaction(modifyContext.getTransaction());
                    this.nexus.modify(newModifyContext);
                }
                subentries.close();
            }
            catch (Exception e) {
                throw new LdapOperationErrorException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
            subentry = this.directoryService.getSubentryCache().getSubentry(dn);
            List<Attribute> operationalAttributes = this.getSubentryOperationalAttributes(dn, subentry);
            Dn newBaseDn = apName;
            newBaseDn = newBaseDn.add(ssNew.getBase());
            searchOperationContext = new SearchOperationContext(modifyContext.getSession(), newBaseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            searchOperationContext.setPartition(modifyContext.getPartition());
            searchOperationContext.setTransaction(modifyContext.getTransaction());
            subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn candidateDn = candidate.getDn();
                    if (!this.directoryService.getEvaluator().evaluate(ssNew, apName, candidateDn, candidate)) continue;
                    this.nexus.modify(new ModifyOperationContext(modifyContext.getSession(), candidateDn, this.getOperationalModsForAdd(candidate, operationalAttributes)));
                }
                subentries.close();
            }
            catch (Exception e) {
                throw new LdapOperationErrorException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        this.next(modifyContext);
        if (!containsSubentryOC && !(subentriesOpAttrMods = this.getModsOnEntryModification(dn, entry, newEntry = modifyContext.getAlteredEntry())).isEmpty()) {
            ModifyOperationContext newModifyContext = new ModifyOperationContext(modifyContext.getSession(), dn, subentriesOpAttrMods);
            newModifyContext.setPartition(modifyContext.getPartition());
            newModifyContext.setTransaction(modifyContext.getTransaction());
            this.nexus.modify(newModifyContext);
        }
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        Dn oldDn = moveContext.getDn();
        Dn newSuperiorDn = moveContext.getNewSuperior();
        Entry entry = moveContext.getOriginalEntry();
        if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), "subentry")) {
            Dn apName;
            this.checkAdministrativeRole(moveContext, newSuperiorDn);
            Subentry subentry = this.directoryService.getSubentryCache().removeSubentry(oldDn);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            Dn baseDn = apName = oldDn.getParent();
            baseDn = baseDn.add(ss.getBase());
            Dn newName = newSuperiorDn;
            newName = newName.add(oldDn.getRdn());
            if (!newName.isSchemaAware()) {
                newName = new Dn(this.schemaManager, newName);
            }
            this.directoryService.getSubentryCache().addSubentry(newName, subentry);
            this.next(moveContext);
            subentry = this.directoryService.getSubentryCache().getSubentry(newName);
            PresenceNode filter = new PresenceNode(this.directoryService.getAtProvider().getObjectClass());
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(moveContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            searchOperationContext.setPartition(moveContext.getPartition());
            searchOperationContext.setTransaction(moveContext.getTransaction());
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn dn = candidate.getDn();
                    if (!dn.isSchemaAware()) {
                        dn = new Dn(this.schemaManager, dn);
                    }
                    if (!this.directoryService.getEvaluator().evaluate(ss, apName, dn, candidate)) continue;
                    ModifyOperationContext newModifyContext = new ModifyOperationContext(moveContext.getSession(), dn, this.getOperationalModsForReplace(oldDn, newName, subentry, candidate));
                    newModifyContext.setPartition(moveContext.getPartition());
                    newModifyContext.setTransaction(moveContext.getTransaction());
                    this.nexus.modify(newModifyContext);
                }
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        if (this.hasAdministrativeDescendant(moveContext, oldDn)) {
            String msg = I18n.err(I18n.ERR_308, new Object[0]);
            LOG.warn(msg);
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
        this.next(moveContext);
        Dn newDn = moveContext.getNewDn();
        List<Modification> mods = this.getModsOnEntryRdnChange(oldDn, newDn, entry);
        if (!mods.isEmpty()) {
            ModifyOperationContext newModifyContext = new ModifyOperationContext(moveContext.getSession(), newDn, mods);
            newModifyContext.setPartition(moveContext.getPartition());
            newModifyContext.setTransaction(moveContext.getTransaction());
            this.nexus.modify(newModifyContext);
        }
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Dn oldDn = moveAndRenameContext.getDn();
        Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
        Entry entry = moveAndRenameContext.getOriginalEntry();
        if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), "subentry")) {
            Dn apName;
            Subentry subentry = this.directoryService.getSubentryCache().removeSubentry(oldDn);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            Dn baseDn = apName = oldDn.getParent();
            baseDn = baseDn.add(ss.getBase());
            Dn newName = newSuperiorDn.getParent();
            if (!(newName = newName.add(moveAndRenameContext.getNewRdn())).isSchemaAware()) {
                newName = new Dn(this.schemaManager, newName);
            }
            this.directoryService.getSubentryCache().addSubentry(newName, subentry);
            this.next(moveAndRenameContext);
            subentry = this.directoryService.getSubentryCache().getSubentry(newName);
            PresenceNode filter = new PresenceNode(this.directoryService.getAtProvider().getObjectClass());
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(moveAndRenameContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            searchOperationContext.setPartition(moveAndRenameContext.getPartition());
            searchOperationContext.setTransaction(moveAndRenameContext.getTransaction());
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn dn = candidate.getDn();
                    if (!dn.isSchemaAware()) {
                        dn = new Dn(this.schemaManager, dn);
                    }
                    if (!this.directoryService.getEvaluator().evaluate(ss, apName, dn, candidate)) continue;
                    ModifyOperationContext newModifyContext = new ModifyOperationContext(moveAndRenameContext.getSession(), dn, this.getOperationalModsForReplace(oldDn, newName, subentry, candidate));
                    newModifyContext.setPartition(moveAndRenameContext.getPartition());
                    newModifyContext.setTransaction(moveAndRenameContext.getTransaction());
                    this.nexus.modify(newModifyContext);
                }
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        if (this.hasAdministrativeDescendant(moveAndRenameContext, oldDn)) {
            String msg = I18n.err(I18n.ERR_308, new Object[0]);
            LOG.warn(msg);
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
        this.next(moveAndRenameContext);
        Dn newDn = moveAndRenameContext.getNewDn();
        List<Modification> mods = this.getModsOnEntryRdnChange(oldDn, newDn, entry);
        if (!mods.isEmpty()) {
            this.nexus.modify(new ModifyOperationContext(moveAndRenameContext.getSession(), newDn, mods));
        }
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Dn oldDn = renameContext.getDn();
        Entry entry = ((ClonedServerEntry)renameContext.getEntry()).getClonedEntry();
        if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), "subentry")) {
            Dn apName;
            Subentry subentry = this.directoryService.getSubentryCache().removeSubentry(oldDn);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            Dn baseDn = apName = oldDn.getParent();
            baseDn = baseDn.add(ss.getBase());
            Dn newName = oldDn.getParent();
            if (!(newName = newName.add(renameContext.getNewRdn())).isSchemaAware()) {
                newName = new Dn(this.schemaManager, newName);
            }
            this.directoryService.getSubentryCache().addSubentry(newName, subentry);
            this.next(renameContext);
            subentry = this.directoryService.getSubentryCache().getSubentry(newName);
            PresenceNode filter = new PresenceNode(this.directoryService.getAtProvider().getObjectClass());
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(renameContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            searchOperationContext.setPartition(renameContext.getPartition());
            searchOperationContext.setTransaction(renameContext.getTransaction());
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn dn = candidate.getDn();
                    if (!dn.isSchemaAware()) {
                        dn = new Dn(this.schemaManager, dn);
                    }
                    if (!this.directoryService.getEvaluator().evaluate(ss, apName, dn, candidate)) continue;
                    this.nexus.modify(new ModifyOperationContext(renameContext.getSession(), dn, this.getOperationalModsForReplace(oldDn, newName, subentry, candidate)));
                }
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        if (this.hasAdministrativeDescendant(renameContext, oldDn)) {
            String msg = I18n.err(I18n.ERR_308, new Object[0]);
            LOG.warn(msg);
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
        this.next(renameContext);
        Dn newName = renameContext.getNewDn();
        List<Modification> mods = this.getModsOnEntryRdnChange(oldDn, newName, entry);
        if (!mods.isEmpty()) {
            ModifyOperationContext newModifyContext = new ModifyOperationContext(renameContext.getSession(), newName, mods);
            newModifyContext.setPartition(renameContext.getPartition());
            newModifyContext.setTransaction(renameContext.getTransaction());
            this.nexus.modify(newModifyContext);
        }
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(searchContext);
        if (searchContext.getScope() == SearchScope.OBJECT) {
            return cursor;
        }
        if (searchContext.isSyncreplSearch()) {
            return cursor;
        }
        if (!this.isSubentryVisible(searchContext)) {
            cursor.addEntryFilter(new HideSubentriesFilter());
        } else {
            cursor.addEntryFilter(new HideEntriesFilter());
        }
        return cursor;
    }

    private class HideEntriesFilter
    implements EntryFilter {
        private HideEntriesFilter() {
        }

        @Override
        public boolean accept(SearchOperationContext searchContext, Entry entry) throws LdapException {
            if (SubentryInterceptor.this.directoryService.getSubentryCache().hasSubentry(entry.getDn())) {
                return true;
            }
            return entry.contains(SubentryInterceptor.this.directoryService.getAtProvider().getObjectClass(), "subentry");
        }

        @Override
        public String toString(String tabs) {
            return tabs + "HideEntriesFilter";
        }
    }

    private class HideSubentriesFilter
    implements EntryFilter {
        private HideSubentriesFilter() {
        }

        @Override
        public boolean accept(SearchOperationContext searchContext, Entry entry) throws LdapException {
            if (SubentryInterceptor.this.directoryService.getSubentryCache().hasSubentry(entry.getDn())) {
                return false;
            }
            return !entry.contains(SubentryInterceptor.this.directoryService.getAtProvider().getObjectClass(), SubentryInterceptor.this.subentryOC);
        }

        @Override
        public String toString(String tabs) {
            return tabs + "HideSubentriesFilter";
        }
    }

    private static enum OperationEnum {
        ADD,
        REMOVE,
        REPLACE;

    }
}

