/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.directory.api.ldap.codec.api.DefaultConfigurableBinaryAttributeDetector;
import org.apache.directory.api.util.Network;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.LdapConnectionValidator;
import org.apache.directory.ldap.client.template.LdapConnectionTemplate;
import org.apache.directory.server.annotations.CreateLdapConnectionPool;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLdapConnectionPoolRule
extends CreateLdapServerRule {
    private static final Logger LOG = LoggerFactory.getLogger(CreateLdapConnectionPoolRule.class);
    private CreateLdapConnectionPoolRule classCreateLdapConnectionPoolRule;
    private CreateLdapConnectionPool createLdapConnectionPool;
    private LdapConnectionPool ldapConnectionPool;
    private LdapConnectionFactory ldapConnectionFactory;
    private LdapConnectionTemplate ldapConnectionTemplate;
    private PooledObjectFactory<LdapConnection> poolableLdapConnectionFactory;

    public CreateLdapConnectionPoolRule() {
        this(null);
    }

    public CreateLdapConnectionPoolRule(CreateLdapConnectionPoolRule classCreateLdapConnectionPoolRule) {
        super(classCreateLdapConnectionPoolRule);
        this.classCreateLdapConnectionPoolRule = classCreateLdapConnectionPoolRule;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        return super.apply(this.buildStatement(base, description), description);
    }

    private Statement buildStatement(final Statement base, final Description description) {
        this.createLdapConnectionPool = (CreateLdapConnectionPool)description.getAnnotation(CreateLdapConnectionPool.class);
        if (this.createLdapConnectionPool == null) {
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    LdapServer ldapServer = CreateLdapConnectionPoolRule.this.getLdapServer();
                    if (CreateLdapConnectionPoolRule.this.classCreateLdapConnectionPoolRule != null && CreateLdapConnectionPoolRule.this.classCreateLdapConnectionPoolRule.getLdapServer() != ldapServer) {
                        LOG.trace("Creating connection pool to new ldap server");
                        LdapConnectionPool oldLdapConnectionPool = CreateLdapConnectionPoolRule.this.ldapConnectionPool;
                        LdapConnectionTemplate oldLdapConnectionTemplate = CreateLdapConnectionPoolRule.this.ldapConnectionTemplate;
                        Class<? extends PooledObjectFactory<LdapConnection>> factoryClass = CreateLdapConnectionPoolRule.this.classCreateLdapConnectionPoolRule.createLdapConnectionPool.factoryClass();
                        Class<? extends LdapConnectionFactory> connectionFactoryClass = CreateLdapConnectionPoolRule.this.classCreateLdapConnectionPoolRule.createLdapConnectionPool.connectionFactoryClass();
                        Class<? extends LdapConnectionValidator> validatorClass = CreateLdapConnectionPoolRule.this.classCreateLdapConnectionPoolRule.createLdapConnectionPool.validatorClass();
                        CreateLdapConnectionPoolRule.this.ldapConnectionPool = CreateLdapConnectionPoolRule.this.classCreateLdapConnectionPoolRule.createLdapConnectionPool(ldapServer, factoryClass, connectionFactoryClass, validatorClass);
                        CreateLdapConnectionPoolRule.this.ldapConnectionTemplate = new LdapConnectionTemplate(CreateLdapConnectionPoolRule.this.ldapConnectionPool);
                        try {
                            base.evaluate();
                        }
                        finally {
                            LOG.trace("Reverting to old connection pool");
                            CreateLdapConnectionPoolRule.this.ldapConnectionPool = oldLdapConnectionPool;
                            CreateLdapConnectionPoolRule.this.ldapConnectionTemplate = oldLdapConnectionTemplate;
                        }
                    } else {
                        LOG.trace("no @CreateLdapConnectionPool on: {}", (Object)description);
                        base.evaluate();
                    }
                }
            };
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                LOG.trace("Creating ldap connection pool");
                Class<? extends PooledObjectFactory<LdapConnection>> factoryClass = CreateLdapConnectionPoolRule.this.createLdapConnectionPool.factoryClass();
                Class<? extends LdapConnectionFactory> connectionFactoryClass = CreateLdapConnectionPoolRule.this.createLdapConnectionPool.connectionFactoryClass();
                Class<? extends LdapConnectionValidator> validatorClass = CreateLdapConnectionPoolRule.this.createLdapConnectionPool.validatorClass();
                CreateLdapConnectionPoolRule.this.ldapConnectionPool = CreateLdapConnectionPoolRule.this.createLdapConnectionPool(CreateLdapConnectionPoolRule.this.getLdapServer(), factoryClass, connectionFactoryClass, validatorClass);
                CreateLdapConnectionPoolRule.this.ldapConnectionTemplate = new LdapConnectionTemplate(CreateLdapConnectionPoolRule.this.ldapConnectionPool);
                try {
                    base.evaluate();
                }
                finally {
                    LOG.trace("Closing ldap connection pool");
                    CreateLdapConnectionPoolRule.this.ldapConnectionPool.close();
                    CreateLdapConnectionPoolRule.this.ldapConnectionTemplate = null;
                }
            }
        };
    }

    private LdapConnectionPool createLdapConnectionPool(LdapServer ldapServer, Class<? extends PooledObjectFactory<LdapConnection>> factoryClass, Class<? extends LdapConnectionFactory> connectionFactoryClass, Class<? extends LdapConnectionValidator> validatorClass) {
        Constructor<Object> constructor;
        LdapConnectionConfig config = new LdapConnectionConfig();
        config.setLdapHost(Network.LOOPBACK_HOSTNAME);
        config.setLdapPort(ldapServer.getPort());
        config.setName("uid=admin,ou=system");
        config.setCredentials("secret");
        if (this.createLdapConnectionPool.additionalBinaryAttributes() != null && this.createLdapConnectionPool.additionalBinaryAttributes().length > 0) {
            DefaultConfigurableBinaryAttributeDetector binaryAttributeDetector = new DefaultConfigurableBinaryAttributeDetector();
            binaryAttributeDetector.addBinaryAttribute(this.createLdapConnectionPool.additionalBinaryAttributes());
            config.setBinaryAttributeDetector(binaryAttributeDetector);
        }
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setLifo(this.createLdapConnectionPool.lifo());
        poolConfig.setMaxTotal(this.createLdapConnectionPool.maxActive());
        poolConfig.setMaxIdle(this.createLdapConnectionPool.maxIdle());
        poolConfig.setMaxWaitMillis(this.createLdapConnectionPool.maxWait());
        poolConfig.setMinEvictableIdleTimeMillis(this.createLdapConnectionPool.minEvictableIdleTimeMillis());
        poolConfig.setMinIdle(this.createLdapConnectionPool.minIdle());
        poolConfig.setNumTestsPerEvictionRun(this.createLdapConnectionPool.numTestsPerEvictionRun());
        poolConfig.setSoftMinEvictableIdleTimeMillis(this.createLdapConnectionPool.softMinEvictableIdleTimeMillis());
        poolConfig.setTestOnBorrow(this.createLdapConnectionPool.testOnBorrow());
        poolConfig.setTestOnReturn(this.createLdapConnectionPool.testOnReturn());
        poolConfig.setTestWhileIdle(this.createLdapConnectionPool.testWhileIdle());
        poolConfig.setTimeBetweenEvictionRunsMillis(this.createLdapConnectionPool.timeBetweenEvictionRunsMillis());
        poolConfig.setBlockWhenExhausted(this.createLdapConnectionPool.whenExhaustedAction() == 1);
        try {
            constructor = connectionFactoryClass.getConstructor(LdapConnectionConfig.class);
            this.ldapConnectionFactory = constructor.newInstance(config);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid connectionFactoryClass " + connectionFactoryClass.getName() + ": " + e.getMessage(), e);
        }
        try {
            Method timeoutSetter = connectionFactoryClass.getMethod("setTimeOut", Long.TYPE);
            if (timeoutSetter != null) {
                timeoutSetter.invoke((Object)this.ldapConnectionFactory, this.createLdapConnectionPool.timeout());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid connectionFactoryClass " + connectionFactoryClass.getName() + ", missing setTimeOut(long): " + e.getMessage(), e);
        }
        try {
            constructor = factoryClass.getConstructor(LdapConnectionFactory.class);
            this.poolableLdapConnectionFactory = (PooledObjectFactory)constructor.newInstance(this.ldapConnectionFactory);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid factoryClass " + factoryClass.getName() + ": " + e.getMessage(), e);
        }
        try {
            Method setValidator = factoryClass.getMethod("setValidator", LdapConnectionValidator.class);
            if (setValidator != null) {
                setValidator.invoke(this.poolableLdapConnectionFactory, validatorClass.newInstance());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid connectionFactoryClass " + connectionFactoryClass.getName() + ", missing setTimeOut(long): " + e.getMessage(), e);
        }
        return new LdapConnectionPool(this.poolableLdapConnectionFactory, poolConfig);
    }

    public LdapConnectionFactory getLdapConnectionFactory() {
        return this.ldapConnectionFactory == null ? (this.classCreateLdapConnectionPoolRule == null ? null : this.classCreateLdapConnectionPoolRule.getLdapConnectionFactory()) : this.ldapConnectionFactory;
    }

    public LdapConnectionPool getLdapConnectionPool() {
        return this.ldapConnectionPool == null ? (this.classCreateLdapConnectionPoolRule == null ? null : this.classCreateLdapConnectionPoolRule.getLdapConnectionPool()) : this.ldapConnectionPool;
    }

    public LdapConnectionTemplate getLdapConnectionTemplate() {
        return this.ldapConnectionTemplate == null ? (this.classCreateLdapConnectionPoolRule == null ? null : this.classCreateLdapConnectionPoolRule.getLdapConnectionTemplate()) : this.ldapConnectionTemplate;
    }
}

