/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.ldap.model.message.Request;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.ldap.LdapProtocolConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapProtocolUtils {
    public static final String COOKIE_DELIM = ",";
    public static final String REPLICA_ID_PREFIX = "rid=";
    public static final int REPLICA_ID_PREFIX_LEN = "rid=".length();
    public static final String CSN_PREFIX = "csn=";
    private static final int CSN_PREFIX_LEN = "csn=".length();
    private static final Logger LOG = LoggerFactory.getLogger(LdapProtocolUtils.class);

    private LdapProtocolUtils() {
    }

    public static void setRequestControls(OperationContext opContext, Request request) {
        if (request.getControls() != null) {
            opContext.addRequestControls(request.getControls().values().toArray(LdapProtocolConstants.EMPTY_CONTROLS));
        }
    }

    public static void setResponseControls(OperationContext opContext, Response response) {
        response.addAllControls(opContext.getResponseControls());
    }

    public static byte[] createCookie(int replicaId, String csn) {
        String replicaIdStr = StringUtils.leftPad(Integer.toString(replicaId), 3, '0');
        return Strings.getBytesUtf8(REPLICA_ID_PREFIX + replicaIdStr + COOKIE_DELIM + CSN_PREFIX + csn);
    }

    public static boolean isValidCookie(String cookieString) {
        if (cookieString == null || cookieString.trim().length() == 0) {
            return false;
        }
        int pos = cookieString.indexOf(COOKIE_DELIM);
        if (pos <= REPLICA_ID_PREFIX_LEN) {
            return false;
        }
        String replicaId = cookieString.substring(REPLICA_ID_PREFIX_LEN, pos);
        try {
            Integer.parseInt(replicaId);
        }
        catch (NumberFormatException e) {
            LOG.debug("Failed to parse the replica id {}", (Object)replicaId);
            return false;
        }
        if (pos == cookieString.length()) {
            return false;
        }
        String csnString = cookieString.substring(pos + 1 + CSN_PREFIX_LEN);
        return Csn.isValid(csnString);
    }

    public static String getCsn(String cookieString) {
        int pos = cookieString.indexOf(COOKIE_DELIM);
        return cookieString.substring(pos + 1 + CSN_PREFIX_LEN);
    }

    public static int getReplicaId(String cookieString) {
        String replicaId = cookieString.substring(REPLICA_ID_PREFIX_LEN, cookieString.indexOf(COOKIE_DELIM));
        return Integer.parseInt(replicaId);
    }
}

