/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIResponseDecoder;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponse;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponseImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoAmIResponseDecorator
extends ExtendedResponseDecorator<WhoAmIResponse>
implements WhoAmIResponse {
    private static final Logger LOG = LoggerFactory.getLogger(WhoAmIResponseDecorator.class);
    private WhoAmIResponse whoAmIResponse;

    public WhoAmIResponseDecorator(LdapApiService codec, WhoAmIResponse decoratedMessage) {
        super(codec, decoratedMessage);
        this.whoAmIResponse = decoratedMessage;
    }

    @Override
    public void setResponseValue(byte[] responseValue) {
        WhoAmIResponseDecoder decoder = new WhoAmIResponseDecoder();
        try {
            if (responseValue != null) {
                this.whoAmIResponse = decoder.decode(responseValue);
                this.responseValue = new byte[responseValue.length];
                System.arraycopy(responseValue, 0, this.responseValue, 0, responseValue.length);
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_08217_PAYLOAD_DECODING_ERROR, new Object[0]), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getResponseValue() {
        if (this.responseValue == null) {
            try {
                this.responseValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err(I18n.ERR_08218_CERT_GENERATE_PAYLOAD_ENCODING_FAILED, new Object[0]), e);
                throw new RuntimeException(e);
            }
        }
        return this.responseValue;
    }

    @Override
    public byte[] getAuthzId() {
        return ((WhoAmIResponse)this.getDecorated()).getAuthzId();
    }

    @Override
    public void setAuthzId(byte[] authzId) {
        ((WhoAmIResponseImpl)this.getDecorated()).setAuthzId(authzId);
    }

    void setUserId(String userId) {
        ((WhoAmIResponseImpl)this.whoAmIResponse).setUserId(userId);
    }

    void setDn(Dn dn) {
        ((WhoAmIResponseImpl)this.whoAmIResponse).setDn(dn);
    }

    @Override
    public boolean isDnAuthzId() {
        return this.whoAmIResponse.isDnAuthzId();
    }

    @Override
    public boolean isUserAuthzId() {
        return this.whoAmIResponse.isUserAuthzId();
    }

    @Override
    public String getAuthzIdString() {
        return this.whoAmIResponse.getAuthzIdString();
    }

    @Override
    public String getUserId() {
        return this.whoAmIResponse.getUserId();
    }

    @Override
    public Dn getDn() {
        return this.whoAmIResponse.getDn();
    }

    @Override
    public String getResponseName() {
        return null;
    }

    int computeLengthInternal() {
        if (this.whoAmIResponse.getAuthzId() != null) {
            return 1 + TLV.getNbBytes(this.whoAmIResponse.getAuthzId().length) + this.whoAmIResponse.getAuthzId().length;
        }
        return 2;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        BerValue.encode(bb, this.whoAmIResponse.getAuthzId());
        return bb;
    }
}

