/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.extended;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.ExtendedRequestDecorator;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedRequestValue
extends GrammarAction<LdapMessageContainer<ExtendedRequestDecorator<?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedRequestValue.class);

    public StoreExtendedRequestValue() {
        super("Store ExtendedRequest value");
    }

    @Override
    public void action(LdapMessageContainer<ExtendedRequestDecorator<?>> container) {
        ExtendedRequestDecorator<?> extendedRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            extendedRequest.setRequestValue(Strings.EMPTY_BYTES);
        } else {
            extendedRequest.setRequestValue(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05127_EXTENDED_VALUE, new Object[]{extendedRequest.getRequestValue()}));
        }
    }
}

