/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.ldapResult;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreErrorMessage
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreErrorMessage.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreErrorMessage() {
        super("Store error message");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        String errorMessage = null;
        errorMessage = tlv.getLength() == 0 ? "" : Strings.utf8ToString(tlv.getValue().getData());
        ResultResponse response = (ResultResponse)((Object)container.getMessage());
        LdapResult ldapResult = response.getLdapResult();
        ldapResult.setDiagnosticMessage(errorMessage);
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("The error message is : " + errorMessage);
        }
    }
}

