/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.decorators.RequestDecorator;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.AbandonRequest;
import org.apache.directory.shared.ldap.model.message.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbandonRequestDecorator
extends RequestDecorator<AbandonRequest>
implements AbandonRequest {
    public AbandonRequestDecorator(LdapApiService codec, AbandonRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public int getAbandoned() {
        return ((AbandonRequest)this.getDecorated()).getAbandoned();
    }

    @Override
    public AbandonRequest setAbandoned(int requestId) {
        ((AbandonRequest)this.getDecorated()).setAbandoned(requestId);
        return this;
    }

    @Override
    public AbandonRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AbandonRequest addControl(Control control) throws MessageException {
        return (AbandonRequest)super.addControl(control);
    }

    @Override
    public AbandonRequest addAllControls(Control[] controls) throws MessageException {
        return (AbandonRequest)super.addAllControls(controls);
    }

    @Override
    public AbandonRequest removeControl(Control control) throws MessageException {
        return (AbandonRequest)super.removeControl(control);
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)80);
            buffer.put((byte)BerValue.getNbBytes(this.getAbandoned()));
            buffer.put(BerValue.getBytes(this.getAbandoned()));
        }
        catch (BufferOverflowException boe) {
            String msg = I18n.err(I18n.ERR_04005, new Object[0]);
            throw new EncoderException(msg);
        }
        return buffer;
    }

    @Override
    public int computeLength() {
        int length = 2 + BerValue.getNbBytes(this.getAbandoned());
        return length;
    }
}

