/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenCursor<ID extends Comparable<ID>>
extends AbstractIndexCursor<ID, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_719, new Object[0]);
    private final IndexCursor<ParentIdAndRdn<ID>, Entry, ID> cursor;
    private final Store<Entry, ID> db;
    private ID parentId;
    private IndexEntry<ID, ID> prefetched;

    public ChildrenCursor(Store<Entry, ID> db, ID parentId, IndexCursor<ParentIdAndRdn<ID>, Entry, ID> cursor) throws Exception {
        LOG_CURSOR.debug("Creating ChildrenCursor {}", this);
        this.db = db;
        this.parentId = parentId;
        this.cursor = cursor;
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    @Override
    public boolean previous() throws Exception {
        IndexEntry entry;
        this.checkNotClosed("next()");
        boolean hasPrevious = this.cursor.previous();
        if (hasPrevious && ((ParentIdAndRdn)(entry = (IndexEntry)this.cursor.get()).getTuple().getKey()).getParentId().equals(this.parentId)) {
            this.prefetched = entry;
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        boolean hasNext = this.cursor.next();
        if (hasNext) {
            IndexEntry cursorEntry = (IndexEntry)this.cursor.get();
            ForwardIndexEntry<Comparable, Comparable> entry = new ForwardIndexEntry<Comparable, Comparable>();
            entry.setId((Comparable)cursorEntry.getId());
            entry.setKey((Comparable)((ParentIdAndRdn)cursorEntry.getTuple().getKey()).getParentId());
            if (((Comparable)entry.getKey()).equals(this.parentId)) {
                this.prefetched = entry;
                return true;
            }
        }
        return false;
    }

    @Override
    public IndexEntry<ID, ID> get() throws Exception {
        this.checkNotClosed("get()");
        return this.prefetched;
    }

    @Override
    public void close() throws Exception {
        LOG_CURSOR.debug("Closing ChildrenCursor {}", this);
        this.cursor.close();
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing ChildrenCursor {}", this);
        this.cursor.close(cause);
        super.close(cause);
    }
}

