/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.ArrayUtils;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.interceptor.context.AbstractOperationContext;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.model.schema.SchemaUtils;
import org.apache.directory.shared.util.StringConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchingOperationContext
extends AbstractOperationContext {
    private static Logger LOG = LoggerFactory.getLogger(SearchingOperationContext.class);
    protected AliasDerefMode aliasDerefMode = AliasDerefMode.DEREF_ALWAYS;
    protected long sizeLimit = 0L;
    protected int timeLimit = 0;
    protected SearchScope scope = SearchScope.ONELEVEL;
    protected boolean allOperationalAttributes = false;
    protected boolean allUserAttributes = false;
    protected boolean noAttributes = false;
    protected Set<AttributeTypeOptions> returningAttributes;
    protected boolean abandoned = false;
    protected boolean typesOnly = false;

    public SearchingOperationContext(CoreSession session) {
        super(session);
    }

    public SearchingOperationContext(CoreSession session, Dn dn) {
        super(session, dn);
    }

    public SearchingOperationContext(CoreSession session, Dn dn, Set<AttributeTypeOptions> returningAttributes) {
        super(session, dn);
        this.returningAttributes = returningAttributes;
    }

    protected void setReturningAttributes(Collection<String> attributesIds) throws LdapException {
        this.setReturningAttributes(attributesIds.toArray(StringConstants.EMPTY_STRINGS));
    }

    public void setReturningAttributes(String[] attributesIds) throws LdapException {
        if (attributesIds != null && attributesIds.length != 0) {
            this.returningAttributes = new HashSet<AttributeTypeOptions>();
            for (String returnAttribute : attributesIds) {
                if (returnAttribute.equals("1.1")) {
                    this.noAttributes = true;
                    continue;
                }
                if (returnAttribute.equals("+")) {
                    this.allOperationalAttributes = true;
                    continue;
                }
                if (returnAttribute.equals("*")) {
                    this.allUserAttributes = true;
                    continue;
                }
                try {
                    String id = SchemaUtils.stripOptions(returnAttribute);
                    Set<String> options = SchemaUtils.getOptions(returnAttribute);
                    AttributeType attributeType = this.session.getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry(id);
                    AttributeTypeOptions attrOptions = new AttributeTypeOptions(attributeType, options);
                    this.returningAttributes.add(attrOptions);
                }
                catch (LdapNoSuchAttributeException nsae) {
                    LOG.warn("Requested attribute {} does not exist in the schema, it will be ignored", (Object)returnAttribute);
                }
            }
            if (this.noAttributes && (this.allUserAttributes || this.allOperationalAttributes || !this.returningAttributes.isEmpty())) {
                this.noAttributes = false;
            }
        }
    }

    public String toString() {
        return "ListOperationContext with Dn '" + this.getDn().getName() + "'";
    }

    public AliasDerefMode getAliasDerefMode() {
        return this.aliasDerefMode;
    }

    public void setAliasDerefMode(AliasDerefMode aliasDerefMode) {
        this.aliasDerefMode = aliasDerefMode;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setAllOperationalAttributes(boolean allOperationalAttribute) {
        this.allOperationalAttributes = allOperationalAttribute;
    }

    public boolean isAllOperationalAttributes() {
        return this.allOperationalAttributes;
    }

    public void setAllUserAttributes(boolean allUserAttributes) {
        this.allUserAttributes = allUserAttributes;
    }

    public boolean isAllUserAttributes() {
        return this.allUserAttributes;
    }

    public void setNoAttributes(boolean noAttributes) {
        this.noAttributes = noAttributes;
    }

    public boolean isNoAttributes() {
        return this.noAttributes;
    }

    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public void setReturningAttributes(Set<AttributeTypeOptions> returningAttributes) {
        this.returningAttributes = returningAttributes;
    }

    public Set<AttributeTypeOptions> getReturningAttributes() {
        return this.returningAttributes;
    }

    public SearchControls getSearchControls() {
        return this.getSearchControls(false);
    }

    public SearchControls getSearchControls(boolean denormalized) {
        SearchControls controls = new SearchControls();
        controls.setCountLimit(this.sizeLimit);
        controls.setSearchScope(this.scope.getScope());
        controls.setTimeLimit(this.timeLimit);
        HashSet<String> allReturningAttributes = new HashSet<String>();
        if (this.noAttributes) {
            allReturningAttributes.add("1.1");
        }
        if (this.allUserAttributes) {
            allReturningAttributes.add("*");
        }
        if (this.allOperationalAttributes) {
            allReturningAttributes.add("+");
        }
        if (this.returningAttributes != null) {
            for (AttributeTypeOptions at : this.returningAttributes) {
                if (denormalized) {
                    allReturningAttributes.add(at.getAttributeType().getName());
                    continue;
                }
                allReturningAttributes.add(at.getAttributeType().getOid());
            }
        }
        if (allReturningAttributes.size() > 0) {
            controls.setReturningAttributes(allReturningAttributes.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
        return controls;
    }

    public void setAbandoned(boolean abandoned) {
        this.abandoned = abandoned;
    }

    public boolean isAbandoned() {
        return this.abandoned;
    }
}

