/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;

public class DeleteOperationContext
extends AbstractChangeOperationContext {
    public DeleteOperationContext(CoreSession session) {
        super(session);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.DELETE));
        }
    }

    public DeleteOperationContext(CoreSession session, Dn deleteDn) {
        super(session, deleteDn);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.DELETE));
        }
    }

    public DeleteOperationContext(CoreSession session, DeleteRequest deleteRequest) {
        super(session, deleteRequest.getName());
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.DELETE));
        }
        this.requestControls = deleteRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    @Override
    public String getName() {
        return MessageTypeEnum.DEL_REQUEST.name();
    }

    public String toString() {
        return "DeleteContext for Dn '" + this.getDn().getName() + "'";
    }

    @Override
    public void setEntry(Entry entry) {
        this.entry = entry;
    }
}

