/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.event;

import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.FilterParser;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;

public class NotificationCriteria {
    private SearchScope scope = SearchScope.ONELEVEL;
    private AliasDerefMode aliasDerefMode = AliasDerefMode.DEREF_ALWAYS;
    private Dn base = null;
    private ExprNode filter = new PresenceNode("objectClass");
    private int eventMask = EventType.ALL_EVENT_TYPES_MASK;

    public NotificationCriteria() {
    }

    public NotificationCriteria(SearchRequest req) {
        this.scope = req.getScope();
        this.aliasDerefMode = req.getDerefAliases();
        this.base = req.getBase();
        this.filter = req.getFilter();
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setAliasDerefMode(AliasDerefMode aliasDerefMode) {
        this.aliasDerefMode = aliasDerefMode;
    }

    public AliasDerefMode getAliasDerefMode() {
        return this.aliasDerefMode;
    }

    public void setBase(Dn base) {
        this.base = base;
    }

    public Dn getBase() {
        return this.base;
    }

    public void setFilter(ExprNode filter) {
        this.filter = filter;
    }

    public void setFilter(String filter) throws Exception {
        this.filter = FilterParser.parse(filter);
    }

    public ExprNode getFilter() {
        return this.filter;
    }

    public void setEventMask(int eventMask) {
        this.eventMask = eventMask;
    }

    public void setEventMask(EventType ... eventTypes) {
        this.eventMask = EventType.getMask(eventTypes);
    }

    public int getEventMask() {
        return this.eventMask;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Notification criteria : ");
        sb.append('\'').append(this.base).append("', ");
        sb.append('\'').append(this.filter).append("', ");
        sb.append('\'').append((Object)this.scope).append("', ");
        sb.append('\'').append((Object)this.aliasDerefMode).append("', ");
        sb.append('\'').append(EventType.toString(this.eventMask)).append('\'');
        return sb.toString();
    }
}

