/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.PresentFilter;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitPresentFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitPresentFilter.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitPresentFilter() {
        super("Init present filter Value");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        PresentFilter presentFilter = new PresentFilter(container.getTlvId());
        searchRequestDecorator.addCurrentFilter(presentFilter);
        searchRequestDecorator.setTerminalFilter(presentFilter);
        String value = Strings.utf8ToString(tlv.getValue().getData());
        if (Strings.isEmpty(value)) {
            presentFilter.setAttributeDescription("");
        } else {
            String type = Strings.utf8ToString(tlv.getValue().getData());
            presentFilter.setAttributeDescription(type);
        }
        searchRequestDecorator.unstackFilters(container);
        if (IS_DEBUG) {
            LOG.debug("Initialize Present filter");
        }
    }
}

