/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.DITContentRule;
import org.apache.directory.shared.ldap.model.schema.DITStructureRule;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.model.schema.NameForm;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.SchemaObject;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.DateUtils;

public class AttributesFactory {
    public Entry getAttributes(SchemaObject obj, Schema schema, SchemaManager schemaManager) throws LdapException {
        if (obj instanceof LdapSyntax) {
            return this.getAttributes((LdapSyntax)obj, schema, schemaManager);
        }
        if (obj instanceof MatchingRule) {
            return this.getAttributes((MatchingRule)obj, schema, schemaManager);
        }
        if (obj instanceof AttributeType) {
            return this.getAttributes((AttributeType)obj, schema, schemaManager);
        }
        if (obj instanceof ObjectClass) {
            return this.getAttributes((ObjectClass)obj, schema, schemaManager);
        }
        if (obj instanceof MatchingRuleUse) {
            return this.getAttributes((MatchingRuleUse)obj, schema, schemaManager);
        }
        if (obj instanceof DITStructureRule) {
            return this.getAttributes((DITStructureRule)obj, schema, schemaManager);
        }
        if (obj instanceof DITContentRule) {
            return this.getAttributes((DITContentRule)obj, schema, schemaManager);
        }
        if (obj instanceof NameForm) {
            return this.getAttributes((NameForm)obj, schema, schemaManager);
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_698, obj.getClass()));
    }

    public Entry getAttributes(Schema schema, SchemaManager schemaManager) throws LdapException {
        String[] dependencies;
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaSchema");
        entry.put("cn", schema.getSchemaName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        if (schema.isDisabled()) {
            entry.put("m-disabled", "TRUE");
        }
        if ((dependencies = schema.getDependencies()) != null && dependencies.length > 0) {
            DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("m-dependencies"));
            for (String dependency : dependencies) {
                attr.add(dependency);
            }
            entry.put(attr);
        }
        return entry;
    }

    public Entry getAttributes(SyntaxChecker syntaxChecker, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaSyntaxChecker");
        entry.put("m-oid", syntaxChecker.getOid());
        entry.put("m-fqcn", syntaxChecker.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry getAttributes(LdapSyntax syntax, Schema schema, SchemaManager schemaManager) throws LdapException {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaSyntax");
        entry.put("x-humanReadable", this.getBoolean(syntax.isHumanReadable()));
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(syntax, entry, schemaManager);
        return entry;
    }

    public Entry getAttributes(String oid, Normalizer normalizer, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaNormalizer");
        entry.put("m-oid", oid);
        entry.put("m-fqcn", normalizer.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry getAttributes(String oid, LdapComparator<? super Object> comparator, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaComparator");
        entry.put("m-oid", oid);
        entry.put("m-fqcn", comparator.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry getAttributes(MatchingRule matchingRule, Schema schema, SchemaManager schemaManager) throws LdapException {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaMatchingRule");
        entry.put("m-syntax", matchingRule.getSyntaxOid());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(matchingRule, entry, schemaManager);
        return entry;
    }

    public Entry getAttributes(MatchingRuleUse matchingRuleUse, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry getAttributes(DITStructureRule dITStructureRule, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry getAttributes(DITContentRule dITContentRule, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry getAttributes(NameForm nameForm, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry getAttributes(AttributeType attributeType, Schema schema, SchemaManager schemaManager) throws LdapException {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaAttributeType");
        entry.put("m-syntax", attributeType.getSyntaxOid());
        entry.put("m-collective", this.getBoolean(attributeType.isCollective()));
        entry.put("m-noUserModification", this.getBoolean(!attributeType.isUserModifiable()));
        entry.put("m-singleValue", this.getBoolean(attributeType.isSingleValued()));
        entry.put("m-usage", attributeType.getUsage().toString());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(attributeType, entry, schemaManager);
        String superiorOid = attributeType.getSuperiorOid();
        if (superiorOid != null) {
            entry.put("m-supAttributeType", superiorOid);
        }
        if (attributeType.getEqualityOid() != null) {
            entry.put("m-equality", attributeType.getEqualityOid());
        }
        if (attributeType.getSubstringOid() != null) {
            entry.put("m-substr", attributeType.getSubstringOid());
        }
        if (attributeType.getOrderingOid() != null) {
            entry.put("m-ordering", attributeType.getOrderingOid());
        }
        return entry;
    }

    public Entry getAttributes(ObjectClass objectClass, Schema schema, SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr;
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaObjectClass");
        entry.put("m-typeObjectClass", objectClass.getType().toString());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(objectClass, entry, schemaManager);
        if (objectClass.getSuperiorOids() != null && objectClass.getSuperiorOids().size() != 0) {
            attr = new DefaultAttribute(schemaManager.getAttributeType("m-supObjectClass"));
            for (String superior : objectClass.getSuperiorOids()) {
                attr.add(superior);
            }
            entry.put(attr);
        }
        if (objectClass.getMustAttributeTypeOids() != null && objectClass.getMustAttributeTypeOids().size() != 0) {
            attr = new DefaultAttribute(schemaManager.getAttributeType("m-must"));
            for (String mustOid : objectClass.getMustAttributeTypeOids()) {
                attr.add(mustOid);
            }
            entry.put(attr);
        }
        if (objectClass.getMayAttributeTypeOids() != null && objectClass.getMayAttributeTypeOids().size() != 0) {
            attr = new DefaultAttribute(schemaManager.getAttributeType("m-may"));
            for (String mayOid : objectClass.getMayAttributeTypeOids()) {
                attr.add(mayOid);
            }
            entry.put(attr);
        }
        return entry;
    }

    private final void injectCommon(SchemaObject object, Entry entry, SchemaManager schemaManager) throws LdapException {
        this.injectNames(object.getNames(), entry, schemaManager);
        entry.put("m-obsolete", this.getBoolean(object.isObsolete()));
        entry.put("m-oid", object.getOid());
        if (object.getDescription() != null) {
            entry.put("m-description", object.getDescription());
        }
    }

    private final void injectNames(List<String> names, Entry entry, SchemaManager schemaManager) throws LdapException {
        if (names == null || names.size() == 0) {
            return;
        }
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("m-name"));
        for (String name : names) {
            attr.add(name);
        }
        entry.put(attr);
    }

    private final String getBoolean(boolean value) {
        if (value) {
            return "TRUE";
        }
        return "FALSE";
    }
}

