/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.changepwd.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.ChangePasswordConfig;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswdErrorType;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswordException;
import org.apache.directory.server.kerberos.changepwd.messages.ChangePasswordReply;
import org.apache.directory.server.kerberos.changepwd.messages.ChangePasswordRequest;
import org.apache.directory.server.kerberos.changepwd.service.ChangePasswordContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.shared.kerberos.KerberosUtils;
import org.apache.directory.shared.kerberos.codec.KerberosDecoder;
import org.apache.directory.shared.kerberos.codec.changePwdData.ChangePasswdDataContainer;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.codec.types.PrincipalNameType;
import org.apache.directory.shared.kerberos.components.EncKrbPrivPart;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.components.HostAddress;
import org.apache.directory.shared.kerberos.components.HostAddresses;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.kerberos.messages.ApRep;
import org.apache.directory.shared.kerberos.messages.ApReq;
import org.apache.directory.shared.kerberos.messages.Authenticator;
import org.apache.directory.shared.kerberos.messages.ChangePasswdData;
import org.apache.directory.shared.kerberos.messages.EncApRepPart;
import org.apache.directory.shared.kerberos.messages.KrbPriv;
import org.apache.directory.shared.kerberos.messages.Ticket;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangePasswordService {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePasswordService.class);
    private static final CipherTextHandler CIPHER_TEXT_HANDLER = new CipherTextHandler();

    private ChangePasswordService() {
    }

    public static void execute(IoSession session, ChangePasswordContext changepwContext) throws Exception {
        if (LOG.isDebugEnabled()) {
            ChangePasswordService.monitorRequest(changepwContext);
        }
        ChangePasswordService.configureChangePassword(changepwContext);
        ChangePasswordService.getAuthHeader(changepwContext);
        ChangePasswordService.verifyServiceTicket(changepwContext);
        ChangePasswordService.getServerEntry(changepwContext);
        ChangePasswordService.verifyServiceTicketAuthHeader(changepwContext);
        ChangePasswordService.extractPassword(changepwContext);
        if (LOG.isDebugEnabled()) {
            ChangePasswordService.monitorContext(changepwContext);
        }
        ChangePasswordService.processPasswordChange(changepwContext);
        ChangePasswordService.buildReply(changepwContext);
        if (LOG.isDebugEnabled()) {
            ChangePasswordService.monitorReply(changepwContext);
        }
    }

    private static void processPasswordChange(ChangePasswordContext changepwContext) throws KerberosException {
        PrincipalStore store = changepwContext.getStore();
        Authenticator authenticator = changepwContext.getAuthenticator();
        String newPassword = Strings.utf8ToString(changepwContext.getPasswordData().getNewPasswd());
        KerberosPrincipal byPrincipal = KerberosUtils.getKerberosPrincipal(authenticator.getCName(), authenticator.getCRealm());
        KerberosPrincipal targetPrincipal = null;
        PrincipalName targName = changepwContext.getPasswordData().getTargName();
        targetPrincipal = targName != null ? new KerberosPrincipal(targName.getNameString(), PrincipalNameType.KRB_NT_PRINCIPAL.getValue()) : byPrincipal;
        store.changePassword(byPrincipal, targetPrincipal, newPassword, changepwContext.getTicket().getEncTicketPart().getFlags().isInitial());
        LOG.debug("Successfully modified password for {} BY {}.", (Object)targetPrincipal, (Object)byPrincipal);
    }

    private static void monitorRequest(ChangePasswordContext changepwContext) throws KerberosException {
        try {
            ChangePasswordRequest request = (ChangePasswordRequest)changepwContext.getRequest();
            short versionNumber = request.getVersionNumber();
            StringBuffer sb = new StringBuffer();
            sb.append("Responding to change password request:");
            sb.append("\n\tversionNumber    " + versionNumber);
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_152, new Object[0]), e);
        }
    }

    private static void configureChangePassword(ChangePasswordContext changepwContext) {
        changepwContext.setCipherTextHandler(CIPHER_TEXT_HANDLER);
    }

    private static void getAuthHeader(ChangePasswordContext changepwContext) throws KerberosException {
        ChangePasswordRequest request = (ChangePasswordRequest)changepwContext.getRequest();
        short pvno = request.getVersionNumber();
        if (pvno != -128 && pvno != 1) {
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_BAD_VERSION);
        }
        if (request.getAuthHeader() == null || request.getAuthHeader().getTicket() == null) {
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_AUTHERROR);
        }
        ApReq authHeader = request.getAuthHeader();
        Ticket ticket = authHeader.getTicket();
        changepwContext.setAuthHeader(authHeader);
        changepwContext.setTicket(ticket);
    }

    private static void verifyServiceTicket(ChangePasswordContext changepwContext) throws KerberosException {
        ChangePasswordConfig config = changepwContext.getConfig();
        Ticket ticket = changepwContext.getTicket();
        String primaryRealm = config.getPrimaryRealm();
        KerberosPrincipal changepwPrincipal = config.getServicePrincipal();
        KerberosPrincipal serverPrincipal = KerberosUtils.getKerberosPrincipal(ticket.getSName(), ticket.getRealm());
        if (!ticket.getRealm().equals(primaryRealm) || !serverPrincipal.getName().equals(changepwPrincipal.getName())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOT_US);
        }
    }

    private static void getServerEntry(ChangePasswordContext changepwContext) throws KerberosException {
        Ticket ticket = changepwContext.getTicket();
        KerberosPrincipal principal = KerberosUtils.getKerberosPrincipal(ticket.getSName(), ticket.getRealm());
        PrincipalStore store = changepwContext.getStore();
        changepwContext.setServerEntry(KerberosUtils.getEntry(principal, store, ErrorType.KDC_ERR_S_PRINCIPAL_UNKNOWN));
    }

    private static void verifyServiceTicketAuthHeader(ChangePasswordContext changepwContext) throws KerberosException {
        ApReq authHeader = changepwContext.getAuthHeader();
        Ticket ticket = changepwContext.getTicket();
        EncryptionType encryptionType = ticket.getEncPart().getEType();
        EncryptionKey serverKey = changepwContext.getServerEntry().getKeyMap().get((Object)encryptionType);
        long clockSkew = changepwContext.getConfig().getAllowableClockSkew();
        ReplayCache replayCache = changepwContext.getReplayCache();
        boolean emptyAddressesAllowed = changepwContext.getConfig().isEmptyAddressesAllowed();
        InetAddress clientAddress = changepwContext.getClientAddress();
        CipherTextHandler cipherTextHandler = changepwContext.getCipherTextHandler();
        Authenticator authenticator = KerberosUtils.verifyAuthHeader(authHeader, ticket, serverKey, clockSkew, replayCache, emptyAddressesAllowed, clientAddress, cipherTextHandler, KeyUsage.AP_REQ_AUTHNT_SESS_KEY, false);
        changepwContext.setAuthenticator(authenticator);
    }

    private static void extractPassword(ChangePasswordContext changepwContext) throws Exception {
        ChangePasswordRequest request = (ChangePasswordRequest)changepwContext.getRequest();
        Authenticator authenticator = changepwContext.getAuthenticator();
        CipherTextHandler cipherTextHandler = changepwContext.getCipherTextHandler();
        EncryptionKey subSessionKey = authenticator.getSubKey();
        EncryptedData encReqPrivPart = request.getPrivateMessage().getEncPart();
        ChangePasswdData passwordData = null;
        try {
            byte[] decryptedData = cipherTextHandler.decrypt(subSessionKey, encReqPrivPart, KeyUsage.KRB_PRIV_ENC_PART_CHOSEN_KEY);
            EncKrbPrivPart privatePart = KerberosDecoder.decodeEncKrbPrivPart(decryptedData);
            if (authenticator.getSeqNumber().intValue() != privatePart.getSeqNumber()) {
                throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_MALFORMED);
            }
            if (request.getVersionNumber() == 1) {
                passwordData = new ChangePasswdData();
                passwordData.setNewPasswd(privatePart.getUserData());
            } else {
                Asn1Decoder passwordDecoder = new Asn1Decoder();
                ByteBuffer stream = ByteBuffer.wrap(privatePart.getUserData());
                ChangePasswdDataContainer container = new ChangePasswdDataContainer(stream);
                passwordDecoder.decode(stream, container);
                passwordData = container.getChngPwdData();
            }
        }
        catch (KerberosException ke) {
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_SOFTERROR, (Throwable)ke);
        }
        changepwContext.setChngPwdData(passwordData);
    }

    private static void monitorContext(ChangePasswordContext changepwContext) throws KerberosException {
        try {
            PrincipalStore store = changepwContext.getStore();
            ApReq authHeader = changepwContext.getAuthHeader();
            Ticket ticket = changepwContext.getTicket();
            ReplayCache replayCache = changepwContext.getReplayCache();
            long clockSkew = changepwContext.getConfig().getAllowableClockSkew();
            Authenticator authenticator = changepwContext.getAuthenticator();
            KerberosPrincipal clientPrincipal = KerberosUtils.getKerberosPrincipal(authenticator.getCName(), authenticator.getCRealm());
            InetAddress clientAddress = changepwContext.getClientAddress();
            HostAddresses clientAddresses = ticket.getEncTicketPart().getClientAddresses();
            boolean caddrContainsSender = false;
            if (ticket.getEncTicketPart().getClientAddresses() != null) {
                caddrContainsSender = ticket.getEncTicketPart().getClientAddresses().contains(new HostAddress(clientAddress));
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Monitoring context:");
            sb.append("\n\tstore                  " + store);
            sb.append("\n\tauthHeader             " + authHeader);
            sb.append("\n\tticket                 " + ticket);
            sb.append("\n\treplayCache            " + replayCache);
            sb.append("\n\tclockSkew              " + clockSkew);
            sb.append("\n\tclientPrincipal        " + clientPrincipal);
            sb.append("\n\tChangePasswdData        " + changepwContext.getPasswordData());
            sb.append("\n\tclientAddress          " + clientAddress);
            sb.append("\n\tclientAddresses        " + clientAddresses);
            sb.append("\n\tcaddr contains sender  " + caddrContainsSender);
            sb.append("\n\tTicket principal       " + ticket.getSName());
            PrincipalStoreEntry ticketPrincipal = changepwContext.getServerEntry();
            sb.append("\n\tcn                     " + ticketPrincipal.getCommonName());
            sb.append("\n\trealm                  " + ticketPrincipal.getRealmName());
            sb.append("\n\tService principal      " + ticketPrincipal.getPrincipal());
            sb.append("\n\tSAM type               " + (Object)((Object)ticketPrincipal.getSamType()));
            EncryptionType encryptionType = ticket.getEncPart().getEType();
            int keyVersion = ticketPrincipal.getKeyMap().get((Object)encryptionType).getKeyVersion();
            sb.append("\n\tTicket key type        " + (Object)((Object)encryptionType));
            sb.append("\n\tService key version    " + keyVersion);
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_154, new Object[0]), e);
        }
    }

    private static void buildReply(ChangePasswordContext changepwContext) throws KerberosException, UnknownHostException {
        EncryptedData encRepPart;
        EncryptedData encPrivPart;
        Authenticator authenticator = changepwContext.getAuthenticator();
        Ticket ticket = changepwContext.getTicket();
        CipherTextHandler cipherTextHandler = changepwContext.getCipherTextHandler();
        EncKrbPrivPart privPart = new EncKrbPrivPart();
        byte[] resultCode = new byte[]{0, 0, 80, 97, 115, 115, 119, 111, 114, 100, 32, 99, 104, 97, 110, 103, 101, 100, 0};
        privPart.setUserData(resultCode);
        privPart.setSenderAddress(new HostAddress(InetAddress.getLocalHost()));
        EncryptionKey subSessionKey = authenticator.getSubKey();
        try {
            encPrivPart = cipherTextHandler.seal(subSessionKey, privPart, KeyUsage.KRB_PRIV_ENC_PART_CHOSEN_KEY);
        }
        catch (KerberosException ke) {
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_SOFTERROR, (Throwable)ke);
        }
        KrbPriv privateMessage = new KrbPriv();
        privateMessage.setEncPart(encPrivPart);
        EncApRepPart repPart = new EncApRepPart();
        repPart.setCTime(authenticator.getCtime());
        repPart.setCusec(authenticator.getCusec());
        if (authenticator.getSeqNumber() != null) {
            repPart.setSeqNumber(authenticator.getSeqNumber());
        }
        repPart.setSubkey(subSessionKey);
        try {
            encRepPart = cipherTextHandler.seal(ticket.getEncTicketPart().getKey(), repPart, KeyUsage.AP_REP_ENC_PART_SESS_KEY);
        }
        catch (KerberosException ke) {
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_SOFTERROR, (Throwable)ke);
        }
        ApRep appReply = new ApRep();
        appReply.setEncPart(encRepPart);
        changepwContext.setReply(new ChangePasswordReply(1, appReply, privateMessage));
    }

    private static void monitorReply(ChangePasswordContext changepwContext) throws KerberosException {
        try {
            ChangePasswordReply reply = (ChangePasswordReply)changepwContext.getReply();
            ApRep appReply = reply.getApplicationReply();
            KrbPriv priv = reply.getPrivateMessage();
            StringBuilder sb = new StringBuilder();
            sb.append("Responding with change password reply:");
            sb.append("\n\tappReply               " + appReply);
            sb.append("\n\tpriv                   " + priv);
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_155, new Object[0]), e);
        }
    }
}

