/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.util.Iterator;
import java.util.Map;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultDoneImpl;
import org.apache.directory.api.ldap.model.message.SearchResultEntryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryToResponseCursor
extends AbstractCursor<Response>
implements SearchCursor {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private Cursor<Entry> wrapped;
    private SearchResultDone searchDoneResp;
    private boolean done;
    private int messageId;
    private SearchRequest searchRequest;

    public EntryToResponseCursor(SearchRequest searchRequest, int messageId, Cursor<Entry> wrapped) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating EntryToResponseCursor {}", (Object)this);
        }
        this.searchRequest = searchRequest;
        this.wrapped = wrapped;
        this.messageId = messageId;
    }

    @Override
    public Iterator<Response> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void after(Response resp) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.wrapped.afterLast();
    }

    @Override
    public boolean available() {
        return this.wrapped.available();
    }

    @Override
    public void before(Response resp) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.wrapped.beforeFirst();
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryToResponseCursor {}", (Object)this);
        }
        this.wrapped.close();
    }

    @Override
    public void close(Exception e) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryToResponseCursor {}", (Object)this);
        }
        this.wrapped.close(e);
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        return this.wrapped.first();
    }

    @Override
    public Response get() throws CursorException {
        Entry entry = this.wrapped.get();
        SearchResultEntryImpl se = new SearchResultEntryImpl(this.messageId);
        se.setEntry(entry);
        return se;
    }

    @Override
    public SearchResultDone getSearchResultDone() {
        return this.searchDoneResp;
    }

    @Override
    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        return this.wrapped.last();
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        boolean next = this.wrapped.next();
        if (!next) {
            this.searchDoneResp = new SearchResultDoneImpl(this.messageId);
            ResultCodeEnum re = ResultCodeEnum.SUCCESS;
            ResultResponse processedResp = this.searchRequest.getResultResponse();
            LdapResult filledResult = processedResp.getLdapResult();
            if (filledResult.getResultCode() != re) {
                re = filledResult.getResultCode();
            }
            this.searchDoneResp.getLdapResult().setResultCode(re);
            Map<String, Control> ctrls = processedResp.getControls();
            if (ctrls != null) {
                Iterator<Control> itr = ctrls.values().iterator();
                while (itr.hasNext()) {
                    this.searchDoneResp.addControl(itr.next());
                }
            }
            this.done = true;
        }
        return next;
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        return this.wrapped.previous();
    }

    @Override
    public void setClosureMonitor(ClosureMonitor monitor) {
        this.wrapped.setClosureMonitor(monitor);
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isReferral() {
        return false;
    }

    @Override
    public Referral getReferral() throws LdapException {
        throw new LdapException();
    }

    @Override
    public boolean isEntry() {
        return true;
    }

    @Override
    public Entry getEntry() throws LdapException {
        if (!this.done && this.wrapped.available()) {
            try {
                return this.wrapped.get();
            }
            catch (Exception e) {
                throw new LdapException(e);
            }
        }
        throw new LdapException();
    }

    @Override
    public boolean isIntermediate() {
        return false;
    }

    @Override
    public IntermediateResponse getIntermediate() throws LdapException {
        throw new LdapException();
    }
}

