/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.directory.api.ldap.model.schema.UsageEnum;

public class AttributeType
extends AbstractSchemaObject
implements Cloneable {
    public static final long serialVersionUID = 1L;
    protected String syntaxOid;
    protected LdapSyntax syntax;
    protected String equalityOid;
    protected MatchingRule equality;
    protected String substringOid;
    protected MatchingRule substring;
    protected String orderingOid;
    protected MatchingRule ordering;
    protected String superiorOid;
    protected AttributeType superior;
    protected boolean isSingleValued = false;
    protected boolean isCollective = false;
    protected boolean canUserModify = true;
    protected UsageEnum usage = UsageEnum.USER_APPLICATIONS;
    protected long syntaxLength = 0L;

    public AttributeType(String oid) {
        super(SchemaObjectType.ATTRIBUTE_TYPE, oid);
    }

    public boolean isSingleValued() {
        return this.isSingleValued;
    }

    public boolean isUserModifiable() {
        return this.canUserModify;
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public UsageEnum getUsage() {
        return this.usage;
    }

    public long getSyntaxLength() {
        return this.syntaxLength;
    }

    public AttributeType getSuperior() {
        return this.superior;
    }

    public String getSuperiorOid() {
        return this.superiorOid;
    }

    public String getSuperiorName() {
        if (this.superior != null) {
            return this.superior.getName();
        }
        return this.superiorOid;
    }

    public LdapSyntax getSyntax() {
        return this.syntax;
    }

    public String getSyntaxName() {
        if (this.syntax != null) {
            return this.syntax.getName();
        }
        return this.syntaxOid;
    }

    public String getSyntaxOid() {
        return this.syntaxOid;
    }

    public MatchingRule getEquality() {
        return this.equality;
    }

    public String getEqualityOid() {
        return this.equalityOid;
    }

    public String getEqualityName() {
        if (this.equality != null) {
            return this.equality.getName();
        }
        return this.equalityOid;
    }

    public MatchingRule getOrdering() {
        return this.ordering;
    }

    public String getOrderingName() {
        if (this.ordering != null) {
            return this.ordering.getName();
        }
        return this.orderingOid;
    }

    public String getOrderingOid() {
        return this.orderingOid;
    }

    public MatchingRule getSubstring() {
        return this.substring;
    }

    public String getSubstringName() {
        if (this.substring != null) {
            return this.substring.getName();
        }
        return this.substringOid;
    }

    public String getSubstringOid() {
        return this.substringOid;
    }

    public boolean isUser() {
        return this.usage == UsageEnum.USER_APPLICATIONS;
    }

    public boolean isOperational() {
        return this.usage != UsageEnum.USER_APPLICATIONS;
    }

    public boolean isAncestorOf(AttributeType descendant) {
        if (descendant == null || this.equals(descendant)) {
            return false;
        }
        return this.isAncestorOrEqual(this, descendant);
    }

    public boolean isDescendantOf(AttributeType ancestor) {
        if (ancestor == null || this.equals(ancestor)) {
            return false;
        }
        return this.isAncestorOrEqual(ancestor, this);
    }

    private boolean isAncestorOrEqual(AttributeType ancestor, AttributeType descendant) {
        if (ancestor == null || descendant == null) {
            return false;
        }
        if (ancestor.equals(descendant)) {
            return true;
        }
        return this.isAncestorOrEqual(ancestor, descendant.getSuperior());
    }

    public String toString() {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(this);
    }

    @Override
    public AttributeType copy() {
        MutableAttributeType copy = new MutableAttributeType(this.oid);
        copy.copy(this);
        copy.canUserModify = this.canUserModify;
        copy.isCollective = this.isCollective;
        copy.isSingleValued = this.isSingleValued;
        copy.usage = this.usage;
        copy.equality = null;
        copy.equalityOid = this.equalityOid;
        copy.ordering = null;
        copy.orderingOid = this.orderingOid;
        copy.substring = null;
        copy.substringOid = this.substringOid;
        copy.superior = null;
        copy.superiorOid = this.superiorOid;
        copy.syntax = null;
        copy.syntaxOid = this.syntaxOid;
        copy.syntaxLength = this.syntaxLength;
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AttributeType)) {
            return false;
        }
        AttributeType that = (AttributeType)o;
        if (this.isCollective != that.isCollective) {
            return false;
        }
        if (this.isSingleValued != that.isSingleValued) {
            return false;
        }
        if (this.canUserModify != that.canUserModify) {
            return false;
        }
        if (this.usage != that.usage) {
            return false;
        }
        if (!this.compareOid(this.equalityOid, that.equalityOid)) {
            return false;
        }
        if (this.equality != null ? !this.equality.equals(that.equality) : that.equality != null) {
            return false;
        }
        if (!this.compareOid(this.orderingOid, that.orderingOid)) {
            return false;
        }
        if (this.ordering != null ? !this.ordering.equals(that.ordering) : that.ordering != null) {
            return false;
        }
        if (!this.compareOid(this.substringOid, that.substringOid)) {
            return false;
        }
        if (this.substring != null ? !this.substring.equals(that.substring) : that.substring != null) {
            return false;
        }
        if (!this.compareOid(this.superiorOid, that.superiorOid)) {
            return false;
        }
        if (this.superior != null ? !this.superior.equals(that.superior) : that.superior != null) {
            return false;
        }
        if (!this.compareOid(this.syntaxOid, that.syntaxOid)) {
            return false;
        }
        if (this.syntaxLength != that.syntaxLength) {
            return false;
        }
        if (this.syntax == null) {
            return that.syntax == null;
        }
        if (this.syntax.equals(that.syntax)) {
            return this.syntaxLength == that.syntaxLength;
        }
        return false;
    }
}

