/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyManagedException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.server.core.avltree.ArrayMarshaller;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.partition.impl.btree.mavibot.KeyTupleValueCursor;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotCursor;
import org.apache.directory.server.core.partition.impl.btree.mavibot.ValueTreeCursor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotTable<K, V>
extends AbstractTable<K, V> {
    private BTree<K, V> bt;
    private ArrayMarshaller<V> arrayMarshaller;
    private static final Logger LOG = LoggerFactory.getLogger(MavibotTable.class);
    protected RecordManager recordMan;

    public MavibotTable(RecordManager recordMan, SchemaManager schemaManager, String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates) throws IOException {
        this(recordMan, schemaManager, name, keySerializer, valueSerializer, allowDuplicates, 10000);
    }

    public MavibotTable(RecordManager recordMan, SchemaManager schemaManager, String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates, int cacheSize) throws IOException {
        super(schemaManager, name, keySerializer.getComparator(), valueSerializer.getComparator());
        this.recordMan = recordMan;
        this.bt = recordMan.getManagedTree(name);
        if (this.bt == null) {
            this.bt = BTreeFactory.createPersistedBTree(name, keySerializer, valueSerializer, allowDuplicates, cacheSize);
            try {
                recordMan.manage(this.bt);
            }
            catch (BTreeAlreadyManagedException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.bt.setKeySerializer(keySerializer);
            this.bt.setValueSerializer(valueSerializer);
        }
        this.allowsDuplicates = allowDuplicates;
        this.arrayMarshaller = new ArrayMarshaller(this.valueComparator);
        this.count = this.bt.getNbElems();
    }

    @Override
    public boolean isDupsEnabled() {
        return this.allowsDuplicates;
    }

    @Override
    public boolean has(K key) throws LdapException {
        try {
            return this.bt.hasKey(key);
        }
        catch (IOException ioe) {
            throw new LdapException(ioe);
        }
        catch (KeyNotFoundException knfe) {
            throw new LdapException(knfe);
        }
    }

    @Override
    public boolean has(K key, V value) throws LdapException {
        try {
            return this.bt.contains(key, value);
        }
        catch (IOException e) {
            throw new LdapException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGreaterOrEqual(K key) throws Exception {
        TupleCursor<K, V> cursor = null;
        try {
            cursor = this.bt.browseFrom(key);
            boolean bl = cursor.hasNext();
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLessOrEqual(K key) throws Exception {
        TupleCursor<K, V> cursor = null;
        try {
            cursor = this.bt.browseFrom(key);
            org.apache.directory.mavibot.btree.Tuple<K, V> tuple = null;
            if (cursor.hasNext()) {
                tuple = cursor.next();
            }
            if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
                boolean bl = true;
                return bl;
            }
            if (null == tuple) {
                boolean bl = this.count > 0L;
                return bl;
            }
            if (cursor.hasPrev()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public boolean hasGreaterOrEqual(K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_593, new Object[0]));
        }
        TupleCursor cursor = null;
        try {
            if (!this.bt.hasKey(key)) {
                boolean bl = false;
                return bl;
            }
            ValueCursor<V> valueCursor = this.bt.getValues(key);
            int equal = this.bt.getValueSerializer().compare(val, valueCursor.next());
            boolean bl = equal >= 0;
            return bl;
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public boolean hasLessOrEqual(K key, V val) throws Exception {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_593, new Object[0]));
        }
        if (!this.bt.hasKey(key)) {
            return false;
        }
        ValueCursor<V> dupHolder = this.bt.getValues(key);
        return dupHolder.hasNext();
    }

    @Override
    public V get(K key) throws LdapException {
        if (key == null) {
            return null;
        }
        try {
            return this.bt.get(key);
        }
        catch (KeyNotFoundException knfe) {
            return null;
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
    }

    @Override
    public void put(K key, V value) throws Exception {
        try {
            if (value == null || key == null) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_594, new Object[0]));
            }
            V existingVal = this.bt.insert(key, value);
            if (existingVal == null) {
                ++this.count;
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_131, key, this.name), e);
            throw e;
        }
    }

    @Override
    public void remove(K key) throws Exception {
        block7: {
            try {
                if (key == null) {
                    return;
                }
                if (this.bt.isAllowDuplicates()) {
                    ValueCursor<V> valueCursor = this.bt.getValues(key);
                    int size = valueCursor.size();
                    valueCursor.close();
                    org.apache.directory.mavibot.btree.Tuple<K, V> returned = this.bt.delete(key);
                    if (null == returned) {
                        return;
                    }
                    this.count -= (long)size;
                } else {
                    org.apache.directory.mavibot.btree.Tuple<K, V> returned = this.bt.delete(key);
                    if (null == returned) {
                        return;
                    }
                    --this.count;
                }
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_133, key, this.name), e);
                if (!(e instanceof IOException)) break block7;
                throw (IOException)e;
            }
        }
    }

    @Override
    public void remove(K key, V value) throws Exception {
        try {
            if (key == null) {
                return;
            }
            org.apache.directory.mavibot.btree.Tuple<K, V> tuple = this.bt.delete(key, value);
            if (tuple != null) {
                --this.count;
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_132, key, value, this.name), e);
        }
    }

    @Override
    public Cursor<Tuple<K, V>> cursor() throws LdapException {
        return new MavibotCursor(this);
    }

    @Override
    public Cursor<Tuple<K, V>> cursor(K key) throws LdapException {
        if (key == null) {
            return new EmptyCursor<Tuple<K, V>>();
        }
        try {
            if (!this.allowsDuplicates) {
                V val = this.bt.get(key);
                return new SingletonCursor<Tuple<K, V>>(new Tuple<K, V>(key, val));
            }
            ValueCursor<V> dupHolder = this.bt.getValues(key);
            return new KeyTupleValueCursor<K, V>(dupHolder, key);
        }
        catch (KeyNotFoundException knfe) {
            return new EmptyCursor<Tuple<K, V>>();
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
    }

    @Override
    public Cursor<V> valueCursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor();
        }
        try {
            if (!this.allowsDuplicates) {
                V val = this.bt.get(key);
                return new SingletonCursor<V>(val);
            }
            ValueCursor<V> dupCursor = this.bt.getValues(key);
            return new ValueTreeCursor<V>(dupCursor);
        }
        catch (KeyNotFoundException knfe) {
            return new EmptyCursor();
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
    }

    @Override
    public long count(K key) throws Exception {
        if (key == null) {
            return 0L;
        }
        if (this.bt.isAllowDuplicates()) {
            try {
                ValueCursor<V> dupHolder = this.bt.getValues(key);
                int size = dupHolder.size();
                dupHolder.close();
                return size;
            }
            catch (KeyNotFoundException knfe) {
                return 0L;
            }
        }
        if (this.bt.hasKey(key)) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public long greaterThanCount(K key) throws Exception {
        return Math.min(this.count, 10L);
    }

    @Override
    public long lessThanCount(K key) throws Exception {
        return Math.min(this.count, 10L);
    }

    @Override
    public void close() throws Exception {
    }

    public ArrayTree<V> getDupsContainer(byte[] serialized) throws IOException {
        if (serialized == null) {
            return new ArrayTree(this.valueComparator);
        }
        return this.arrayMarshaller.deserialize(serialized);
    }

    protected BTree<K, V> getBTree() {
        return this.bt;
    }

    public synchronized void sync() throws IOException {
    }
}

