/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidLenSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(OidLenSyntaxChecker.class);

    public OidLenSyntaxChecker() {
        super("1.3.6.1.4.1.18060.0.4.0.0.5");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int pos = strValue.indexOf(123);
        if (pos < 0) {
            boolean result = Oid.isOid(strValue);
            if (result) {
                LOG.debug("Syntax valid for '{}'", value);
            } else {
                LOG.debug("Syntax invalid for '{}'", value);
            }
            return result;
        }
        String oid = strValue.substring(0, pos);
        if (!Oid.isOid(oid)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        String len = strValue.substring(pos);
        if (len.charAt(len.length() - 1) != '}') {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        block3: for (int i = 1; i < len.length() - 1; ++i) {
            switch (len.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
            }
        }
        if (len.charAt(1) == '0' && len.length() > 3) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        LOG.debug("Syntax valid for '{}'", value);
        return true;
    }
}

