/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.parsers.AbstractSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectClassDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(ObjectClassDescriptionSchemaParser.class);

    public synchronized MutableObjectClass parseObjectClassDescription(String objectClassDescription) throws ParseException {
        LOG.debug("Parsing an ObjectClass : {}", (Object)objectClassDescription);
        if (objectClassDescription == null) {
            LOG.error(I18n.err(I18n.ERR_04254, new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(objectClassDescription);
        try {
            MutableObjectClass objectClass = this.parser.objectClassDescription();
            ObjectClassDescriptionSchemaParser.updateSchemaName(objectClass);
            return objectClass;
        }
        catch (RecognitionException re) {
            String msg = I18n.err(I18n.ERR_04255, objectClassDescription, re.getMessage(), re.getColumn());
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err(I18n.ERR_04256, objectClassDescription, tse.getMessage());
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    @Override
    public ObjectClass parse(String schemaDescription) throws ParseException {
        return this.parseObjectClassDescription(schemaDescription);
    }
}

