/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras;

import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncInfoValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.startTls.StartTlsFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ExtrasBundleActivator
implements BundleActivator {
    private ServiceReference<?> codecServiceRef;

    public void start(BundleContext context) throws Exception {
        this.codecServiceRef = context.getServiceReference(LdapApiService.class.getName());
        LdapApiService codec = (LdapApiService)context.getService(this.codecServiceRef);
        this.registerExtrasControls(codec);
        this.registerExtrasExtendedOps(codec);
    }

    private void registerExtrasControls(LdapApiService codec) {
        SyncDoneValueFactory syncDoneValuefactory = new SyncDoneValueFactory(codec);
        codec.registerControl(syncDoneValuefactory);
        SyncInfoValueFactory syncInfoValueFactory = new SyncInfoValueFactory(codec);
        codec.registerControl(syncInfoValueFactory);
        SyncRequestValueFactory syncRequestValueFactory = new SyncRequestValueFactory(codec);
        codec.registerControl(syncRequestValueFactory);
        SyncStateValueFactory syncStateValuefactory = new SyncStateValueFactory(codec);
        codec.registerControl(syncStateValuefactory);
        PasswordPolicyFactory passwordPolicyFactory = new PasswordPolicyFactory(codec);
        codec.registerControl(passwordPolicyFactory);
        AdDirSyncFactory adDirSyncFactory = new AdDirSyncFactory(codec);
        codec.registerControl(adDirSyncFactory);
    }

    private void registerExtrasExtendedOps(LdapApiService codec) {
        CancelFactory cancelFactory = new CancelFactory(codec);
        codec.registerExtendedRequest(cancelFactory);
        CertGenerationFactory certGenerationFactory = new CertGenerationFactory(codec);
        codec.registerExtendedRequest(certGenerationFactory);
        GracefulShutdownFactory gracefulShutdownFactory = new GracefulShutdownFactory(codec);
        codec.registerExtendedRequest(gracefulShutdownFactory);
        StoredProcedureFactory storedProcedureFactory = new StoredProcedureFactory(codec);
        codec.registerExtendedRequest(storedProcedureFactory);
        PasswordModifyFactory passwordModifyFactory = new PasswordModifyFactory(codec);
        codec.registerExtendedRequest(passwordModifyFactory);
        GracefulDisconnectFactory gracefulDisconnectFactory = new GracefulDisconnectFactory(codec);
        codec.registerExtendedRequest(gracefulDisconnectFactory);
        WhoAmIFactory whoAmIFactory = new WhoAmIFactory(codec);
        codec.registerExtendedRequest(whoAmIFactory);
        StartTlsFactory startTlsFactory = new StartTlsFactory(codec);
        codec.registerExtendedRequest(startTlsFactory);
    }

    public void stop(BundleContext context) throws Exception {
        LdapApiService codec = (LdapApiService)context.getService(this.codecServiceRef);
        codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.3");
        codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.4");
        codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.1");
        codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.2");
        codec.unregisterControl("1.3.6.1.4.1.42.2.27.8.5.1");
        codec.unregisterExtendedRequest("1.3.6.1.1.8");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.8");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.3");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.6");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.5");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.4203.1.11.1");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.4203.1.11.3");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.1466.20037");
    }
}

