/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.directory.api.ldap.codec.api.DefaultConfigurableBinaryAttributeDetector;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.PoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.template.LdapConnectionTemplate;
import org.apache.directory.server.annotations.CreateLdapConnectionPool;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLdapConnectionPoolRule
extends CreateLdapServerRule {
    private static Logger LOG = LoggerFactory.getLogger(CreateLdapConnectionPoolRule.class);
    private CreateLdapConnectionPoolRule classCreateLdapConnectionPoolRule;
    private CreateLdapConnectionPool createLdapConnectionPool;
    private LdapConnectionPool ldapConnectionPool;
    private LdapConnectionTemplate ldapConnectionTemplate;

    public CreateLdapConnectionPoolRule() {
        this(null);
    }

    public CreateLdapConnectionPoolRule(CreateLdapConnectionPoolRule classCreateLdapConnectionPoolRule) {
        super(classCreateLdapConnectionPoolRule);
        this.classCreateLdapConnectionPoolRule = classCreateLdapConnectionPoolRule;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        return super.apply(this.buildStatement(base, description), description);
    }

    private Statement buildStatement(final Statement base, final Description description) {
        this.createLdapConnectionPool = (CreateLdapConnectionPool)description.getAnnotation(CreateLdapConnectionPool.class);
        if (this.createLdapConnectionPool == null) {
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    LdapServer ldapServer = CreateLdapConnectionPoolRule.this.getLdapServer();
                    if (CreateLdapConnectionPoolRule.this.classCreateLdapConnectionPoolRule != null && CreateLdapConnectionPoolRule.this.classCreateLdapConnectionPoolRule.getLdapServer() != ldapServer) {
                        LOG.trace("Creating connection pool to new ldap server");
                        LdapConnectionPool oldLdapConnectionPool = CreateLdapConnectionPoolRule.this.ldapConnectionPool;
                        LdapConnectionTemplate oldLdapConnectionTemplate = CreateLdapConnectionPoolRule.this.ldapConnectionTemplate;
                        CreateLdapConnectionPoolRule.this.ldapConnectionPool = CreateLdapConnectionPoolRule.this.classCreateLdapConnectionPoolRule.createLdapConnectionPool(ldapServer);
                        CreateLdapConnectionPoolRule.this.ldapConnectionTemplate = new LdapConnectionTemplate(CreateLdapConnectionPoolRule.this.ldapConnectionPool);
                        try {
                            base.evaluate();
                        }
                        finally {
                            LOG.trace("Reverting to old connection pool");
                            CreateLdapConnectionPoolRule.this.ldapConnectionPool = oldLdapConnectionPool;
                            CreateLdapConnectionPoolRule.this.ldapConnectionTemplate = oldLdapConnectionTemplate;
                        }
                    } else {
                        LOG.trace("no @CreateLdapConnectionPool on: {}", (Object)description);
                        base.evaluate();
                    }
                }
            };
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                LOG.trace("Creating ldap connection pool");
                CreateLdapConnectionPoolRule.this.ldapConnectionPool = CreateLdapConnectionPoolRule.this.createLdapConnectionPool(CreateLdapConnectionPoolRule.this.getLdapServer());
                CreateLdapConnectionPoolRule.this.ldapConnectionTemplate = new LdapConnectionTemplate(CreateLdapConnectionPoolRule.this.ldapConnectionPool);
                try {
                    base.evaluate();
                }
                finally {
                    LOG.trace("Closing ldap connection pool");
                    CreateLdapConnectionPoolRule.this.ldapConnectionPool.close();
                    CreateLdapConnectionPoolRule.this.ldapConnectionTemplate = null;
                }
            }
        };
    }

    private LdapConnectionPool createLdapConnectionPool(LdapServer ldapServer) {
        LdapConnectionConfig config = new LdapConnectionConfig();
        config.setLdapHost("localhost");
        config.setLdapPort(ldapServer.getPort());
        config.setName("uid=admin,ou=system");
        config.setCredentials("secret");
        if (this.createLdapConnectionPool.additionalBinaryAttributes() != null && this.createLdapConnectionPool.additionalBinaryAttributes().length > 0) {
            DefaultConfigurableBinaryAttributeDetector binaryAttributeDetector = new DefaultConfigurableBinaryAttributeDetector();
            binaryAttributeDetector.addBinaryAttribute(this.createLdapConnectionPool.additionalBinaryAttributes());
            config.setBinaryAttributeDetector(binaryAttributeDetector);
        }
        DefaultLdapConnectionFactory factory = new DefaultLdapConnectionFactory(config);
        factory.setTimeOut(this.createLdapConnectionPool.timeout());
        GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
        poolConfig.lifo = this.createLdapConnectionPool.lifo();
        poolConfig.maxActive = this.createLdapConnectionPool.maxActive();
        poolConfig.maxIdle = this.createLdapConnectionPool.maxIdle();
        poolConfig.maxWait = this.createLdapConnectionPool.maxWait();
        poolConfig.minEvictableIdleTimeMillis = this.createLdapConnectionPool.minEvictableIdleTimeMillis();
        poolConfig.minIdle = this.createLdapConnectionPool.minIdle();
        poolConfig.numTestsPerEvictionRun = this.createLdapConnectionPool.numTestsPerEvictionRun();
        poolConfig.softMinEvictableIdleTimeMillis = this.createLdapConnectionPool.softMinEvictableIdleTimeMillis();
        poolConfig.testOnBorrow = this.createLdapConnectionPool.testOnBorrow();
        poolConfig.testOnReturn = this.createLdapConnectionPool.testOnReturn();
        poolConfig.testWhileIdle = this.createLdapConnectionPool.testWhileIdle();
        poolConfig.timeBetweenEvictionRunsMillis = this.createLdapConnectionPool.timeBetweenEvictionRunsMillis();
        poolConfig.whenExhaustedAction = this.createLdapConnectionPool.whenExhaustedAction();
        return new LdapConnectionPool(new PoolableLdapConnectionFactory(factory), poolConfig);
    }

    public LdapConnectionPool getLdapConnectionPool() {
        return this.ldapConnectionPool == null ? (this.classCreateLdapConnectionPoolRule == null ? null : this.classCreateLdapConnectionPoolRule.getLdapConnectionPool()) : this.ldapConnectionPool;
    }

    public LdapConnectionTemplate getLdapConnectionTemplate() {
        return this.ldapConnectionTemplate == null ? (this.classCreateLdapConnectionPoolRule == null ? null : this.classCreateLdapConnectionPoolRule.getLdapConnectionTemplate()) : this.ldapConnectionTemplate;
    }
}

