/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.api.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.api.ldap.model.message.SearchResultDone;

public class SearchResultDoneDecorator
extends ResponseDecorator<SearchResultDone>
implements SearchResultDone {
    private int searchResultDoneLength;

    public SearchResultDoneDecorator(LdapApiService codec, SearchResultDone decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setSearchResultDoneLength(int searchResultDoneLength) {
        this.searchResultDoneLength = searchResultDoneLength;
    }

    public int getSearchResultDoneLength() {
        return this.searchResultDoneLength;
    }

    @Override
    public int computeLength() {
        int searchResultDoneLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        this.setSearchResultDoneLength(searchResultDoneLength);
        return 1 + TLV.getNbBytes(searchResultDoneLength) + searchResultDoneLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)101);
            buffer.put(TLV.getBytes(this.getSearchResultDoneLength()));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

