/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.comparator.CharComparator;
import org.apache.directory.mavibot.btree.exception.SerializerCreationException;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;

public class CharSerializer
extends AbstractElementSerializer<Character> {
    public CharSerializer() {
        super(new CharComparator());
    }

    @Override
    public byte[] serialize(Character element) {
        byte[] bytes = new byte[2];
        return CharSerializer.serialize(bytes, 0, element.charValue());
    }

    public static byte[] serialize(char value) {
        byte[] bytes = new byte[2];
        return CharSerializer.serialize(bytes, 0, value);
    }

    public static byte[] serialize(byte[] buffer, int start, char value) {
        buffer[start] = (byte)(value >>> 8);
        buffer[start + 1] = (byte)value;
        return buffer;
    }

    public static Character deserialize(byte[] in) {
        return CharSerializer.deserialize(in, 0);
    }

    public static Character deserialize(byte[] in, int start) {
        if (in == null || in.length < 2 + start) {
            throw new SerializerCreationException("Cannot extract a Character from a buffer with not enough bytes");
        }
        return Character.valueOf((char)((in[start] << 8) + (in[start + 1] & 0xFF)));
    }

    @Override
    public Character fromBytes(byte[] in) {
        return CharSerializer.deserialize(in, 0);
    }

    @Override
    public Character fromBytes(byte[] in, int start) {
        if (in == null || in.length < 2 + start) {
            throw new SerializerCreationException("Cannot extract a Character from a buffer with not enough bytes");
        }
        return Character.valueOf((char)((in[start] << 8) + (in[start + 1] & 0xFF)));
    }

    @Override
    public Character deserialize(ByteBuffer buffer) throws IOException {
        return Character.valueOf(buffer.getChar());
    }

    @Override
    public Character deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(2);
        return CharSerializer.deserialize(in);
    }
}

