/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BorrowedFromLeftResult;
import org.apache.directory.mavibot.btree.BorrowedFromRightResult;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.MergedWithSiblingResult;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.NotPresentResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.PersistedKeyHolder;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedValueHolder;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.RemoveResult;
import org.apache.directory.mavibot.btree.SplitResult;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.DuplicateValueNotAllowedException;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;

class PersistedLeaf<K, V>
extends AbstractPage<K, V> {
    protected ValueHolder<V>[] values;

    PersistedLeaf(BTree<K, V> btree) {
        super(btree);
    }

    PersistedLeaf(BTree<K, V> btree, long revision, int nbElems) {
        super(btree, revision, nbElems);
        this.values = (ValueHolder[])Array.newInstance(PersistedValueHolder.class, nbElems);
    }

    @Override
    public InsertResult<K, V> insert(long revision, K key, V value) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            int index = -(pos + 1);
            InsertResult<K, V> result = this.replaceElement(revision, key, value, index);
            return result;
        }
        if (this.nbElems < this.btree.getPageSize()) {
            Page<K, V> modifiedPage = this.addElement(revision, key, value, pos);
            ModifyResult<K, Object> result = new ModifyResult<K, Object>(modifiedPage, null);
            result.addCopiedPage(this);
            return result;
        }
        InsertResult<K, V> result = this.addAndSplit(revision, key, value, pos);
        result.addCopiedPage(this);
        return result;
    }

    @Override
    public DeleteResult<K, V> delete(long revision, K key, V value, Page<K, V> parent, int parentPos) throws IOException {
        if (this.nbElems == 0) {
            return NotPresentResult.NOT_PRESENT;
        }
        int pos = this.findPos(key);
        if (pos >= 0) {
            return NotPresentResult.NOT_PRESENT;
        }
        Tuple removedElement = null;
        boolean keyRemoved = false;
        int index = -(pos + 1);
        ValueHolder<V> valueHolder = this.values[index];
        if (value == null) {
            removedElement = new Tuple(this.keys[index].getKey(), value);
            keyRemoved = true;
        } else if (valueHolder.contains(value)) {
            keyRemoved = valueHolder.size() == 1;
            removedElement = new Tuple(this.keys[index].getKey(), value);
        } else {
            return NotPresentResult.NOT_PRESENT;
        }
        PersistedLeaf<K, V> newLeaf = null;
        newLeaf = keyRemoved ? new PersistedLeaf<K, V>(this.btree, revision, this.nbElems - 1) : new PersistedLeaf<K, V>(this.btree, revision, this.nbElems);
        RemoveResult<K, V> defaultResult = new RemoveResult<K, V>(newLeaf, removedElement);
        if (parent == null) {
            this.copyAfterRemovingElement(keyRemoved, value, newLeaf, index);
            defaultResult.addCopiedPage(this);
            return defaultResult;
        }
        if (keyRemoved) {
            int halfSize = this.btree.getPageSize() / 2;
            if (this.nbElems == halfSize) {
                int siblingPos = this.selectSibling(parent, parentPos);
                PersistedLeaf sibling = (PersistedLeaf)((PersistedNode)parent).getPage(siblingPos);
                if (sibling.getNbElems() == halfSize) {
                    DeleteResult result = this.mergeWithSibling(removedElement, revision, sibling, siblingPos < parentPos, index);
                    return result;
                }
                if (siblingPos < parentPos) {
                    DeleteResult result = this.borrowFromLeft(removedElement, revision, sibling, index);
                    return result;
                }
                DeleteResult result = this.borrowFromRight(removedElement, revision, sibling, index);
                return result;
            }
            this.copyAfterRemovingElement(true, value, newLeaf, index);
            defaultResult.addCopiedPage(this);
            return defaultResult;
        }
        System.arraycopy(this.keys, 0, newLeaf.keys, 0, this.nbElems);
        System.arraycopy(this.values, 0, newLeaf.values, 0, this.nbElems);
        try {
            ValueHolder<V> newValueHolder = valueHolder.clone();
            newValueHolder.remove(value);
            newLeaf.values[pos] = newValueHolder;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        defaultResult.addCopiedPage(this);
        return defaultResult;
    }

    private DeleteResult<K, V> mergeWithSibling(Tuple<K, V> removedElement, long revision, PersistedLeaf<K, V> sibling, boolean isLeft, int pos) throws EndOfFileExceededException, IOException {
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, this.btree.getPageSize() - 1);
        if (isLeft) {
            System.arraycopy(sibling.keys, 0, newLeaf.keys, 0, sibling.nbElems);
            System.arraycopy(sibling.values, 0, newLeaf.values, 0, sibling.nbElems);
            System.arraycopy(this.keys, 0, newLeaf.keys, sibling.nbElems, pos);
            System.arraycopy(this.values, 0, newLeaf.values, sibling.nbElems, pos);
            System.arraycopy(this.keys, pos + 1, newLeaf.keys, sibling.nbElems + pos, this.nbElems - pos - 1);
            System.arraycopy(this.values, pos + 1, newLeaf.values, sibling.nbElems + pos, this.nbElems - pos - 1);
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos, this.nbElems - pos - 1);
            System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.nbElems - pos - 1);
            System.arraycopy(sibling.keys, 0, newLeaf.keys, this.nbElems - 1, sibling.nbElems);
            System.arraycopy(sibling.values, 0, newLeaf.values, this.nbElems - 1, sibling.nbElems);
        }
        MergedWithSiblingResult<K, V> result = new MergedWithSiblingResult<K, V>(newLeaf, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromLeft(Tuple<K, V> removedElement, long revision, PersistedLeaf<K, V> sibling, int pos) throws IOException {
        Object siblingKey = sibling.keys[sibling.getNbElems() - 1].getKey();
        ValueHolder<V> siblingValue = sibling.values[sibling.getNbElems() - 1];
        PersistedLeaf newSibling = (PersistedLeaf)super.copy(revision, sibling.getNbElems() - 1);
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, this.nbElems);
        newLeaf.keys[0] = new PersistedKeyHolder(this.btree.getKeySerializer(), siblingKey);
        newLeaf.values[0] = siblingValue;
        System.arraycopy(this.keys, 0, newLeaf.keys, 1, pos);
        System.arraycopy(this.values, 0, newLeaf.values, 1, pos);
        System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos + 1, this.keys.length - pos - 1);
        System.arraycopy(this.values, pos + 1, newLeaf.values, pos + 1, this.values.length - pos - 1);
        BorrowedFromLeftResult<K, V> result = new BorrowedFromLeftResult<K, V>(newLeaf, newSibling, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromRight(Tuple<K, V> removedElement, long revision, PersistedLeaf<K, V> sibling, int pos) throws IOException {
        Object siblingKey = sibling.keys[0].getKey();
        ValueHolder<V> siblingHolder = sibling.values[0];
        PersistedLeaf<K, V> newSibling = new PersistedLeaf<K, V>(this.btree, revision, sibling.getNbElems() - 1);
        System.arraycopy(sibling.keys, 1, newSibling.keys, 0, sibling.nbElems - 1);
        System.arraycopy(sibling.values, 1, newSibling.values, 0, sibling.nbElems - 1);
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, this.nbElems);
        newLeaf.keys[this.nbElems - 1] = new PersistedKeyHolder(this.btree.getKeySerializer(), siblingKey);
        newLeaf.values[this.nbElems - 1] = siblingHolder;
        System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
        System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
        System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos, this.keys.length - pos - 1);
        System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.values.length - pos - 1);
        BorrowedFromRightResult<K, V> result = new BorrowedFromRightResult<K, V>(newLeaf, newSibling, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private void copyAfterRemovingElement(boolean keyRemoved, V removedValue, PersistedLeaf<K, V> newLeaf, int pos) throws IOException {
        if (keyRemoved) {
            if (this.nbElems == 1) {
                return;
            }
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos, this.keys.length - pos - 1);
            System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.values.length - pos - 1);
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, this.nbElems);
            System.arraycopy(this.values, 0, newLeaf.values, 0, this.nbElems);
            ValueHolder<V> valueHolder = newLeaf.values[pos];
            try {
                ValueHolder<V> newValueHolder = valueHolder.clone();
                newValueHolder.remove(removedValue);
                newLeaf.values[pos] = newValueHolder;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public V get(K key) throws KeyNotFoundException, IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            ValueHolder<V> valueHolder = this.values[-(pos + 1)];
            ValueCursor<V> cursor = valueHolder.getCursor();
            cursor.beforeFirst();
            if (cursor.hasNext()) {
                V value = cursor.next();
                return value;
            }
            return null;
        }
        throw this.KEY_NOT_FOUND_EXCEPTION;
    }

    KeyHolder<K> getKeyHolder(int pos) {
        if (pos < this.nbElems) {
            return this.keys[pos];
        }
        return null;
    }

    @Override
    public ValueCursor<V> getValues(K key) throws KeyNotFoundException, IOException, IllegalArgumentException {
        if (!this.btree.isAllowDuplicates()) {
            throw new IllegalArgumentException("Duplicates are not allowed in this tree");
        }
        int pos = this.findPos(key);
        if (pos < 0) {
            ValueHolder<V> valueHolder = this.values[-(pos + 1)];
            return valueHolder.getCursor();
        }
        throw this.KEY_NOT_FOUND_EXCEPTION;
    }

    @Override
    public boolean hasKey(K key) {
        int pos = this.findPos(key);
        return pos < 0;
    }

    @Override
    public boolean contains(K key, V value) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            ValueHolder<V> valueHolder = this.values[-(pos + 1)];
            return valueHolder.contains(value);
        }
        return false;
    }

    @Override
    ValueHolder<V> getValue(int pos) {
        if (pos < this.nbElems) {
            return this.values[pos];
        }
        return null;
    }

    void setValue(int pos, ValueHolder<V> value) {
        this.values[pos] = value;
    }

    @Override
    public TupleCursor<K, V> browse(K key, ReadTransaction<K, V> transaction, ParentPos<K, V>[] stack, int depth) {
        int pos = this.findPos(key);
        TupleCursor<K, V> cursor = null;
        if (pos < 0) {
            pos = -(pos + 1);
            ParentPos parentPos = new ParentPos(this, pos);
            parentPos.valueCursor = this.values[pos].getCursor();
            stack[depth] = parentPos;
            cursor = new TupleCursor<K, V>(transaction, stack, depth);
        } else if (pos < this.nbElems) {
            ParentPos parentPos = new ParentPos(this, pos);
            parentPos.valueCursor = this.values[pos].getCursor();
            stack[depth] = parentPos;
            cursor = new TupleCursor<K, V>(transaction, stack, depth);
        } else if (this.nbElems > 0) {
            ParentPos parentPos = new ParentPos(this, this.nbElems - 1);
            parentPos.valueCursor = this.values[this.nbElems - 1].getCursor();
            stack[depth] = parentPos;
            cursor = new TupleCursor<K, V>(transaction, stack, depth);
            try {
                cursor.afterLast();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            stack[depth] = null;
            cursor = new TupleCursor<K, V>(transaction, null, 0);
        }
        return cursor;
    }

    @Override
    public TupleCursor<K, V> browse(ReadTransaction<K, V> transaction, ParentPos<K, V>[] stack, int depth) {
        int pos = 0;
        TupleCursor<K, V> cursor = null;
        if (this.nbElems == 0) {
            stack[depth] = new ParentPos(null, -1);
            return new TupleCursor<K, V>(transaction, stack, depth);
        }
        ParentPos parentPos = new ParentPos(this, pos);
        parentPos.valueCursor = this.values[0].getCursor();
        stack[depth] = parentPos;
        cursor = new TupleCursor<K, V>(transaction, stack, depth);
        return cursor;
    }

    private Page<K, V> copy(long revision, int nbElems) {
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, nbElems);
        System.arraycopy(this.keys, 0, newLeaf.keys, 0, nbElems);
        int pos = 0;
        for (ValueHolder<V> valueHolder : this.values) {
            try {
                newLeaf.values[pos++] = valueHolder.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            if (pos == nbElems) break;
        }
        return newLeaf;
    }

    private InsertResult<K, V> replaceElement(long revision, K key, V value, int pos) throws IOException {
        PersistedLeaf newLeaf = this;
        ValueHolder<V> valueHolder = this.values[pos];
        boolean valueExists = valueHolder.contains(value);
        if (!valueExists && !this.btree.isAllowDuplicates()) {
            throw new DuplicateValueNotAllowedException("Duplicate values are not allowed");
        }
        if (this.revision != revision) {
            newLeaf = (PersistedLeaf)this.copy(revision, this.nbElems);
        }
        valueHolder = newLeaf.values[pos];
        Object replacedValue = null;
        if (!valueExists) {
            valueHolder.add(value);
            newLeaf.values[pos] = valueHolder;
        } else {
            replacedValue = valueHolder.remove(value);
            valueHolder.add(value);
        }
        ModifyResult result = new ModifyResult(newLeaf, replacedValue);
        result.addCopiedPage(this);
        return result;
    }

    private Page<K, V> addElement(long revision, K key, V value, int pos) {
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, this.nbElems + 1);
        PersistedValueHolder<Object> valueHolder = new PersistedValueHolder<Object>(this.btree, value);
        if (this.nbElems == 0) {
            newLeaf.keys[0] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            newLeaf.values[0] = valueHolder;
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            newLeaf.keys[pos] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            newLeaf.values[pos] = valueHolder;
            System.arraycopy(this.keys, pos, newLeaf.keys, pos + 1, this.keys.length - pos);
            System.arraycopy(this.values, pos, newLeaf.values, pos + 1, this.values.length - pos);
        }
        return newLeaf;
    }

    private InsertResult<K, V> addAndSplit(long revision, K key, V value, int pos) {
        int middle = this.btree.getPageSize() >> 1;
        PersistedLeaf<K, V> leftLeaf = null;
        PersistedLeaf<K, V> rightLeaf = null;
        PersistedValueHolder<Object> valueHolder = new PersistedValueHolder<Object>(this.btree, value);
        if (pos <= middle) {
            leftLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle + 1);
            System.arraycopy(this.keys, 0, leftLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, leftLeaf.values, 0, pos);
            leftLeaf.keys[pos] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            leftLeaf.values[pos] = valueHolder;
            System.arraycopy(this.keys, pos, leftLeaf.keys, pos + 1, middle - pos);
            System.arraycopy(this.values, pos, leftLeaf.values, pos + 1, middle - pos);
            rightLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.keys, middle, rightLeaf.keys, 0, middle);
            System.arraycopy(this.values, middle, rightLeaf.values, 0, middle);
        } else {
            leftLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.keys, 0, leftLeaf.keys, 0, middle);
            System.arraycopy(this.values, 0, leftLeaf.values, 0, middle);
            rightLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle + 1);
            int rightPos = pos - middle;
            System.arraycopy(this.keys, middle, rightLeaf.keys, 0, rightPos);
            System.arraycopy(this.values, middle, rightLeaf.values, 0, rightPos);
            rightLeaf.keys[rightPos] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            rightLeaf.values[rightPos] = valueHolder;
            System.arraycopy(this.keys, pos, rightLeaf.keys, rightPos + 1, this.nbElems - pos);
            System.arraycopy(this.values, pos, rightLeaf.values, rightPos + 1, this.nbElems - pos);
        }
        Object pivot = rightLeaf.keys[0].getKey();
        if (pivot == null) {
            pivot = rightLeaf.keys[0].getKey();
        }
        SplitResult result = new SplitResult(pivot, leftLeaf, rightLeaf);
        return result;
    }

    @Override
    public K getLeftMostKey() {
        return this.keys[0].getKey();
    }

    @Override
    public K getRightMostKey() {
        return this.keys[this.nbElems - 1].getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tuple<K, V> findLeftMost() throws IOException {
        ValueCursor<V> cursor = this.values[0].getCursor();
        try {
            cursor.beforeFirst();
            if (cursor.hasNext()) {
                Tuple tuple = new Tuple(this.keys[0].getKey(), cursor.next());
                return tuple;
            }
            Tuple tuple = new Tuple(this.keys[0].getKey(), null);
            return tuple;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tuple<K, V> findRightMost() throws EndOfFileExceededException, IOException {
        ValueCursor<V> cursor = this.values[this.nbElems - 1].getCursor();
        try {
            cursor.afterLast();
            if (cursor.hasPrev()) {
                Tuple tuple = new Tuple(this.keys[this.nbElems - 1].getKey(), cursor.prev());
                return tuple;
            }
            Tuple tuple = new Tuple(this.keys[this.nbElems - 1].getKey(), null);
            return tuple;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Leaf[");
        sb.append(super.toString());
        sb.append("] -> {");
        if (this.nbElems > 0) {
            boolean isFirst = true;
            for (int i = 0; i < this.nbElems; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<").append(this.keys[i]).append(",").append(this.values[i]).append(">");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String dumpPage(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs);
        if (this.nbElems > 0) {
            boolean isFirst = true;
            for (int i = 0; i < this.nbElems; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<").append(this.keys[i]).append(",").append(this.values[i]).append(">");
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

