/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.directory.mavibot.btree.AbstractBTree;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeHeader;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.NotPresentResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PersistedBTreeConfiguration;
import org.apache.directory.mavibot.btree.PersistedLeaf;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedPageHolder;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.RemoveResult;
import org.apache.directory.mavibot.btree.SplitResult;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.WriteTransaction;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedBTree<K, V>
extends AbstractBTree<K, V>
implements Closeable {
    protected static final Logger LOG = LoggerFactory.getLogger(PersistedBTree.class);
    private RecordManager recordManager;
    protected Cache cache;
    static final int DEFAULT_CACHE_SIZE = 1000;
    protected int cacheSize = 1000;
    private boolean isSubBtree = false;
    private static final int DEFAULT_VALUE_THRESHOLD_UP = 8;
    private static final int DEFAULT_VALUE_THRESHOLD_LOW = 1;
    static int valueThresholdUp = 8;
    static int valueThresholdLow = 1;
    protected ReentrantLock createTransaction = new ReentrantLock();

    PersistedBTree() {
        this.btreeHeader = new BTreeHeader();
        this.setType(BTreeTypeEnum.PERSISTED);
    }

    PersistedBTree(PersistedBTreeConfiguration<K, V> configuration) {
        String name = configuration.getName();
        if (name == null) {
            throw new IllegalArgumentException("BTree name cannot be null");
        }
        this.btreeHeader = new BTreeHeader();
        this.btreeHeader.setName(name);
        this.btreeHeader.setPageSize(configuration.getPageSize());
        this.isSubBtree = configuration.isSubBtree();
        this.keySerializer = configuration.getKeySerializer();
        this.btreeHeader.setKeySerializerFQCN(this.keySerializer.getClass().getName());
        this.valueSerializer = configuration.getValueSerializer();
        this.btreeHeader.setValueSerializerFQCN(this.valueSerializer.getClass().getName());
        this.readTimeOut = configuration.getReadTimeOut();
        this.writeBufferSize = configuration.getWriteBufferSize();
        this.btreeHeader.setAllowDuplicates(configuration.isAllowDuplicates());
        this.cacheSize = configuration.getCacheSize();
        this.setType(BTreeTypeEnum.PERSISTED);
        if (this.keySerializer.getComparator() == null) {
            throw new IllegalArgumentException("Comparator should not be null");
        }
        this.rootPage = new PersistedLeaf(this);
        if (this.isSubBtree) {
            this.cache = ((PersistedBTree)configuration.getParentBTree()).getCache();
            this.writeLock = ((PersistedBTree)configuration.getParentBTree()).getWriteLock();
            this.readTransactions = new ConcurrentLinkedQueue();
        }
        this.init();
    }

    @Override
    public void init() {
        if (!this.isSubBtree) {
            this.readTransactions = new ConcurrentLinkedQueue();
            this.writeLock = new ReentrantLock();
            CacheConfiguration cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setName("pages");
            cacheConfiguration.setEternal(true);
            cacheConfiguration.setOverflowToDisk(false);
            cacheConfiguration.setCacheLoaderTimeoutMillis(0L);
            cacheConfiguration.setMaxElementsInMemory(this.cacheSize);
            cacheConfiguration.setMemoryStoreEvictionPolicy("LRU");
            this.cache = new Cache(cacheConfiguration);
            this.cache.initialise();
        }
    }

    Cache getCache() {
        return this.cache;
    }

    ReentrantLock getWriteLock() {
        return this.writeLock;
    }

    ConcurrentLinkedQueue<ReadTransaction<K, V>> getReadTransactions() {
        return this.readTransactions;
    }

    @Override
    public void close() throws IOException {
        if (this.cache.getStatus() == Status.STATUS_ALIVE) {
            this.cache.removeAll();
        }
        this.cache.dispose();
        this.rootPage = null;
    }

    long getBtreeOffset() {
        return this.btreeHeader.getBTreeOffset();
    }

    void setBtreeOffset(long btreeOffset) {
        this.btreeHeader.setBTreeOffset(btreeOffset);
    }

    long getRootPageOffset() {
        return this.btreeHeader.getRootPageOffset();
    }

    void setRootPageOffset(long rootPageOffset) {
        this.btreeHeader.setRootPageOffset(rootPageOffset);
    }

    long getNextBTreeOffset() {
        return this.btreeHeader.getNextBTreeOffset();
    }

    void setNextBTreeOffset(long nextBTreeOffset) {
        this.btreeHeader.setNextBTreeOffset(nextBTreeOffset);
    }

    RecordManager getRecordManager() {
        return this.recordManager;
    }

    void setRecordManager(RecordManager recordManager) {
        this.recordManager = recordManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Tuple<K, V> delete(K key, V value, long revision) throws IOException {
        this.writeLock.lock();
        try {
            Tuple tuple = null;
            DeleteResult<K, V> result = this.rootPage.delete(revision, key, value, null, -1);
            if (result instanceof NotPresentResult) {
                Tuple<K, V> tuple2 = null;
                return tuple2;
            }
            Page oldRootPage = this.rootPage;
            if (result instanceof RemoveResult) {
                RemoveResult removeResult = (RemoveResult)result;
                Page modifiedPage = removeResult.getModifiedPage();
                PageHolder holder = this.writePage(modifiedPage, revision);
                ((AbstractPage)modifiedPage).setOffset(((PersistedPageHolder)holder).getOffset());
                ((AbstractPage)modifiedPage).setLastOffset(((PersistedPageHolder)holder).getLastOffset());
                this.rootPage = modifiedPage;
                tuple = removeResult.getRemovedElement();
            }
            if (tuple != null) {
                this.btreeHeader.decrementNbElems();
                this.recordManager.updateBtreeHeader(this, ((AbstractPage)this.rootPage).getOffset());
            }
            this.recordManager.addFreePages(this, result.getCopiedPages());
            this.recordManager.updateRecordManagerHeader();
            this.recordManager.storeRootPage(this, this.rootPage);
            Tuple tuple3 = tuple;
            return tuple3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    InsertResult<K, V> insert(K key, V value, long revision) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        Object modifiedValue = null;
        InsertResult<K, V> result = this.rootPage.insert(revision, key, value);
        if (result instanceof ModifyResult) {
            ModifyResult modifyResult = (ModifyResult)result;
            Page modifiedPage = modifyResult.getModifiedPage();
            this.writePage(modifiedPage, revision);
            this.rootPage = modifiedPage;
            modifiedValue = modifyResult.getModifiedValue();
        } else {
            SplitResult splitResult = (SplitResult)result;
            Object pivot = splitResult.getPivot();
            Page leftPage = splitResult.getLeftPage();
            Page rightPage = splitResult.getRightPage();
            PersistedNode newRootPage = null;
            PageHolder holderLeft = this.writePage(leftPage, revision);
            PageHolder holderRight = this.writePage(rightPage, revision);
            newRootPage = new PersistedNode(this, revision, pivot, holderLeft, holderRight);
            PageHolder holder = this.writePage(newRootPage, revision);
            this.rootPage = newRootPage;
        }
        if (modifiedValue == null) {
            this.btreeHeader.incrementNbElems();
        }
        if (this.writeTransaction == null || !this.writeTransaction.isStarted()) {
            this.recordManager.updateRecordManagerHeader();
            this.recordManager.updateBtreeHeader(this, ((AbstractPage)this.rootPage).getOffset());
            this.recordManager.addFreePages(this, result.getCopiedPages());
            this.recordManager.storeRootPage(this, this.rootPage);
        }
        return result;
    }

    private void writeBuffer(FileChannel channel, ByteBuffer bb, byte[] buffer) throws IOException {
        int size = buffer.length;
        int pos = 0;
        do {
            if (bb.remaining() >= size) {
                bb.put(buffer, pos, size);
                size = 0;
                continue;
            }
            int len = bb.remaining();
            size -= len;
            bb.put(buffer, pos, len);
            pos += len;
            bb.flip();
            channel.write(bb);
            bb.clear();
        } while (size > 0);
    }

    private PageHolder<K, V> writePage(Page<K, V> modifiedPage, long revision) throws IOException {
        if (this.writeTransaction != null && this.writeTransaction.isStarted()) {
            Map<Page<?, ?>, BTree<?, ?>> pendingPages = this.recordManager.getPendingPages();
            pendingPages.put(modifiedPage, this);
            PageHolder<K, V> pageHolder = new PageHolder<K, V>(this, modifiedPage);
            return pageHolder;
        }
        PageHolder<K, V> pageHolder = this.recordManager.writePage(this, modifiedPage, revision);
        return pageHolder;
    }

    @Override
    public Page<K, V> getRootPage(long revision) throws IOException, KeyNotFoundException {
        return this.recordManager.getRootPage(this, revision);
    }

    @Override
    public void beginTransaction() {
        this.createTransaction.lock();
        if (this.writeTransaction == null) {
            this.writeTransaction = new WriteTransaction(this.recordManager);
        }
        this.createTransaction.unlock();
        this.writeTransaction.start();
    }

    @Override
    public void commit() {
        this.createTransaction.lock();
        if (this.writeTransaction == null) {
            this.writeTransaction = new WriteTransaction(this.recordManager);
        }
        this.createTransaction.unlock();
        this.writeTransaction.commit();
    }

    @Override
    public void rollback() {
        this.createTransaction.lock();
        if (this.writeTransaction == null) {
            this.writeTransaction = new WriteTransaction(this.recordManager);
        }
        this.createTransaction.unlock();
        this.writeTransaction.rollback();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Managed BTree");
        sb.append("[").append(this.btreeHeader.getName()).append("]");
        sb.append("( pageSize:").append(this.btreeHeader.getPageSize());
        if (this.rootPage != null) {
            sb.append(", nbEntries:").append(this.btreeHeader.getNbElems());
        } else {
            sb.append(", nbEntries:").append(0);
        }
        sb.append(", comparator:");
        if (this.keySerializer.getComparator() == null) {
            sb.append("null");
        } else {
            sb.append(this.keySerializer.getComparator().getClass().getSimpleName());
        }
        sb.append(", DuplicatesAllowed: ").append(this.btreeHeader.isAllowDuplicates());
        sb.append(") : \n");
        sb.append(this.rootPage.dumpPage(""));
        return sb.toString();
    }
}

