/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AbandonRequest;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public interface LdapConnection
extends Closeable {
    public boolean isConnected();

    public boolean isAuthenticated();

    public boolean connect() throws LdapException;

    @Override
    public void close() throws IOException;

    public void add(Entry var1) throws LdapException;

    public AddResponse add(AddRequest var1) throws LdapException;

    public void abandon(int var1);

    public void abandon(AbandonRequest var1);

    public void bind() throws LdapException;

    public void anonymousBind() throws LdapException;

    public void bind(String var1) throws LdapException;

    public void bind(String var1, String var2) throws LdapException;

    public void bind(Dn var1) throws LdapException;

    public void bind(Dn var1, String var2) throws LdapException;

    public BindResponse bind(BindRequest var1) throws LdapException;

    public EntryCursor search(Dn var1, String var2, SearchScope var3, String ... var4) throws LdapException;

    public EntryCursor search(String var1, String var2, SearchScope var3, String ... var4) throws LdapException;

    public SearchCursor search(SearchRequest var1) throws LdapException;

    public void unBind() throws LdapException;

    public void setTimeOut(long var1);

    public void modify(Dn var1, Modification ... var2) throws LdapException;

    public void modify(String var1, Modification ... var2) throws LdapException;

    public void modify(Entry var1, ModificationOperation var2) throws LdapException;

    public ModifyResponse modify(ModifyRequest var1) throws LdapException;

    public void rename(String var1, String var2) throws LdapException;

    public void rename(Dn var1, Rdn var2) throws LdapException;

    public void rename(String var1, String var2, boolean var3) throws LdapException;

    public void rename(Dn var1, Rdn var2, boolean var3) throws LdapException;

    public void move(String var1, String var2) throws LdapException;

    public void move(Dn var1, Dn var2) throws LdapException;

    public void moveAndRename(Dn var1, Dn var2) throws LdapException;

    public void moveAndRename(String var1, String var2) throws LdapException;

    public void moveAndRename(Dn var1, Dn var2, boolean var3) throws LdapException;

    public void moveAndRename(String var1, String var2, boolean var3) throws LdapException;

    public ModifyDnResponse modifyDn(ModifyDnRequest var1) throws LdapException;

    public void delete(String var1) throws LdapException;

    public void delete(Dn var1) throws LdapException;

    public DeleteResponse delete(DeleteRequest var1) throws LdapException;

    public boolean compare(String var1, String var2, String var3) throws LdapException;

    public boolean compare(String var1, String var2, byte[] var3) throws LdapException;

    public boolean compare(String var1, String var2, Value<?> var3) throws LdapException;

    public boolean compare(Dn var1, String var2, String var3) throws LdapException;

    public boolean compare(Dn var1, String var2, byte[] var3) throws LdapException;

    public boolean compare(Dn var1, String var2, Value<?> var3) throws LdapException;

    public CompareResponse compare(CompareRequest var1) throws LdapException;

    public ExtendedResponse extended(String var1) throws LdapException;

    public ExtendedResponse extended(String var1, byte[] var2) throws LdapException;

    public ExtendedResponse extended(Oid var1) throws LdapException;

    public ExtendedResponse extended(Oid var1, byte[] var2) throws LdapException;

    public ExtendedResponse extended(ExtendedRequest<?> var1) throws LdapException;

    public boolean exists(String var1) throws LdapException;

    public boolean exists(Dn var1) throws LdapException;

    public Entry getRootDse() throws LdapException;

    public Entry getRootDse(String ... var1) throws LdapException;

    public Entry lookup(Dn var1) throws LdapException;

    public Entry lookup(String var1) throws LdapException;

    public Entry lookup(Dn var1, String ... var2) throws LdapException;

    public Entry lookup(Dn var1, Control[] var2, String ... var3) throws LdapException;

    public Entry lookup(String var1, String ... var2) throws LdapException;

    public Entry lookup(String var1, Control[] var2, String ... var3) throws LdapException;

    public boolean isControlSupported(String var1) throws LdapException;

    public List<String> getSupportedControls() throws LdapException;

    public void loadSchema() throws LdapException;

    public SchemaManager getSchemaManager();

    public LdapApiService getCodecService();

    public boolean doesFutureExistFor(int var1);

    public BinaryAttributeDetector getBinaryAttributeDetector();

    public void setBinaryAttributeDetector(BinaryAttributeDetector var1);

    public void setSchemaManager(SchemaManager var1);
}

