/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras;

import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.SyncDoneValue;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueDecorator;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncInfoValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory;
import org.apache.directory.api.ldap.extras.extended.CancelRequest;
import org.apache.directory.api.ldap.extras.extended.CancelResponse;
import org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ExtrasBundleActivator
implements BundleActivator {
    private ServiceReference<?> codecServiceRef;

    public void start(BundleContext context) throws Exception {
        this.codecServiceRef = context.getServiceReference(LdapApiService.class.getName());
        LdapApiService codec = (LdapApiService)context.getService(this.codecServiceRef);
        this.registerExtrasControls(codec);
        this.registerExtrasExtendedOps(codec);
    }

    private void registerExtrasControls(LdapApiService codec) {
        ControlFactory<SyncDoneValue, SyncDoneValueDecorator> factory = new SyncDoneValueFactory(codec);
        codec.registerControl(factory);
        factory = new SyncInfoValueFactory(codec);
        codec.registerControl(factory);
        factory = new SyncRequestValueFactory(codec);
        codec.registerControl(factory);
        factory = new SyncStateValueFactory(codec);
        codec.registerControl(factory);
        factory = new PasswordPolicyFactory(codec);
        codec.registerControl(factory);
    }

    private void registerExtrasExtendedOps(LdapApiService codec) {
        ExtendedOperationFactory<CancelRequest, CancelResponse> extReqfactory = new CancelFactory(codec);
        codec.registerExtendedRequest(extReqfactory);
        extReqfactory = new CertGenerationFactory(codec);
        codec.registerExtendedRequest(extReqfactory);
        extReqfactory = new GracefulShutdownFactory(codec);
        codec.registerExtendedRequest(extReqfactory);
        extReqfactory = new StoredProcedureFactory(codec);
        codec.registerExtendedRequest(extReqfactory);
        extReqfactory = new PasswordModifyFactory(codec);
        codec.registerExtendedRequest(extReqfactory);
        extReqfactory = new GracefulDisconnectFactory(codec);
        codec.registerExtendedRequest(extReqfactory);
    }

    public void stop(BundleContext context) throws Exception {
        LdapApiService codec = (LdapApiService)context.getService(this.codecServiceRef);
        codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.3");
        codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.4");
        codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.1");
        codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.2");
        codec.unregisterControl("1.3.6.1.4.1.42.2.27.8.5.1");
        codec.unregisterExtendedRequest("1.3.6.1.1.8");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.8");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.3");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.6");
        codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.5");
    }
}

