/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schemaextractor.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceMap {
    private static final String SCHEMA_RESOURCE_LOCATION = "schema.resource.location";
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMap.class);

    private ResourceMap() {
    }

    public static Map<String, Boolean> getResources(Pattern pattern) {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        String schemaResourceLoc = System.getProperty(SCHEMA_RESOURCE_LOCATION, "");
        if (schemaResourceLoc.trim().length() > 0) {
            LOG.debug("loading from the user provider schema resource {}", (Object)schemaResourceLoc);
            File file = new File(schemaResourceLoc);
            if (file.exists()) {
                ResourceMap.getResources(retval, schemaResourceLoc, pattern);
            } else {
                LOG.error("unable to load schema from the given resource value {}", (Object)schemaResourceLoc);
            }
        } else {
            ResourceMap.getResourcesFromClassloader(retval, pattern);
        }
        return retval;
    }

    private static void getResources(HashMap<String, Boolean> map, String element, Pattern pattern) {
        File file = new File(element);
        if (!file.exists()) {
            LOG.debug("element {} does not exist", (Object)element);
            return;
        }
        if (file.isDirectory()) {
            ResourceMap.getResourcesFromDirectory(map, file, pattern);
        } else {
            ResourceMap.getResourcesFromJarFile(map, file, pattern);
        }
    }

    private static void getResourcesFromJarFile(HashMap<String, Boolean> map, File file, Pattern pattern) {
        ZipFile zf;
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            map.put(fileName, Boolean.TRUE);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
    }

    private static void getResourcesFromDirectory(HashMap<String, Boolean> map, File directory, Pattern pattern) {
        File[] fileList;
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                ResourceMap.getResourcesFromDirectory(map, file, pattern);
                continue;
            }
            try {
                String fileName = file.getCanonicalPath();
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                map.put(fileName, Boolean.FALSE);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }

    private static void getResourcesFromClassloader(HashMap<String, Boolean> map, Pattern pattern) {
        try {
            ClassLoader cl = ResourceMap.class.getClassLoader();
            Enumeration<URL> indexes = cl.getResources("META-INF/apacheds-schema.index");
            while (indexes.hasMoreElements()) {
                URL index = indexes.nextElement();
                InputStream in = index.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String line = reader.readLine();
                while (line != null) {
                    boolean accept = pattern.matcher(line).matches();
                    if (accept) {
                        map.put(line, Boolean.TRUE);
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

