/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.util.List;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndNode
extends BranchNode {
    public AndNode(List<ExprNode> childList) {
        super(AssertionType.AND, childList);
    }

    public AndNode(ExprNode ... childList) {
        super(AssertionType.AND, childList);
    }

    public AndNode() {
        super(AssertionType.AND);
    }

    public AssertionType getOperator() {
        return AssertionType.AND;
    }

    public boolean isDisjunction() {
        return false;
    }

    public boolean isConjunction() {
        return true;
    }

    public boolean isNegation() {
        return false;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        buf.append("and: {");
        boolean isFirst = true;
        for (ExprNode node : this.children) {
            if (isFirst) {
                isFirst = false;
                buf.append(' ');
            } else {
                buf.append(", ");
            }
            node.printRefinementToBuffer(buf);
        }
        buf.append(" }");
        return buf;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(&");
        buf.append(super.toString());
        for (ExprNode child : this.getChildren()) {
            buf.append(child);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + AssertionType.AND.hashCode();
        hash = hash * 17 + (this.annotations == null ? 0 : ((Object)this.annotations).hashCode());
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AndNode)) {
            return false;
        }
        AndNode otherExprNode = (AndNode)other;
        List<ExprNode> otherChildren = otherExprNode.getChildren();
        if (otherChildren == this.children) {
            return true;
        }
        if (this.children.size() != otherChildren.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ExprNode otherChild;
            ExprNode child = (ExprNode)this.children.get(i);
            if (child.equals(otherChild = otherChildren.get(i))) continue;
            return false;
        }
        return true;
    }
}

