/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDecoder {
    private static Logger LOG = LoggerFactory.getLogger(LdapDecoder.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Asn1Decoder asn1Decoder = new Asn1Decoder();
    public static final String MESSAGE_CONTAINER_ATTR = "LDAP-container";
    public static final String MAX_PDU_SIZE_ATTR = "LDAP-maxPduSize";

    public Message decode(InputStream in, LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        try {
            byte[] buf;
            int amount;
            while (in.available() > 0 && (amount = in.read(buf = new byte[in.available()])) != -1) {
                this.asn1Decoder.decode(ByteBuffer.wrap(buf, 0, amount), container);
            }
        }
        catch (Exception e) {
            String message = I18n.err(I18n.ERR_04060, e.getLocalizedMessage());
            LOG.error(message);
            throw new DecoderException(message, e);
        }
        if (container.getState() == TLVStateEnum.PDU_DECODED) {
            if (IS_DEBUG) {
                LOG.debug("Decoded LdapMessage : " + container);
            }
            return container.getMessage();
        }
        LOG.error(I18n.err(I18n.ERR_04062, new Object[0]));
        throw new DecoderException(I18n.err(I18n.ERR_04063, new Object[0]));
    }
}

