/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import org.apache.directory.shared.ldap.util.StringTools;

public class Base32 {
    private static byte[] CHARS = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};

    public static String encode(String str) {
        if (StringTools.isEmpty(str)) {
            return "";
        }
        byte[] data = StringTools.getBytesUtf8(str);
        int dataLength = data.length;
        int newLength = (dataLength << 3) / 5 + (dataLength % 5 == 0 ? 0 : 1);
        byte[] out = new byte[newLength += newLength % 8 == 0 ? 0 : 8 - newLength % 8];
        int roundLength = dataLength / 5 * 5;
        int posOut = 0;
        int posIn = 0;
        if (roundLength != 0) {
            for (posIn = 0; posIn < roundLength; posIn += 5) {
                byte b0 = data[posIn];
                byte b1 = data[posIn + 1];
                byte b2 = data[posIn + 2];
                byte b3 = data[posIn + 3];
                byte b4 = data[posIn + 4];
                out[posOut++] = CHARS[(b0 & 0xF8) >> 3];
                out[posOut++] = CHARS[(b0 & 7) << 2 | (b1 & 0xC0) >> 6];
                out[posOut++] = CHARS[(b1 & 0x3E) >> 1];
                out[posOut++] = CHARS[(b1 & 1) << 4 | (b2 & 0xF0) >> 4];
                out[posOut++] = CHARS[(b2 & 0xF) << 1 | (b3 & 0x80) >> 7];
                out[posOut++] = CHARS[(b3 & 0x7C) >> 2];
                out[posOut++] = CHARS[(b3 & 3) << 3 | (b4 & 0x70) >> 5];
                out[posOut++] = CHARS[b4 & 0x1F];
            }
        }
        int remaining = dataLength - roundLength;
        switch (remaining) {
            case 1: {
                byte b0 = data[posIn++];
                out[posOut++] = CHARS[(b0 & 0xF8) >> 3];
                out[posOut++] = CHARS[(b0 & 7) << 2];
                out[posOut++] = 61;
                out[posOut++] = 61;
                out[posOut++] = 61;
                out[posOut++] = 61;
                out[posOut++] = 61;
                out[posOut++] = 61;
                break;
            }
            case 2: {
                byte b0 = data[posIn++];
                byte b1 = data[posIn++];
                out[posOut++] = CHARS[(b0 & 0xF8) >> 3];
                out[posOut++] = CHARS[(b0 & 7) << 2 | (b1 & 0xC0) >> 6];
                out[posOut++] = CHARS[(b1 & 0x3E) >> 1];
                out[posOut++] = CHARS[(b1 & 1) << 4];
                out[posOut++] = 61;
                out[posOut++] = 61;
                out[posOut++] = 61;
                out[posOut++] = 61;
                break;
            }
            case 3: {
                byte b0 = data[posIn++];
                byte b1 = data[posIn++];
                byte b2 = data[posIn++];
                out[posOut++] = CHARS[(b0 & 0xF8) >> 3];
                out[posOut++] = CHARS[(b0 & 7) << 2 | (b1 & 0xC0) >> 6];
                out[posOut++] = CHARS[(b1 & 0x3E) >> 1];
                out[posOut++] = CHARS[(b1 & 1) << 4 | (b2 & 0xF0) >> 4];
                out[posOut++] = CHARS[(b2 & 0xF) << 1];
                out[posOut++] = 61;
                out[posOut++] = 61;
                out[posOut++] = 61;
                break;
            }
            case 4: {
                byte b0 = data[posIn++];
                byte b1 = data[posIn++];
                byte b2 = data[posIn++];
                byte b3 = data[posIn++];
                out[posOut++] = CHARS[(b0 & 0xF8) >> 3];
                out[posOut++] = CHARS[(b0 & 7) << 2 | (b1 & 0xC0) >> 6];
                out[posOut++] = CHARS[(b1 & 0x3E) >> 1];
                out[posOut++] = CHARS[(b1 & 1) << 4 | (b2 & 0xF0) >> 4];
                out[posOut++] = CHARS[(b2 & 0xF) << 1 | (b3 & 0x80) >> 7];
                out[posOut++] = CHARS[(b3 & 0x7C) >> 2];
                out[posOut++] = CHARS[(b3 & 3) << 3];
                out[posOut++] = 61;
            }
        }
        return StringTools.utf8ToString(out);
    }
}

