/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeIdentifierException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.normalizers.NoOpNormalizer;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeUtils {
    public static Attribute removeAttribute(AttributeType type, Attributes entry) {
        Attribute attr = entry.get(type.getOid());
        if (attr == null) {
            List<String> aliases = type.getNames();
            for (String alias : aliases) {
                attr = entry.get(alias);
                if (attr == null) continue;
                return entry.remove(attr.getID());
            }
        }
        if (attr == null) {
            return null;
        }
        return entry.remove(attr.getID());
    }

    public static final boolean equals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null) {
            return value2 == null;
        }
        if (value1 instanceof byte[]) {
            if (value2 instanceof byte[]) {
                return Arrays.equals((byte[])value1, (byte[])value2);
            }
            return false;
        }
        return value1.equals(value2);
    }

    public static Object cloneValue(Object value) {
        Object newValue = null;
        newValue = value instanceof byte[] ? ((byte[])value).clone() : value;
        return newValue;
    }

    public static final Attribute toBasicAttribute(Attribute attribute) {
        if (attribute instanceof BasicAttribute) {
            return attribute;
        }
        BasicAttribute newAttribute = new BasicAttribute(attribute.getID());
        try {
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                newAttribute.add(AttributeUtils.cloneValue(values.next()));
            }
            return newAttribute;
        }
        catch (NamingException ne) {
            return newAttribute;
        }
    }

    public static final Attribute getAttribute(Attributes attrs, AttributeType type) {
        Attribute attr = attrs.get(type.getOid());
        if (attr != null) {
            return attr;
        }
        if (type.getNames().size() == 1 && (attr = attrs.get(type.getNames().get(0))) != null) {
            return attr;
        }
        for (String alias : type.getNames()) {
            attr = attrs.get(alias);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    public static boolean containsValue(Attribute attr, Value<?> compared, AttributeType type) throws NamingException {
        if (attr.contains(compared)) {
            return true;
        }
        MatchingRule matchingRule = type.getEquality();
        Normalizer normalizer = null;
        normalizer = matchingRule != null ? matchingRule.getNormalizer() : new NoOpNormalizer(type.getOid());
        if (type.getSyntax().isHumanReadable()) {
            String comparedStr = normalizer.normalize(compared.getString());
            NamingEnumeration<?> values = attr.getAll();
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (!comparedStr.equals(normalizer.normalize(value))) continue;
                return true;
            }
        } else {
            byte[] comparedBytes = null;
            if (!compared.isBinary()) {
                if (compared.getString().length() < 3) {
                    return false;
                }
                int state = 1;
                comparedBytes = new byte[compared.getString().length() / 3];
                int pos = 0;
                block6: for (char c : compared.getString().toCharArray()) {
                    switch (state) {
                        case 1: {
                            if (c != '\\') {
                                return false;
                            }
                            ++state;
                            continue block6;
                        }
                        case 2: {
                            byte high = StringTools.getHexValue(c);
                            if (high == -1) {
                                return false;
                            }
                            comparedBytes[pos] = (byte)(high << 4);
                            ++state;
                            continue block6;
                        }
                        case 3: {
                            byte low = StringTools.getHexValue(c);
                            if (low == -1) {
                                return false;
                            }
                            int n = pos++;
                            comparedBytes[n] = (byte)(comparedBytes[n] + (byte)low);
                            state = 1;
                        }
                    }
                }
            } else {
                comparedBytes = compared.getBytes();
            }
            NamingEnumeration<?> values = attr.getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                if (!(value instanceof byte[]) || !ArrayUtils.isEquals(comparedBytes, value)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsValueCaseIgnore(Attribute attr, Object value) {
        if (attr.contains(value)) {
            return true;
        }
        try {
            if (value instanceof String) {
                String strVal = (String)value;
                NamingEnumeration<?> attrVals = attr.getAll();
                while (attrVals.hasMoreElements()) {
                    Object attrVal = attrVals.nextElement();
                    if (!(attrVal instanceof String) || !strVal.equalsIgnoreCase((String)attrVal)) continue;
                    return true;
                }
            } else {
                byte[] valueBytes = (byte[])value;
                NamingEnumeration<?> attrVals = attr.getAll();
                while (attrVals.hasMoreElements()) {
                    Object attrVal = attrVals.nextElement();
                    if (!(attrVal instanceof byte[]) || !Arrays.equals((byte[])attrVal, valueBytes)) continue;
                    return true;
                }
            }
        }
        catch (NamingException ne) {
            return false;
        }
        return false;
    }

    public static Attribute getDifference(Attribute attr0, Attribute attr1) throws NamingException {
        int ii;
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException(I18n.err("ERR_04339", new Object[0]));
        }
        if (attr0 == null) {
            return new BasicAttribute(attr1.getID());
        }
        if (attr1 == null) {
            return (Attribute)attr0.clone();
        }
        if (!attr0.getID().equalsIgnoreCase(attr1.getID())) {
            throw new IllegalArgumentException(I18n.err("ERR_04340", new Object[0]));
        }
        String id = attr0.getID();
        BasicAttribute attr = new BasicAttribute(id);
        for (ii = 0; ii < attr0.size(); ++ii) {
            attr.add(attr0.get(ii));
        }
        for (ii = 0; ii < attr1.size(); ++ii) {
            attr.remove(attr1.get(ii));
        }
        return attr;
    }

    public static Attribute getUnion(Attribute attr0, Attribute attr1) throws NamingException {
        int ii;
        String id;
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException(I18n.err("ERR_04341", new Object[0]));
        }
        if (attr0 == null) {
            id = attr1.getID();
        } else if (attr1 == null) {
            id = attr0.getID();
        } else {
            if (!attr0.getID().equalsIgnoreCase(attr1.getID())) {
                throw new IllegalArgumentException(I18n.err("ERR_04342", new Object[0]));
            }
            id = attr0.getID();
        }
        BasicAttribute attr = new BasicAttribute(id);
        if (attr0 != null) {
            for (ii = 0; ii < attr0.size(); ++ii) {
                attr.add(attr0.get(ii));
            }
        }
        if (attr1 != null) {
            for (ii = 0; ii < attr1.size(); ++ii) {
                attr.add(attr1.get(ii));
            }
        }
        return attr;
    }

    public static Attributes toCaseInsensitive(Attributes attributes) {
        if (attributes == null) {
            return attributes;
        }
        if (attributes instanceof BasicAttributes) {
            if (attributes.isCaseIgnored()) {
                return attributes;
            }
            BasicAttributes newAttrs = new BasicAttributes(true);
            NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
            if (attrs != null) {
                while (attrs.hasMoreElements()) {
                    newAttrs.put((Attribute)attrs.nextElement());
                }
            }
            return newAttrs;
        }
        return attributes;
    }

    public static String toString(String tabs, Attribute attribute) {
        StringBuffer sb = new StringBuffer();
        sb.append(tabs).append("Attribute\n");
        if (attribute != null) {
            sb.append(tabs).append("    Type : '").append(attribute.getID()).append("'\n");
            for (int j = 0; j < attribute.size(); ++j) {
                try {
                    Object attr = attribute.get(j);
                    if (attr == null) continue;
                    if (attr instanceof String) {
                        sb.append(tabs).append("        Val[").append(j).append("] : ").append(attr).append(" \n");
                        continue;
                    }
                    if (attr instanceof byte[]) {
                        String string = StringTools.utf8ToString((byte[])attr);
                        sb.append(tabs).append("        Val[").append(j).append("] : ");
                        sb.append(string).append('/');
                        sb.append(StringTools.dumpBytes((byte[])attr));
                        sb.append(" \n");
                        continue;
                    }
                    sb.append(tabs).append("        Val[").append(j).append("] : ").append(attr).append(" \n");
                    continue;
                }
                catch (NamingException ne) {
                    sb.append("Bad attribute : ").append(ne.getMessage());
                }
            }
        }
        return sb.toString();
    }

    public static String toString(Attribute attribute) {
        return AttributeUtils.toString("", attribute);
    }

    public static String toString(String tabs, Attributes attributes) {
        StringBuffer sb = new StringBuffer();
        sb.append(tabs).append("Attributes\n");
        if (attributes != null) {
            NamingEnumeration<? extends Attribute> attributesIterator = attributes.getAll();
            while (attributesIterator.hasMoreElements()) {
                Attribute attribute = (Attribute)attributesIterator.nextElement();
                sb.append(tabs).append(attribute.toString());
            }
        }
        return sb.toString();
    }

    private static void parseOptions(String str, Position pos) throws ParseException {
        while (StringTools.isCharASCII(str, pos.start, ';')) {
            ++pos.start;
            if (!StringTools.isAlphaDigitMinus(str, pos.start)) {
                throw new ParseException(I18n.err("ERR_04343", new Object[0]), pos.start);
            }
            ++pos.start;
            while (StringTools.isAlphaDigitMinus(str, pos.start)) {
                ++pos.start;
            }
        }
    }

    private static boolean parseNumber(String filter, Position pos) {
        char c = StringTools.charAt(filter, pos.start);
        switch (c) {
            case '0': {
                ++pos.start;
                return true;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                ++pos.start;
                break;
            }
            default: {
                return false;
            }
        }
        while (StringTools.isDigit(filter, pos.start)) {
            ++pos.start;
        }
        return true;
    }

    public static void parseOID(String str, Position pos) throws ParseException {
        AttributeUtils.parseNumber(str, pos);
        if (!StringTools.isCharASCII(str, pos.start, '.')) {
            throw new ParseException(I18n.err("ERR_04344", new Object[0]), pos.start);
        }
        ++pos.start;
        if (!AttributeUtils.parseNumber(str, pos)) {
            throw new ParseException(I18n.err("ERR_04345", new Object[0]), pos.start);
        }
        while (StringTools.isCharASCII(str, pos.start, '.')) {
            ++pos.start;
            if (AttributeUtils.parseNumber(str, pos)) continue;
            throw new ParseException(I18n.err("ERR_04345", new Object[0]), pos.start);
        }
    }

    public static String parseAttribute(String str, Position pos, boolean withOption) throws ParseException {
        char c = StringTools.charAt(str, pos.start);
        if (c == '\u0000') {
            throw new ParseException(I18n.err("ERR_04346", new Object[0]), pos.start);
        }
        int start = pos.start++;
        if (StringTools.isAlpha(c)) {
            while (StringTools.isAlphaDigitMinus(str, pos.start)) {
                ++pos.start;
            }
            if (withOption) {
                AttributeUtils.parseOptions(str, pos);
            }
            return str.substring(start, pos.start);
        }
        if (StringTools.isDigit(c)) {
            ++pos.start;
            AttributeUtils.parseOID(str, pos);
            if (withOption) {
                AttributeUtils.parseOptions(str, pos);
            }
            return str.substring(start, pos.start);
        }
        throw new ParseException(I18n.err("ERR_04347", new Object[0]), pos.start);
    }

    public static String toString(Attributes attributes) {
        return AttributeUtils.toString("", attributes);
    }

    public static void applyModification(Entry entry, Modification modification) throws NamingException {
        EntryAttribute modAttr = modification.getAttribute();
        String modificationId = modAttr.getId();
        switch (modification.getOperation()) {
            case ADD_ATTRIBUTE: {
                EntryAttribute modifiedAttr = entry.get(modificationId);
                if (modifiedAttr == null) {
                    entry.put(modAttr);
                    break;
                }
                for (Value value : modAttr) {
                    modifiedAttr.add(value);
                }
                break;
            }
            case REMOVE_ATTRIBUTE: {
                if (modAttr.get() == null) {
                    entry.removeAttributes(modificationId);
                    break;
                }
                EntryAttribute modifiedAttr = entry.get(modificationId);
                if (modifiedAttr == null) break;
                for (Value value : modAttr) {
                    modifiedAttr.remove(value);
                }
                if (modifiedAttr.size() != 0) break;
                entry.removeAttributes(modifiedAttr.getId());
                break;
            }
            case REPLACE_ATTRIBUTE: {
                if (modAttr.get() == null) {
                    entry.removeAttributes(modificationId);
                    break;
                }
                entry.put(modAttr);
            }
        }
    }

    public static Entry toClientEntry(Attributes attributes, DN dn) throws InvalidAttributeIdentifierException {
        if (attributes instanceof BasicAttributes) {
            try {
                DefaultClientEntry entry = new DefaultClientEntry(dn);
                NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
                while (attrs.hasMoreElements()) {
                    Attribute attr = (Attribute)attrs.nextElement();
                    EntryAttribute entryAttribute = AttributeUtils.toClientAttribute(attr);
                    if (entryAttribute == null) continue;
                    entry.put(entryAttribute);
                }
                return entry;
            }
            catch (NamingException ne) {
                throw new InvalidAttributeIdentifierException(ne.getMessage());
            }
        }
        return null;
    }

    public static Attributes toAttributes(Entry entry) {
        if (entry != null) {
            BasicAttributes attributes = new BasicAttributes();
            for (EntryAttribute entryAttribute : entry) {
                attributes.put(AttributeUtils.toAttribute(entryAttribute));
            }
            return attributes;
        }
        return null;
    }

    public static Attribute toAttribute(EntryAttribute entryAttribute) {
        if (entryAttribute != null) {
            BasicAttribute attribute = new BasicAttribute(entryAttribute.getId());
            for (Value value : entryAttribute) {
                attribute.add(value.get());
            }
            return attribute;
        }
        return null;
    }

    public static EntryAttribute toClientAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        try {
            DefaultClientAttribute clientAttribute = new DefaultClientAttribute(attribute.getID());
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                if (value instanceof String) {
                    clientAttribute.add((String)value);
                    continue;
                }
                if (value instanceof byte[]) {
                    clientAttribute.add(new byte[][]{(byte[])value});
                    continue;
                }
                clientAttribute.add(new String[]{null});
            }
            return clientAttribute;
        }
        catch (NamingException ne) {
            return null;
        }
    }
}

