/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NormalizingComparator
extends LdapComparator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizingComparator.class);
    private static final long serialVersionUID = 1L;
    private Normalizer normalizer;
    private LdapComparator<String> comparator;

    public NormalizingComparator(String oid, Normalizer normalizer, LdapComparator<String> comparator) {
        super(oid);
        this.normalizer = normalizer;
        this.comparator = comparator;
    }

    @Override
    public int compare(String o1, String o2) {
        String n2;
        String n1;
        try {
            n1 = this.normalizer.normalize(o1);
        }
        catch (NamingException e) {
            LOG.warn("Failed to normalize: " + o1, e);
            n1 = o1;
        }
        try {
            n2 = this.normalizer.normalize(o2);
        }
        catch (NamingException e) {
            LOG.warn("Failed to normalize: " + o2, e);
            n2 = o2;
        }
        return this.comparator.compare(n1, n2);
    }

    @Override
    public void setOid(String oid) {
        super.setOid(oid);
        this.normalizer.setOid(oid);
        this.comparator.setOid(oid);
    }
}

