/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.name.RdnSerializer;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(DnSerializer.class);

    public static void serialize(DN dn, ObjectOutput out) throws IOException {
        if (dn.getName() == null) {
            String message = "Cannot serialize a NULL DN";
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(dn.getName());
        if (dn.isNormalized()) {
            if (dn.getName().equals(dn.getNormName())) {
                out.writeUTF("");
            } else {
                out.writeUTF(dn.getNormName());
            }
        } else {
            String message = I18n.err("ERR_04212", dn);
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeInt(dn.size());
        for (RDN rdn : dn.getRdns()) {
            RdnSerializer.serialize(rdn, out);
        }
    }

    public static DN deserialize(ObjectInput in) throws IOException {
        String upName = in.readUTF();
        String normName = in.readUTF();
        if (normName.length() == 0) {
            normName = upName;
        }
        byte[] bytes = StringTools.getBytesUtf8(upName);
        int nbRdns = in.readInt();
        DN dn = new DN(upName, normName, bytes);
        for (int i = 0; i < nbRdns; ++i) {
            RDN rdn = RdnSerializer.deserialize(in);
            dn.add(0, rdn);
        }
        return dn;
    }
}

