/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.abandon;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbandonRequestCodec
extends LdapMessageCodec {
    private static Logger LOGGER = LoggerFactory.getLogger(AbandonRequestCodec.class);
    private static final boolean IS_DEBUG = LOGGER.isDebugEnabled();
    private int abandonedMessageId;

    public int getAbandonedMessageId() {
        return this.abandonedMessageId;
    }

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.ABANDON_REQUEST;
    }

    public String getMessageTypeName() {
        return "ABANDON_REQUEST";
    }

    public void setAbandonedMessageId(int abandonedMessageId) {
        this.abandonedMessageId = abandonedMessageId;
    }

    protected int computeLengthProtocolOp() {
        int length = 2 + Value.getNbBytes(this.abandonedMessageId);
        if (IS_DEBUG) {
            LOGGER.debug("Message length : {}", length);
        }
        return length;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)80);
            buffer.put((byte)Value.getNbBytes(this.abandonedMessageId));
            buffer.put(Value.getBytes(this.abandonedMessageId));
        }
        catch (BufferOverflowException boe) {
            String msg = I18n.err("ERR_04005", new Object[0]);
            LOGGER.error(msg);
            throw new EncoderException(msg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Abandon Request :\n");
        sb.append("        Message Id : ").append(this.abandonedMessageId);
        return this.toString(sb.toString());
    }
}

