/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.asn1.util.LongDecoder;
import org.apache.directory.shared.asn1.util.LongDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequestCodec;
import org.apache.directory.shared.ldap.codec.actions.AttributeDescAction;
import org.apache.directory.shared.ldap.codec.actions.ControlValueAction;
import org.apache.directory.shared.ldap.codec.actions.ControlsInitAction;
import org.apache.directory.shared.ldap.codec.actions.ErrorMessageAction;
import org.apache.directory.shared.ldap.codec.actions.InitAndFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitApproxMatchFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitAssertionValueFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitAttributeDescFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitAttributeDescListAction;
import org.apache.directory.shared.ldap.codec.actions.InitEqualityMatchFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitExtensibleMatchFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitGreaterOrEqualFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitLessOrEqualFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitNotFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitOrFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitPresentFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitReferralsAction;
import org.apache.directory.shared.ldap.codec.actions.InitSubstringsFilterAction;
import org.apache.directory.shared.ldap.codec.actions.MatchedDNAction;
import org.apache.directory.shared.ldap.codec.actions.ModifyAttributeValueAction;
import org.apache.directory.shared.ldap.codec.actions.ReferralAction;
import org.apache.directory.shared.ldap.codec.actions.ResponseAction;
import org.apache.directory.shared.ldap.codec.actions.ResponseNameAction;
import org.apache.directory.shared.ldap.codec.actions.ResultCodeAction;
import org.apache.directory.shared.ldap.codec.actions.SearchResultAttributeValueAction;
import org.apache.directory.shared.ldap.codec.actions.ServerSASLCredsAction;
import org.apache.directory.shared.ldap.codec.actions.StoreAnyAction;
import org.apache.directory.shared.ldap.codec.actions.StoreFinalAction;
import org.apache.directory.shared.ldap.codec.actions.StoreMatchValueAction;
import org.apache.directory.shared.ldap.codec.actions.StoreReferenceAction;
import org.apache.directory.shared.ldap.codec.actions.StoreTypeMatchingRuleAction;
import org.apache.directory.shared.ldap.codec.actions.ValueAction;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.SaslCredentials;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.compare.CompareRequestCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareResponseCodec;
import org.apache.directory.shared.ldap.codec.controls.ControlImpl;
import org.apache.directory.shared.ldap.codec.del.DelRequestCodec;
import org.apache.directory.shared.ldap.codec.del.DelResponseCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.codec.intermediate.IntermediateResponseCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponseCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponseCodec;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceCodec;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequestCodec;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AddResponseImpl;
import org.apache.directory.shared.ldap.message.BindResponseImpl;
import org.apache.directory.shared.ldap.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.message.DeleteResponseImpl;
import org.apache.directory.shared.ldap.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.SearchResponseDoneImpl;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapMessageGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(LdapMessageGrammar.class);
    static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new LdapMessageGrammar();

    private LdapMessageGrammar() {
        this.name = LdapMessageGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[115][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, new GrammarAction("LdapMessage initialization"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err("ERR_04066", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04067", new Object[0]));
                }
            }
        });
        this.transitions[1][2] = new GrammarTransition(1, 2, 2, new GrammarAction("Store MessageId"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err("ERR_04068", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04069", new Object[0]));
                }
                Value value = tlv.getValue();
                try {
                    int messageId = IntegerDecoder.parse(value, 0, Integer.MAX_VALUE);
                    ldapMessageContainer.setMessageId(messageId);
                    if (IS_DEBUG) {
                        log.debug("Ldap Message Id has been decoded : " + messageId);
                    }
                }
                catch (IntegerDecoderException ide) {
                    log.error(I18n.err("ERR_04070", StringTools.dumpBytes(value.getData()), ide.getLocalizedMessage()));
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[2][66] = new GrammarTransition(2, 5, 66, new GrammarAction("Unbind Request initialization"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                UnBindRequestCodec unbindRequest = new UnBindRequestCodec();
                unbindRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(unbindRequest);
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength != 0) {
                    log.error(I18n.err("ERR_04071", expectedLength));
                    throw new DecoderException(I18n.err("ERR_04072", new Object[0]));
                }
                ldapMessageContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[5][160] = new GrammarTransition(5, 107, 160, new ControlsInitAction());
        this.transitions[2][74] = new GrammarTransition(2, 14, 74, new GrammarAction("Init del Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                DelRequestCodec delRequest = new DelRequestCodec();
                delRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(delRequest);
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                DN entry = null;
                if (tlv.getLength() == 0) {
                    throw new DecoderException(I18n.err("ERR_04073", new Object[0]));
                }
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = StringTools.utf8ToString(dnBytes);
                try {
                    entry = new DN(dnStr);
                }
                catch (InvalidNameException ine) {
                    String msg = I18n.err("ERR_04074", dnStr, StringTools.dumpBytes(dnBytes), ine.getLocalizedMessage());
                    log.error(msg);
                    DeleteResponseImpl response = new DeleteResponseImpl(delRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, DN.EMPTY_DN, ine);
                }
                delRequest.setEntry(entry);
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Deleting DN {}", entry);
                }
            }
        });
        this.transitions[14][160] = new GrammarTransition(14, 107, 160, new ControlsInitAction());
        this.transitions[2][80] = new GrammarTransition(2, 20, 80, new GrammarAction("Init Abandon Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                AbandonRequestCodec abandonRequest = new AbandonRequestCodec();
                abandonRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(abandonRequest);
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                if (value == null || value.getData() == null) {
                    String msg = I18n.err("ERR_04075", new Object[0]);
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                try {
                    int abandonnedMessageId = IntegerDecoder.parse(value, 0, Integer.MAX_VALUE);
                    abandonRequest.setAbandonedMessageId(abandonnedMessageId);
                    if (IS_DEBUG) {
                        log.debug("AbandonMessage Id has been decoded : {}", abandonnedMessageId);
                    }
                    ldapMessageContainer.grammarEndAllowed(true);
                    return;
                }
                catch (IntegerDecoderException ide) {
                    log.error(I18n.err("ERR_04076", StringTools.dumpBytes(value.getData()), ide.getMessage()));
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[20][160] = new GrammarTransition(20, 107, 160, new ControlsInitAction());
        this.transitions[2][96] = new GrammarTransition(2, 3, 96, new GrammarAction("Init BindRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequestCodec bindRequest = new BindRequestCodec();
                bindRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(bindRequest);
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04077", new Object[0]);
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[3][2] = new GrammarTransition(3, 23, 2, new GrammarAction("Store version"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequestCodec bindRequestMessage = ldapMessageContainer.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    int version = IntegerDecoder.parse(value, 1, 127);
                    if (IS_DEBUG) {
                        log.debug("Ldap version ", version);
                    }
                    bindRequestMessage.setVersion(version);
                }
                catch (IntegerDecoderException ide) {
                    log.error(I18n.err("ERR_04078", StringTools.dumpBytes(value.getData()), ide.getMessage()));
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[23][4] = new GrammarTransition(23, 24, 4, new GrammarAction("Store Bind Name value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequestCodec bindRequestMessage = ldapMessageContainer.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    bindRequestMessage.setName(DN.EMPTY_DN);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = StringTools.utf8ToString(dnBytes);
                    try {
                        DN dn = new DN(dnStr);
                        bindRequestMessage.setName(dn);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Incorrect DN given : " + dnStr + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        BindResponseImpl response = new BindResponseImpl(bindRequestMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, DN.EMPTY_DN, ine);
                    }
                }
                if (IS_DEBUG) {
                    log.debug(" The Bind name is {}", bindRequestMessage.getName());
                }
            }
        });
        this.transitions[24][128] = new GrammarTransition(24, 25, 128, new GrammarAction("Store Bind Simple Authentication value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequestCodec bindRequestMessage = ldapMessageContainer.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SimpleAuthentication authentication = null;
                authentication = new SimpleAuthentication();
                authentication.setParent(bindRequestMessage);
                bindRequestMessage.setAuthentication(authentication);
                if (tlv.getLength() == 0) {
                    authentication.setSimple(StringTools.EMPTY_BYTES);
                } else {
                    authentication.setSimple(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The simple authentication is : {}", (Object)authentication.getSimple());
                }
            }
        });
        this.transitions[25][160] = new GrammarTransition(25, 107, 160, new ControlsInitAction());
        this.transitions[24][163] = new GrammarTransition(24, 26, 163, new GrammarAction("Initialize Bind SASL Authentication"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequestCodec bindRequestMessage = ldapMessageContainer.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04079", new Object[0]);
                    log.error(msg);
                    BindResponseImpl response = new BindResponseImpl(bindRequestMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_CREDENTIALS, bindRequestMessage.getName(), null);
                }
                SaslCredentials authentication = new SaslCredentials();
                authentication.setParent(bindRequestMessage);
                bindRequestMessage.setAuthentication(authentication);
                if (IS_DEBUG) {
                    log.debug("The SaslCredential has been created");
                }
            }
        });
        this.transitions[26][4] = new GrammarTransition(26, 27, 4, new GrammarAction("Store SASL mechanism"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequestCodec bindRequestMessage = ldapMessageContainer.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SaslCredentials authentication = bindRequestMessage.getSaslAuthentication();
                if (tlv.getLength() == 0) {
                    authentication.setMechanism("");
                } else {
                    authentication.setMechanism(StringTools.utf8ToString(tlv.getValue().getData()));
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The mechanism is : {}", (Object)authentication.getMechanism());
                }
            }
        });
        this.transitions[27][4] = new GrammarTransition(27, 28, 4, new GrammarAction("Store SASL credentials"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequestCodec bindRequestMessage = ldapMessageContainer.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SaslCredentials credentials = bindRequestMessage.getSaslAuthentication();
                if (tlv.getLength() == 0) {
                    credentials.setCredentials(StringTools.EMPTY_BYTES);
                } else {
                    credentials.setCredentials(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The credentials are : {}", (Object)credentials.getCredentials());
                }
            }
        });
        this.transitions[27][160] = new GrammarTransition(27, 107, 160, new ControlsInitAction());
        this.transitions[28][160] = new GrammarTransition(28, 107, 160, new ControlsInitAction());
        this.transitions[2][97] = new GrammarTransition(2, 4, 97, new GrammarAction("Init BindReponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindResponseCodec bindResponse = new BindResponseCodec();
                bindResponse.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(bindResponse);
            }
        });
        this.transitions[4][10] = new GrammarTransition(4, 29, 10, new ResultCodeAction());
        this.transitions[29][4] = new GrammarTransition(29, 30, 4, new MatchedDNAction());
        this.transitions[30][4] = new GrammarTransition(30, 31, 4, new ErrorMessageAction());
        this.transitions[31][135] = new GrammarTransition(31, 34, 135, new ServerSASLCredsAction());
        this.transitions[31][163] = new GrammarTransition(31, 32, 163, new InitReferralsAction());
        this.transitions[32][4] = new GrammarTransition(32, 33, 4, new ReferralAction());
        this.transitions[33][4] = new GrammarTransition(33, 33, 4, new ReferralAction());
        this.transitions[33][135] = new GrammarTransition(33, 34, 135, new ServerSASLCredsAction());
        this.transitions[33][160] = new GrammarTransition(33, 107, 160, new ControlsInitAction());
        this.transitions[31][160] = new GrammarTransition(31, 107, 160, new ControlsInitAction());
        this.transitions[34][160] = new GrammarTransition(34, 107, 160, new ControlsInitAction());
        this.transitions[35][4] = new GrammarTransition(35, 36, 4, new MatchedDNAction());
        this.transitions[36][4] = new GrammarTransition(36, 37, 4, new ErrorMessageAction());
        this.transitions[37][163] = new GrammarTransition(37, 38, 163, new GrammarAction("Init referrals list"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapResponseCodec response = ldapMessageContainer.getLdapResponse();
                LdapResultCodec ldapResult = response.getLdapResult();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04080", new Object[0]);
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                ldapResult.initReferrals();
            }
        });
        this.transitions[38][4] = new GrammarTransition(38, 39, 4, new ReferralAction());
        this.transitions[39][4] = new GrammarTransition(39, 39, 4, new ReferralAction());
        this.transitions[39][160] = new GrammarTransition(39, 107, 160, new ControlsInitAction());
        this.transitions[37][160] = new GrammarTransition(37, 107, 160, new ControlsInitAction());
        this.transitions[2][100] = new GrammarTransition(2, 7, 100, new GrammarAction("Init SearchResultEntry"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchResultEntryCodec searchResultEntry = new SearchResultEntryCodec();
                searchResultEntry.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(searchResultEntry);
            }
        });
        this.transitions[7][4] = new GrammarTransition(7, 100, 4, new GrammarAction("Store search result entry object name Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchResultEntryCodec searchResultEntry = ldapMessageContainer.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                DN objectName = DN.EMPTY_DN;
                if (tlv.getLength() == 0) {
                    searchResultEntry.setObjectName(objectName);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = StringTools.utf8ToString(dnBytes);
                    try {
                        objectName = new DN(dnStr);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "The DN " + StringTools.dumpBytes(dnBytes) + "is invalid : " + ine.getMessage();
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        throw new DecoderException(msg, ine);
                    }
                    searchResultEntry.setObjectName(objectName);
                }
                if (IS_DEBUG) {
                    log.debug("Search Result Entry DN found : {}", searchResultEntry.getObjectName());
                }
            }
        });
        this.transitions[100][48] = new GrammarTransition(100, 101, 48, new GrammarAction("Pop and end allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarEndAllowed(true);
            }
        });
        this.transitions[101][48] = new GrammarTransition(101, 102, 48, null);
        this.transitions[101][160] = new GrammarTransition(101, 107, 160, new ControlsInitAction());
        this.transitions[102][4] = new GrammarTransition(102, 103, 4, new GrammarAction("Store search result entry object name Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchResultEntryCodec searchResultEntry = ldapMessageContainer.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                String type = "";
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04081", new Object[0]);
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                type = StringTools.getType(tlv.getValue().getData());
                searchResultEntry.addAttributeValues(type);
                if (IS_DEBUG) {
                    log.debug("Attribute type : {}", (Object)type);
                }
            }
        });
        this.transitions[103][49] = new GrammarTransition(103, 104, 49, new GrammarAction("Grammar end allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarEndAllowed(true);
            }
        });
        this.transitions[104][4] = new GrammarTransition(104, 105, 4, new SearchResultAttributeValueAction());
        this.transitions[104][48] = new GrammarTransition(104, 102, 48, null);
        this.transitions[104][160] = new GrammarTransition(104, 107, 160, new ControlsInitAction());
        this.transitions[105][4] = new GrammarTransition(105, 105, 4, new SearchResultAttributeValueAction());
        this.transitions[105][48] = new GrammarTransition(105, 102, 48, null);
        this.transitions[105][160] = new GrammarTransition(105, 107, 160, new ControlsInitAction());
        this.transitions[2][101] = new GrammarTransition(2, 8, 101, new GrammarAction("Init search Result Done"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchResultDoneCodec searchResultDone = new SearchResultDoneCodec();
                searchResultDone.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(searchResultDone);
                log.debug("Search Result Done found");
            }
        });
        this.transitions[8][10] = new GrammarTransition(8, 35, 10, new ResultCodeAction());
        this.transitions[2][102] = new GrammarTransition(2, 10, 102, new GrammarAction("Init ModifyRequest"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyRequestCodec modifyRequest = new ModifyRequestCodec();
                modifyRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(modifyRequest);
            }
        });
        this.transitions[10][4] = new GrammarTransition(10, 55, 4, new GrammarAction("Store Modify request object Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyRequestCodec modifyRequest = ldapMessageContainer.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                DN object = DN.EMPTY_DN;
                if (tlv.getLength() == 0) {
                    modifyRequest.setObject(object);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = StringTools.utf8ToString(dnBytes);
                    try {
                        object = new DN(dnStr);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Invalid DN given : " + dnStr + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        ModifyResponseImpl response = new ModifyResponseImpl(modifyRequest.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, DN.EMPTY_DN, ine);
                    }
                    modifyRequest.setObject(object);
                }
                if (IS_DEBUG) {
                    log.debug("Modification of DN {}", modifyRequest.getObject());
                }
            }
        });
        this.transitions[55][48] = new GrammarTransition(55, 56, 48, new GrammarAction("Init modifications array list"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyRequestCodec modifyRequest = ldapMessageContainer.getModifyRequest();
                modifyRequest.initModifications();
            }
        });
        this.transitions[56][48] = new GrammarTransition(56, 57, 48, null);
        this.transitions[57][10] = new GrammarTransition(57, 58, 10, new GrammarAction("Store operation type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyRequestCodec modifyRequest = ldapMessageContainer.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int operation = 0;
                try {
                    operation = IntegerDecoder.parse(tlv.getValue(), 0, 2);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err("ERR_04082", StringTools.dumpBytes(tlv.getValue().getData()));
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                modifyRequest.setCurrentOperation(operation);
                if (IS_DEBUG) {
                    switch (operation) {
                        case 0: {
                            log.debug("Modification operation : ADD");
                            break;
                        }
                        case 1: {
                            log.debug("Modification operation : DELETE");
                            break;
                        }
                        case 2: {
                            log.debug("Modification operation : REPLACE");
                        }
                    }
                }
            }
        });
        this.transitions[58][48] = new GrammarTransition(58, 59, 48, null);
        this.transitions[59][4] = new GrammarTransition(59, 60, 4, new GrammarAction("Store type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyRequestCodec modifyRequest = ldapMessageContainer.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                String type = null;
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04083", new Object[0]);
                    log.error(msg);
                    ModifyResponseImpl response = new ModifyResponseImpl(modifyRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, modifyRequest.getObject(), null);
                }
                type = StringTools.getType(tlv.getValue().getData());
                modifyRequest.addAttributeTypeAndValues(type);
                if (IS_DEBUG) {
                    log.debug("Modifying type : {}", (Object)type);
                }
            }
        });
        this.transitions[60][49] = new GrammarTransition(60, 61, 49, new GrammarAction("Init Attribute vals"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.debug("No vals for this attribute");
                }
                ldapMessageContainer.grammarEndAllowed(true);
                log.debug("Some vals are to be decoded");
            }
        });
        this.transitions[61][4] = new GrammarTransition(61, 62, 4, new ModifyAttributeValueAction());
        this.transitions[61][48] = new GrammarTransition(61, 57, 48, null);
        this.transitions[61][160] = new GrammarTransition(61, 107, 160, new ControlsInitAction());
        this.transitions[62][4] = new GrammarTransition(62, 62, 4, new ModifyAttributeValueAction());
        this.transitions[62][48] = new GrammarTransition(62, 57, 48, null);
        this.transitions[62][160] = new GrammarTransition(62, 107, 160, new ControlsInitAction());
        this.transitions[2][103] = new GrammarTransition(2, 11, 103, new GrammarAction("Init ModifyResponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyResponseCodec modifyResponse = new ModifyResponseCodec();
                modifyResponse.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(modifyResponse);
                log.debug("Modify response");
            }
        });
        this.transitions[11][10] = new GrammarTransition(11, 35, 10, new ResultCodeAction());
        this.transitions[2][104] = new GrammarTransition(2, 12, 104, new GrammarAction("Init addRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                AddRequestCodec addRequest = new AddRequestCodec();
                addRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(addRequest);
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04084", new Object[0]);
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[12][4] = new GrammarTransition(12, 49, 4, new GrammarAction("Store add request object Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                AddRequestCodec addRequest = ldapMessageContainer.getAddRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04085", new Object[0]);
                    log.error(msg);
                    AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.NAMING_VIOLATION, DN.EMPTY_DN, null);
                }
                DN entryDn = null;
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = StringTools.utf8ToString(dnBytes);
                try {
                    entryDn = new DN(dnStr);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid DN given : " + dnStr + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, DN.EMPTY_DN, ine);
                }
                addRequest.setEntryDn(entryDn);
                log.debug("Adding an entry with DN : {}", addRequest.getEntry());
            }
        });
        this.transitions[49][48] = new GrammarTransition(49, 50, 48, null);
        this.transitions[50][48] = new GrammarTransition(50, 51, 48, null);
        this.transitions[51][4] = new GrammarTransition(51, 52, 4, new GrammarAction("Store attribute type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                AddRequestCodec addRequest = ldapMessageContainer.getAddRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04086", new Object[0]);
                    log.error(msg);
                    AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, addRequest.getEntry().getDn(), null);
                }
                String type = StringTools.getType(tlv.getValue().getData());
                try {
                    addRequest.addAttributeType(type);
                }
                catch (NamingException ne) {
                    String msg = I18n.err("ERR_04087", new Object[0]);
                    log.error(msg);
                    AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, addRequest.getEntry().getDn(), ne);
                }
                if (IS_DEBUG) {
                    log.debug("Adding type {}", (Object)type);
                }
            }
        });
        this.transitions[52][49] = new GrammarTransition(52, 53, 49, null);
        this.transitions[53][4] = new GrammarTransition(53, 54, 4, new ValueAction());
        this.transitions[54][4] = new GrammarTransition(54, 54, 4, new ValueAction());
        this.transitions[54][48] = new GrammarTransition(54, 51, 48, null);
        this.transitions[54][160] = new GrammarTransition(54, 107, 160, new ControlsInitAction());
        this.transitions[2][105] = new GrammarTransition(2, 13, 105, new GrammarAction("Init AddResponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                AddResponseCodec addResponse = new AddResponseCodec();
                addResponse.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(addResponse);
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength == 0) {
                    String msg = I18n.err("ERR_04088", new Object[0]);
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                log.debug("Add Response");
            }
        });
        this.transitions[13][10] = new GrammarTransition(13, 35, 10, new ResultCodeAction());
        this.transitions[2][107] = new GrammarTransition(2, 15, 107, new GrammarAction("Init DelResponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                DelResponseCodec delResponse = new DelResponseCodec();
                delResponse.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(delResponse);
                log.debug("Del response ");
            }
        });
        this.transitions[15][10] = new GrammarTransition(15, 35, 10, new ResultCodeAction());
        this.transitions[2][108] = new GrammarTransition(2, 16, 108, new GrammarAction("Init Modify DN Request"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyDNRequestCodec modifyDNRequest = new ModifyDNRequestCodec();
                modifyDNRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(modifyDNRequest);
                log.debug("ModifyDn request");
            }
        });
        this.transitions[16][4] = new GrammarTransition(16, 63, 4, new GrammarAction("Store entry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyDNRequestCodec modifyDNRequest = ldapMessageContainer.getModifyDnRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                DN entry = null;
                if (tlv.getLength() == 0) {
                    throw new DecoderException(I18n.err("ERR_04089", new Object[0]));
                }
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = StringTools.utf8ToString(dnBytes);
                try {
                    entry = new DN(dnStr);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid DN given : " + dnStr + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDNRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, DN.EMPTY_DN, ine);
                }
                modifyDNRequest.setEntry(entry);
                if (IS_DEBUG) {
                    log.debug("Modifying DN {}", entry);
                }
            }
        });
        this.transitions[63][4] = new GrammarTransition(63, 64, 4, new GrammarAction("Store new RDN"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyDNRequestCodec modifyDNRequest = ldapMessageContainer.getModifyDnRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                RDN newRdn = null;
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04090", new Object[0]);
                    log.error(msg);
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDNRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDNRequest.getEntry(), null);
                }
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = StringTools.utf8ToString(dnBytes);
                try {
                    DN dn = new DN(dnStr);
                    newRdn = dn.getRdn(0);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid new RDN given : " + dnStr + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDNRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDNRequest.getEntry(), ine);
                }
                modifyDNRequest.setNewRDN(newRdn);
                if (IS_DEBUG) {
                    log.debug("Modifying with new RDN {}", newRdn);
                }
            }
        });
        this.transitions[64][1] = new GrammarTransition(64, 65, 1, new GrammarAction("Store matching dnAttributes Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyDNRequestCodec modifyDNRequest = ldapMessageContainer.getModifyDnRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    modifyDNRequest.setDeleteOldRDN(BooleanDecoder.parse(value));
                }
                catch (BooleanDecoderException bde) {
                    log.error(I18n.err("ERR_04091", StringTools.dumpBytes(value.getData()), bde.getMessage()));
                    throw new DecoderException(bde.getMessage());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        log.debug(" Old RDN attributes will be deleted");
                    } else {
                        log.debug(" Old RDN attributes will be retained");
                    }
                }
            }
        });
        this.transitions[65][128] = new GrammarTransition(65, 66, 128, new GrammarAction("Store new superior"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyDNRequestCodec modifyDNRequest = ldapMessageContainer.getModifyDnRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                DN newSuperior = DN.EMPTY_DN;
                if (tlv.getLength() == 0) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        throw new DecoderException(I18n.err("ERR_04092", new Object[0]));
                    }
                    log.warn("The new superior is null, so we will change the entry");
                    modifyDNRequest.setNewSuperior(newSuperior);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = StringTools.utf8ToString(dnBytes);
                    try {
                        newSuperior = new DN(dnStr);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Invalid new superior DN given : " + dnStr + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDNRequest.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDNRequest.getEntry(), ine);
                    }
                    modifyDNRequest.setNewSuperior(newSuperior);
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("New superior DN {}", newSuperior);
                }
            }
        });
        this.transitions[65][160] = new GrammarTransition(65, 107, 160, new ControlsInitAction());
        this.transitions[66][160] = new GrammarTransition(66, 107, 160, new ControlsInitAction());
        this.transitions[2][109] = new GrammarTransition(2, 17, 109, new GrammarAction("Init ModifyDNResponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ModifyDNResponseCodec modifyDnResponse = new ModifyDNResponseCodec();
                modifyDnResponse.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(modifyDnResponse);
                log.debug("Modify DN response ");
            }
        });
        this.transitions[17][10] = new GrammarTransition(17, 35, 10, new ResultCodeAction());
        this.transitions[2][110] = new GrammarTransition(2, 18, 110, new GrammarAction("Init Compare Request"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                CompareRequestCodec compareRequest = new CompareRequestCodec();
                compareRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(compareRequest);
                log.debug("Compare Request");
            }
        });
        this.transitions[18][4] = new GrammarTransition(18, 67, 4, new GrammarAction("Store entry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                CompareRequestCodec compareRequest = ldapMessageContainer.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                DN entry = null;
                if (tlv.getLength() == 0) {
                    throw new DecoderException(I18n.err("ERR_04089", new Object[0]));
                }
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = StringTools.utf8ToString(dnBytes);
                try {
                    entry = new DN(dnStr);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid DN given : " + dnStr + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    CompareResponseImpl response = new CompareResponseImpl(compareRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, DN.EMPTY_DN, ine);
                }
                compareRequest.setEntry(entry);
                if (IS_DEBUG) {
                    log.debug("Comparing DN {}", entry);
                }
            }
        });
        this.transitions[67][48] = new GrammarTransition(67, 68, 48, null);
        this.transitions[68][4] = new GrammarTransition(68, 69, 4, new GrammarAction("Store attribute desc"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                CompareRequestCodec compareRequest = ldapMessageContainer.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04093", new Object[0]);
                    log.error(msg);
                    CompareResponseImpl response = new CompareResponseImpl(compareRequest.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, compareRequest.getEntry(), null);
                }
                String type = StringTools.getType(tlv.getValue().getData());
                compareRequest.setAttributeDesc(type);
                if (IS_DEBUG) {
                    log.debug("Comparing attribute description {}", (Object)compareRequest.getAttributeDesc());
                }
            }
        });
        this.transitions[69][4] = new GrammarTransition(69, 70, 4, new GrammarAction("Store assertion value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                CompareRequestCodec compareRequest = ldapMessageContainer.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    compareRequest.setAssertionValue("");
                } else if (ldapMessageContainer.isBinary(compareRequest.getAttributeDesc())) {
                    compareRequest.setAssertionValue(tlv.getValue().getData());
                    if (IS_DEBUG) {
                        log.debug("Comparing attribute value {}", (Object)StringTools.dumpBytes((byte[])compareRequest.getAssertionValue()));
                    }
                } else {
                    compareRequest.setAssertionValue(StringTools.utf8ToString(tlv.getValue().getData()));
                    if (log.isDebugEnabled()) {
                        log.debug("Comparing attribute value {}", compareRequest.getAssertionValue());
                    }
                }
                ldapMessageContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[70][160] = new GrammarTransition(70, 107, 160, new ControlsInitAction());
        this.transitions[2][111] = new GrammarTransition(2, 19, 111, new GrammarAction("Init CompareResponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                CompareResponseCodec compareResponse = new CompareResponseCodec();
                compareResponse.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(compareResponse);
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err("ERR_04094", new Object[0]);
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                log.debug("Compare response ");
            }
        });
        this.transitions[19][10] = new GrammarTransition(19, 35, 10, new ResultCodeAction());
        this.transitions[2][115] = new GrammarTransition(2, 9, 115, new GrammarAction("Init SearchResultReference"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchResultReferenceCodec searchResultReference = new SearchResultReferenceCodec();
                searchResultReference.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(searchResultReference);
                log.debug("SearchResultReference response ");
            }
        });
        this.transitions[9][4] = new GrammarTransition(9, 106, 4, new StoreReferenceAction());
        this.transitions[106][4] = new GrammarTransition(106, 106, 4, new StoreReferenceAction());
        this.transitions[106][160] = new GrammarTransition(106, 107, 160, new ControlsInitAction());
        this.transitions[2][119] = new GrammarTransition(2, 21, 119, new GrammarAction("Init Extended Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ExtendedRequestCodec extendedRequest = new ExtendedRequestCodec();
                extendedRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(extendedRequest);
                log.debug("Extended request");
            }
        });
        this.transitions[21][128] = new GrammarTransition(21, 40, 128, new GrammarAction("Store name"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ExtendedRequestCodec extendedRequest = ldapMessageContainer.getExtendedRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err("ERR_04095", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04095", new Object[0]));
                }
                byte[] requestNameBytes = tlv.getValue().getData();
                try {
                    OID oid = new OID(StringTools.utf8ToString(requestNameBytes));
                    extendedRequest.setRequestName(oid);
                }
                catch (DecoderException de) {
                    String msg = "The Request name is not a valid OID : " + StringTools.utf8ToString(requestNameBytes) + " (" + StringTools.dumpBytes(requestNameBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)de.getMessage());
                    throw de;
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("OID read : {}", (Object)extendedRequest.getRequestName());
                }
            }
        });
        this.transitions[40][129] = new GrammarTransition(40, 41, 129, new GrammarAction("Store value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ExtendedRequestCodec extendedRequest = ldapMessageContainer.getExtendedRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    extendedRequest.setRequestValue(StringTools.EMPTY_BYTES);
                } else {
                    extendedRequest.setRequestValue(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Extended value : {}", (Object)extendedRequest.getRequestValue());
                }
            }
        });
        this.transitions[40][160] = new GrammarTransition(40, 107, 160, new ControlsInitAction());
        this.transitions[41][160] = new GrammarTransition(41, 107, 160, new ControlsInitAction());
        this.transitions[2][120] = new GrammarTransition(2, 22, 120, new GrammarAction("Init Extended Reponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ExtendedResponseCodec extendedResponse = new ExtendedResponseCodec();
                extendedResponse.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(extendedResponse);
                log.debug("Extended Response");
            }
        });
        this.transitions[22][10] = new GrammarTransition(22, 44, 10, new ResultCodeAction());
        this.transitions[44][4] = new GrammarTransition(44, 45, 4, new MatchedDNAction());
        this.transitions[45][4] = new GrammarTransition(45, 46, 4, new ErrorMessageAction());
        this.transitions[46][163] = new GrammarTransition(46, 47, 163, new InitReferralsAction());
        this.transitions[47][4] = new GrammarTransition(47, 48, 4, new ReferralAction());
        this.transitions[48][4] = new GrammarTransition(48, 48, 4, new ReferralAction());
        this.transitions[48][138] = new GrammarTransition(48, 42, 138, new ResponseNameAction());
        this.transitions[48][139] = new GrammarTransition(48, 43, 139, new ResponseAction());
        this.transitions[48][160] = new GrammarTransition(48, 107, 160, new ControlsInitAction());
        this.transitions[46][160] = new GrammarTransition(46, 107, 160, new ControlsInitAction());
        this.transitions[46][138] = new GrammarTransition(46, 42, 138, new ResponseNameAction());
        this.transitions[42][139] = new GrammarTransition(42, 43, 139, new ResponseAction());
        this.transitions[42][160] = new GrammarTransition(42, 107, 160, new ControlsInitAction());
        this.transitions[46][139] = new GrammarTransition(46, 43, 139, new ResponseAction());
        this.transitions[43][160] = new GrammarTransition(43, 107, 160, new ControlsInitAction());
        this.transitions[2][121] = new GrammarTransition(2, 112, 121, new GrammarAction("Init Intermediate Response"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                IntermediateResponseCodec intermediateResponse = new IntermediateResponseCodec();
                intermediateResponse.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(intermediateResponse);
                log.debug("Intermediate Response");
            }
        });
        this.transitions[112][128] = new GrammarTransition(112, 113, 128, new GrammarAction("Store response name"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                IntermediateResponseCodec intermediateResponse = ldapMessageContainer.getIntermediateResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err("ERR_04095", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04095", new Object[0]));
                }
                byte[] responseNameBytes = tlv.getValue().getData();
                try {
                    OID oid = new OID(StringTools.utf8ToString(responseNameBytes));
                    intermediateResponse.setResponseName(oid);
                }
                catch (DecoderException de) {
                    String msg = "The Intermediate Response name is not a valid OID : " + StringTools.utf8ToString(responseNameBytes) + " (" + StringTools.dumpBytes(responseNameBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)de.getMessage());
                    throw de;
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("OID read : {}", (Object)intermediateResponse.getResponseName());
                }
            }
        });
        this.transitions[112][129] = new GrammarTransition(112, 114, 129, new GrammarAction("Store response value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                IntermediateResponseCodec intermediateResponse = ldapMessageContainer.getIntermediateResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    intermediateResponse.setResponseValue(StringTools.EMPTY_BYTES);
                } else {
                    intermediateResponse.setResponseValue(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Value read : {}", (Object)StringTools.dumpBytes(intermediateResponse.getResponseValue()));
                }
            }
        });
        this.transitions[113][129] = new GrammarTransition(113, 114, 129, new GrammarAction("Store value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                IntermediateResponseCodec intermediateResponse = ldapMessageContainer.getIntermediateResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    intermediateResponse.setResponseValue(StringTools.EMPTY_BYTES);
                } else {
                    intermediateResponse.setResponseValue(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Response value : {}", (Object)intermediateResponse.getResponseValue());
                }
            }
        });
        this.transitions[113][160] = new GrammarTransition(113, 107, 160, new ControlsInitAction());
        this.transitions[114][160] = new GrammarTransition(114, 107, 160, new ControlsInitAction());
        GrammarAction addControl = new GrammarAction("Add Control"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength == 0) {
                    log.error(I18n.err("ERR_04096", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04096", new Object[0]));
                }
            }
        };
        this.transitions[107][48] = new GrammarTransition(107, 108, 48, addControl);
        this.transitions[108][4] = new GrammarTransition(108, 109, 4, new GrammarAction("Set Control Type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessageCodec message = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Control control = null;
                if (tlv.getLength() == 0) {
                    log.error(I18n.err("ERR_04097", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04097", new Object[0]));
                }
                byte[] value = tlv.getValue().getData();
                String oidValue = StringTools.asciiBytesToString(value);
                if (!OID.isOID(oidValue)) {
                    log.error(I18n.err("ERR_04098", StringTools.dumpBytes(value)));
                    throw new DecoderException(I18n.err("ERR_04099", oidValue));
                }
                control = message.getCodecControl(oidValue);
                if (control == null) {
                    control = new ControlImpl(oidValue);
                }
                message.addControl(control);
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Control OID : " + control.getOid());
                }
            }
        });
        this.transitions[109][1] = new GrammarTransition(109, 110, 4, new GrammarAction("Set Criticality"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessageCodec message = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Control control = message.getCurrentControl();
                Value value = tlv.getValue();
                try {
                    control.setCritical(BooleanDecoder.parse(value));
                }
                catch (BooleanDecoderException bde) {
                    log.error(I18n.err("ERR_04100", StringTools.dumpBytes(value.getData()), bde.getMessage()));
                    throw new DecoderException(bde.getMessage());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Control criticality : " + control.isCritical());
                }
            }
        });
        this.transitions[110][4] = new GrammarTransition(110, 111, 4, new ControlValueAction());
        this.transitions[109][4] = new GrammarTransition(109, 111, 4, new ControlValueAction());
        this.transitions[109][48] = new GrammarTransition(109, 108, 48, addControl);
        this.transitions[110][48] = new GrammarTransition(110, 108, 48, addControl);
        this.transitions[111][48] = new GrammarTransition(111, 108, 48, addControl);
        this.transitions[2][99] = new GrammarTransition(2, 6, 99, new GrammarAction("Init SearchRequest"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = new SearchRequestCodec();
                searchRequest.setMessageId(ldapMessageContainer.getMessageId());
                ldapMessageContainer.setLdapMessage(searchRequest);
                log.debug("Search Request");
            }
        });
        this.transitions[6][4] = new GrammarTransition(6, 71, 4, new GrammarAction("store base object value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                DN baseObject = DN.EMPTY_DN;
                if (tlv.getLength() != 0) {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = StringTools.utf8ToString(dnBytes);
                    try {
                        baseObject = new DN(dnStr);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Invalid root DN given : " + dnStr + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        SearchResponseDoneImpl response = new SearchResponseDoneImpl(searchRequest.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, DN.EMPTY_DN, ine);
                    }
                }
                searchRequest.setBaseObject(baseObject);
                log.debug("Searching with root DN : {}", baseObject);
            }
        });
        this.transitions[71][10] = new GrammarTransition(71, 72, 10, new GrammarAction("store scope value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int scope = 0;
                try {
                    scope = IntegerDecoder.parse(value, 0, 2);
                }
                catch (IntegerDecoderException ide) {
                    log.error(I18n.err("ERR_04101", value.toString()));
                    throw new DecoderException(I18n.err("ERR_04101", value.toString()));
                }
                searchRequest.setScope(SearchScope.getSearchScope(scope));
                if (IS_DEBUG) {
                    switch (scope) {
                        case 0: {
                            log.debug("Searching within BASE_OBJECT scope ");
                            break;
                        }
                        case 1: {
                            log.debug("Searching within SINGLE_LEVEL scope ");
                            break;
                        }
                        case 2: {
                            log.debug("Searching within WHOLE_SUBTREE scope ");
                        }
                    }
                }
            }
        });
        this.transitions[72][10] = new GrammarTransition(72, 73, 10, new GrammarAction("store derefAliases value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int derefAliases = 0;
                try {
                    derefAliases = IntegerDecoder.parse(value, 0, 3);
                }
                catch (IntegerDecoderException ide) {
                    log.error(I18n.err("ERR_04102", value.toString()));
                    throw new DecoderException(I18n.err("ERR_04102", value.toString()));
                }
                searchRequest.setDerefAliases(derefAliases);
                if (IS_DEBUG) {
                    switch (derefAliases) {
                        case 0: {
                            log.debug("Handling object strategy : NEVER_DEREF_ALIASES");
                            break;
                        }
                        case 1: {
                            log.debug("Handling object strategy : DEREF_IN_SEARCHING");
                            break;
                        }
                        case 2: {
                            log.debug("Handling object strategy : DEREF_FINDING_BASE_OBJ");
                            break;
                        }
                        case 3: {
                            log.debug("Handling object strategy : DEREF_ALWAYS");
                        }
                    }
                }
            }
        });
        this.transitions[73][2] = new GrammarTransition(73, 74, 2, new GrammarAction("store sizeLimit value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                long sizeLimit = 0L;
                try {
                    sizeLimit = LongDecoder.parse(value, 0L, Integer.MAX_VALUE);
                }
                catch (LongDecoderException lde) {
                    log.error(I18n.err("ERR_04103", value.toString()));
                    throw new DecoderException(I18n.err("ERR_04103", value.toString()));
                }
                searchRequest.setSizeLimit(sizeLimit);
                if (IS_DEBUG) {
                    log.debug("The sizeLimit value is set to {} objects", sizeLimit);
                }
            }
        });
        this.transitions[74][2] = new GrammarTransition(74, 75, 2, new GrammarAction("store timeLimit value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int timeLimit = 0;
                try {
                    timeLimit = IntegerDecoder.parse(value, 0, Integer.MAX_VALUE);
                }
                catch (IntegerDecoderException ide) {
                    log.error(I18n.err("ERR_04104", value.toString()));
                    throw new DecoderException(I18n.err("ERR_04104", value.toString()));
                }
                searchRequest.setTimeLimit(timeLimit);
                if (IS_DEBUG) {
                    log.debug("The timeLimit value is set to {} seconds", timeLimit);
                }
            }
        });
        this.transitions[75][1] = new GrammarTransition(75, 76, 1, new GrammarAction("store typesOnly value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    searchRequest.setTypesOnly(BooleanDecoder.parse(value));
                }
                catch (BooleanDecoderException bde) {
                    log.error(I18n.err("ERR_04105", StringTools.dumpBytes(value.getData()), bde.getMessage()));
                    throw new DecoderException(bde.getMessage());
                }
                if (IS_DEBUG) {
                    log.debug("The search will return {}", (Object)(searchRequest.isTypesOnly() ? "only attributs type" : "attributes types and values"));
                }
            }
        });
        this.transitions[76][160] = new GrammarTransition(76, 77, 160, new InitAndFilterAction());
        this.transitions[76][161] = new GrammarTransition(76, 78, 161, new InitOrFilterAction());
        this.transitions[76][162] = new GrammarTransition(76, 79, 162, new InitNotFilterAction());
        this.transitions[76][163] = new GrammarTransition(76, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[76][164] = new GrammarTransition(76, 81, 164, new InitSubstringsFilterAction());
        this.transitions[76][165] = new GrammarTransition(76, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[76][166] = new GrammarTransition(76, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[76][135] = new GrammarTransition(76, 84, 135, new InitPresentFilterAction());
        this.transitions[76][168] = new GrammarTransition(76, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[76][169] = new GrammarTransition(76, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[77][160] = new GrammarTransition(77, 77, 160, new InitAndFilterAction());
        this.transitions[77][161] = new GrammarTransition(77, 78, 161, new InitOrFilterAction());
        this.transitions[77][162] = new GrammarTransition(77, 79, 162, new InitNotFilterAction());
        this.transitions[77][163] = new GrammarTransition(77, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[77][164] = new GrammarTransition(77, 81, 164, new InitSubstringsFilterAction());
        this.transitions[77][165] = new GrammarTransition(77, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[77][166] = new GrammarTransition(77, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[77][135] = new GrammarTransition(77, 84, 135, new InitPresentFilterAction());
        this.transitions[77][168] = new GrammarTransition(77, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[77][169] = new GrammarTransition(77, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[78][160] = new GrammarTransition(78, 77, 160, new InitAndFilterAction());
        this.transitions[78][161] = new GrammarTransition(78, 78, 161, new InitOrFilterAction());
        this.transitions[78][162] = new GrammarTransition(78, 79, 162, new InitNotFilterAction());
        this.transitions[78][163] = new GrammarTransition(78, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[78][164] = new GrammarTransition(78, 81, 164, new InitSubstringsFilterAction());
        this.transitions[78][165] = new GrammarTransition(78, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[78][166] = new GrammarTransition(78, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[78][135] = new GrammarTransition(78, 84, 135, new InitPresentFilterAction());
        this.transitions[78][168] = new GrammarTransition(78, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[78][169] = new GrammarTransition(78, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[79][160] = new GrammarTransition(79, 77, 160, new InitAndFilterAction());
        this.transitions[79][161] = new GrammarTransition(79, 78, 161, new InitOrFilterAction());
        this.transitions[79][162] = new GrammarTransition(79, 79, 162, new InitNotFilterAction());
        this.transitions[79][163] = new GrammarTransition(79, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[79][164] = new GrammarTransition(79, 81, 164, new InitSubstringsFilterAction());
        this.transitions[79][165] = new GrammarTransition(79, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[79][166] = new GrammarTransition(79, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[79][135] = new GrammarTransition(79, 84, 135, new InitPresentFilterAction());
        this.transitions[79][168] = new GrammarTransition(79, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[79][169] = new GrammarTransition(79, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[80][4] = new GrammarTransition(80, 87, 4, new InitAttributeDescFilterAction());
        this.transitions[87][4] = new GrammarTransition(87, 88, 4, new InitAssertionValueFilterAction());
        this.transitions[88][160] = new GrammarTransition(88, 77, 160, new InitAndFilterAction());
        this.transitions[88][161] = new GrammarTransition(88, 78, 161, new InitOrFilterAction());
        this.transitions[88][162] = new GrammarTransition(88, 79, 162, new InitNotFilterAction());
        this.transitions[88][163] = new GrammarTransition(88, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[88][164] = new GrammarTransition(88, 81, 164, new InitSubstringsFilterAction());
        this.transitions[88][165] = new GrammarTransition(88, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[88][166] = new GrammarTransition(88, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[88][135] = new GrammarTransition(88, 84, 135, new InitPresentFilterAction());
        this.transitions[88][168] = new GrammarTransition(88, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[88][169] = new GrammarTransition(88, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[88][48] = new GrammarTransition(88, 89, 48, new InitAttributeDescListAction());
        this.transitions[89][4] = new GrammarTransition(89, 90, 4, new AttributeDescAction());
        this.transitions[89][160] = new GrammarTransition(89, 107, 160, new ControlsInitAction());
        this.transitions[90][4] = new GrammarTransition(90, 90, 4, new AttributeDescAction());
        this.transitions[90][160] = new GrammarTransition(90, 107, 160, new ControlsInitAction());
        this.transitions[82][4] = new GrammarTransition(82, 87, 4, new InitAttributeDescFilterAction());
        this.transitions[83][4] = new GrammarTransition(83, 87, 4, new InitAttributeDescFilterAction());
        this.transitions[81][4] = new GrammarTransition(81, 91, 4, new GrammarAction("Store substring filter type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err("ERR_04106", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04106", new Object[0]));
                }
                String type = StringTools.getType(tlv.getValue().getData());
                substringFilter.setType(type);
                searchRequest.setTerminalFilter(substringFilter);
            }
        });
        this.transitions[91][48] = new GrammarTransition(91, 92, 48, new GrammarAction("Substring Filter substringsSequence "){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err("ERR_04107", new Object[0]));
                    throw new DecoderException("The substring sequence is empty");
                }
            }
        });
        this.transitions[92][128] = new GrammarTransition(92, 93, 128, new GrammarAction("Store substring filter initial Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err("ERR_04108", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04108", new Object[0]));
                }
                substringFilter.setInitialSubstrings(StringTools.utf8ToString(tlv.getValue().getData()));
                searchRequest.unstackFilters(container);
            }
        });
        this.transitions[92][129] = new GrammarTransition(92, 94, 129, new StoreAnyAction());
        this.transitions[92][130] = new GrammarTransition(92, 95, 130, new StoreFinalAction());
        this.transitions[93][129] = new GrammarTransition(93, 94, 129, new StoreAnyAction());
        this.transitions[93][130] = new GrammarTransition(93, 95, 130, new StoreFinalAction());
        this.transitions[93][48] = new GrammarTransition(93, 89, 48, new InitAttributeDescListAction());
        this.transitions[93][160] = new GrammarTransition(93, 77, 160, new InitAndFilterAction());
        this.transitions[93][161] = new GrammarTransition(93, 78, 161, new InitOrFilterAction());
        this.transitions[93][162] = new GrammarTransition(93, 79, 162, new InitNotFilterAction());
        this.transitions[93][163] = new GrammarTransition(93, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[93][164] = new GrammarTransition(93, 81, 164, new InitSubstringsFilterAction());
        this.transitions[93][165] = new GrammarTransition(93, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[93][166] = new GrammarTransition(93, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[93][135] = new GrammarTransition(93, 84, 135, new InitPresentFilterAction());
        this.transitions[93][168] = new GrammarTransition(93, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[93][169] = new GrammarTransition(93, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[94][130] = new GrammarTransition(94, 95, 130, new StoreFinalAction());
        this.transitions[94][129] = new GrammarTransition(94, 94, 129, new StoreAnyAction());
        this.transitions[94][48] = new GrammarTransition(94, 89, 48, new InitAttributeDescListAction());
        this.transitions[94][160] = new GrammarTransition(94, 77, 160, new InitAndFilterAction());
        this.transitions[94][161] = new GrammarTransition(94, 78, 161, new InitOrFilterAction());
        this.transitions[94][162] = new GrammarTransition(94, 79, 162, new InitNotFilterAction());
        this.transitions[94][163] = new GrammarTransition(94, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[94][164] = new GrammarTransition(94, 81, 164, new InitSubstringsFilterAction());
        this.transitions[94][165] = new GrammarTransition(94, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[94][166] = new GrammarTransition(94, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[94][135] = new GrammarTransition(94, 84, 135, new InitPresentFilterAction());
        this.transitions[94][168] = new GrammarTransition(94, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[94][169] = new GrammarTransition(94, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[95][48] = new GrammarTransition(95, 89, 48, new InitAttributeDescListAction());
        this.transitions[95][160] = new GrammarTransition(95, 77, 160, new InitAndFilterAction());
        this.transitions[95][161] = new GrammarTransition(95, 78, 161, new InitOrFilterAction());
        this.transitions[95][162] = new GrammarTransition(95, 79, 162, new InitNotFilterAction());
        this.transitions[95][163] = new GrammarTransition(95, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[95][164] = new GrammarTransition(95, 81, 164, new InitSubstringsFilterAction());
        this.transitions[95][165] = new GrammarTransition(95, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[95][166] = new GrammarTransition(95, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[95][135] = new GrammarTransition(95, 84, 135, new InitPresentFilterAction());
        this.transitions[95][168] = new GrammarTransition(95, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[95][169] = new GrammarTransition(95, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[84][160] = new GrammarTransition(84, 77, 160, new InitAndFilterAction());
        this.transitions[84][161] = new GrammarTransition(84, 78, 161, new InitOrFilterAction());
        this.transitions[84][162] = new GrammarTransition(84, 79, 162, new InitNotFilterAction());
        this.transitions[84][163] = new GrammarTransition(84, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[84][164] = new GrammarTransition(84, 81, 164, new InitSubstringsFilterAction());
        this.transitions[84][165] = new GrammarTransition(84, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[84][166] = new GrammarTransition(84, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[84][135] = new GrammarTransition(84, 84, 135, new InitPresentFilterAction());
        this.transitions[84][168] = new GrammarTransition(84, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[84][169] = new GrammarTransition(84, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[84][48] = new GrammarTransition(84, 89, 48, new InitAttributeDescListAction());
        this.transitions[85][4] = new GrammarTransition(85, 87, 4, new InitAttributeDescFilterAction());
        this.transitions[86][129] = new GrammarTransition(86, 96, 129, new GrammarAction("Store matching rule Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err("ERR_04109", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04109", new Object[0]));
                }
                extensibleMatchFilter.setMatchingRule(StringTools.utf8ToString(tlv.getValue().getData()));
            }
        });
        this.transitions[86][130] = new GrammarTransition(86, 97, 130, new StoreTypeMatchingRuleAction());
        this.transitions[86][131] = new GrammarTransition(86, 98, 131, new StoreMatchValueAction());
        this.transitions[96][130] = new GrammarTransition(96, 97, 130, new StoreTypeMatchingRuleAction());
        this.transitions[96][131] = new GrammarTransition(96, 98, 131, new StoreMatchValueAction());
        this.transitions[97][131] = new GrammarTransition(97, 98, 131, new StoreMatchValueAction());
        this.transitions[98][132] = new GrammarTransition(98, 99, 132, new GrammarAction("Store matching dnAttributes Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
                Value value = tlv.getValue();
                try {
                    extensibleMatchFilter.setDnAttributes(BooleanDecoder.parse(value));
                }
                catch (BooleanDecoderException bde) {
                    log.error(I18n.err("ERR_04110", StringTools.dumpBytes(value.getData()), bde.getMessage()));
                    throw new DecoderException(bde.getMessage());
                }
                if (IS_DEBUG) {
                    log.debug("DN Attributes : {}", extensibleMatchFilter.isDnAttributes());
                }
                searchRequest.unstackFilters(ldapMessageContainer);
            }
        });
        this.transitions[98][160] = new GrammarTransition(98, 77, 160, new InitAndFilterAction());
        this.transitions[98][161] = new GrammarTransition(98, 78, 161, new InitOrFilterAction());
        this.transitions[98][162] = new GrammarTransition(98, 79, 162, new InitNotFilterAction());
        this.transitions[98][163] = new GrammarTransition(98, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[98][164] = new GrammarTransition(98, 81, 164, new InitSubstringsFilterAction());
        this.transitions[98][165] = new GrammarTransition(98, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[98][166] = new GrammarTransition(98, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[98][135] = new GrammarTransition(98, 84, 135, new InitPresentFilterAction());
        this.transitions[98][168] = new GrammarTransition(98, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[98][169] = new GrammarTransition(98, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[98][48] = new GrammarTransition(98, 89, 48, new InitAttributeDescListAction());
        this.transitions[99][160] = new GrammarTransition(99, 77, 160, new InitAndFilterAction());
        this.transitions[99][161] = new GrammarTransition(99, 78, 161, new InitOrFilterAction());
        this.transitions[99][162] = new GrammarTransition(99, 79, 162, new InitNotFilterAction());
        this.transitions[99][163] = new GrammarTransition(99, 80, 163, new InitEqualityMatchFilterAction());
        this.transitions[99][164] = new GrammarTransition(99, 81, 164, new InitSubstringsFilterAction());
        this.transitions[99][165] = new GrammarTransition(99, 82, 165, new InitGreaterOrEqualFilterAction());
        this.transitions[99][166] = new GrammarTransition(99, 83, 166, new InitLessOrEqualFilterAction());
        this.transitions[99][135] = new GrammarTransition(99, 84, 135, new InitPresentFilterAction());
        this.transitions[99][168] = new GrammarTransition(99, 85, 168, new InitApproxMatchFilterAction());
        this.transitions[99][169] = new GrammarTransition(99, 86, 169, new InitExtensibleMatchFilterAction());
        this.transitions[99][48] = new GrammarTransition(99, 89, 48, new InitAttributeDescListAction());
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

